/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.EmptyHttpHeaders;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.multipart.Attribute;
import io.netty.handler.codec.http.multipart.HttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpPostRequestDecoder;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.Cookie;
import io.vertx.core.http.HttpConnection;
import io.vertx.core.http.HttpFrame;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerFileUpload;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.core.http.StreamPriority;
import io.vertx.core.http.impl.Http1xServerConnection;
import io.vertx.core.http.impl.Http1xServerResponse;
import io.vertx.core.http.impl.HttpEventHandler;
import io.vertx.core.http.impl.HttpServerRequestInternal;
import io.vertx.core.http.impl.HttpUtils;
import io.vertx.core.http.impl.NettyFileUpload;
import io.vertx.core.http.impl.NettyFileUploadDataFactory;
import io.vertx.core.http.impl.headers.HeadersAdaptor;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.net.HostAndPort;
import io.vertx.core.net.NetSocket;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.spi.metrics.HttpServerMetrics;
import io.vertx.core.spi.metrics.Metrics;
import io.vertx.core.spi.observability.HttpRequest;
import io.vertx.core.spi.tracing.SpanKind;
import io.vertx.core.spi.tracing.TagExtractor;
import io.vertx.core.spi.tracing.VertxTracer;
import io.vertx.core.streams.impl.InboundBuffer;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.security.cert.X509Certificate;

public class Http1xServerRequest
extends HttpServerRequestInternal
implements HttpRequest {
    private static final Logger log = LoggerFactory.getLogger(Http1xServerRequest.class);
    private final Http1xServerConnection conn;
    final ContextInternal context;
    private io.netty.handler.codec.http.HttpRequest request;
    private HttpVersion version;
    private HttpMethod method;
    private HostAndPort authority;
    private String uri;
    private String path;
    private String query;
    Http1xServerRequest next;
    Object metric;
    Object trace;
    private Http1xServerResponse response;
    private Charset paramsCharset = StandardCharsets.UTF_8;
    private MultiMap params;
    private MultiMap headers;
    private String absoluteURI;
    private HttpEventHandler eventHandler;
    private Handler<HttpServerFileUpload> uploadHandler;
    private MultiMap attributes;
    private HttpPostRequestDecoder decoder;
    private boolean ended;
    private long bytesRead;
    private InboundBuffer<Object> pending;

    Http1xServerRequest(Http1xServerConnection conn, io.netty.handler.codec.http.HttpRequest request, ContextInternal context) {
        this.conn = conn;
        this.context = context;
        this.request = request;
    }

    private HttpEventHandler eventHandler(boolean create) {
        if (this.eventHandler == null && create) {
            this.eventHandler = new HttpEventHandler(this.context);
        }
        return this.eventHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    io.netty.handler.codec.http.HttpRequest nettyRequest() {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            return this.request;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setRequest(io.netty.handler.codec.http.HttpRequest request) {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            this.request = request;
        }
    }

    private InboundBuffer<Object> pendingQueue() {
        if (this.pending == null) {
            this.pending = new InboundBuffer(this.context, 8L);
            this.pending.drainHandler(v -> this.conn.doResume());
            this.pending.handler((E buffer) -> {
                if (buffer == InboundBuffer.END_SENTINEL) {
                    this.onEnd();
                } else {
                    this.onData((Buffer)buffer);
                }
            });
        }
        return this.pending;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleContent(Buffer buffer) {
        InboundBuffer<Object> queue;
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            queue = this.pending;
        }
        if (queue != null) {
            if (!queue.write(buffer)) {
                this.conn.doPause();
            }
        } else {
            this.context.execute(buffer, this::onData);
        }
    }

    void handleBegin(boolean writable, boolean keepAlive) {
        if (Metrics.METRICS_ENABLED) {
            this.reportRequestBegin();
        }
        this.response = new Http1xServerResponse((VertxInternal)this.conn.vertx(), this.context, this.conn, this.request, this.metric, writable, keepAlive);
        if (this.conn.handle100ContinueAutomatically) {
            this.check100();
        }
    }

    void enqueue(Http1xServerRequest request) {
        Http1xServerRequest current = this;
        while (current.next != null) {
            current = current.next;
        }
        current.next = request;
    }

    Http1xServerRequest next() {
        return this.next;
    }

    private void check100() {
        if (HttpUtil.is100ContinueExpected((HttpMessage)this.request)) {
            this.conn.write100Continue();
        }
    }

    @Override
    public Object metric() {
        return this.metric;
    }

    Object trace() {
        return this.trace;
    }

    @Override
    public Context context() {
        return this.context;
    }

    @Override
    public int id() {
        return 0;
    }

    @Override
    public HttpVersion version() {
        if (this.version == null) {
            io.netty.handler.codec.http.HttpVersion nettyVersion = this.request.protocolVersion();
            if (nettyVersion == io.netty.handler.codec.http.HttpVersion.HTTP_1_0) {
                this.version = HttpVersion.HTTP_1_0;
            } else if (nettyVersion == io.netty.handler.codec.http.HttpVersion.HTTP_1_1) {
                this.version = HttpVersion.HTTP_1_1;
            }
        }
        return this.version;
    }

    @Override
    public HttpMethod method() {
        if (this.method == null) {
            this.method = HttpMethod.fromNetty(this.request.method());
        }
        return this.method;
    }

    @Override
    public String uri() {
        if (this.uri == null) {
            this.uri = this.request.uri();
        }
        return this.uri;
    }

    @Override
    public String path() {
        if (this.path == null) {
            this.path = HttpUtils.parsePath(this.uri());
        }
        return this.path;
    }

    @Override
    public String query() {
        if (this.query == null) {
            this.query = HttpUtils.parseQuery(this.uri());
        }
        return this.query;
    }

    @Override
    public synchronized HostAndPort authority() {
        String host;
        if (this.authority == null && (host = this.getHeader((CharSequence)HttpHeaderNames.HOST)) != null) {
            this.authority = HostAndPort.parseAuthority(host, -1);
        }
        return this.authority;
    }

    @Override
    public @Nullable String host() {
        return this.getHeader((CharSequence)HttpHeaderNames.HOST);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long bytesRead() {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            return this.bytesRead;
        }
    }

    @Override
    public Http1xServerResponse response() {
        return this.response;
    }

    @Override
    public MultiMap headers() {
        if (this.headers == null) {
            HttpHeaders reqHeaders = this.request.headers();
            this.headers = reqHeaders instanceof MultiMap ? (MultiMap)reqHeaders : new HeadersAdaptor(reqHeaders);
        }
        return this.headers;
    }

    @Override
    public HttpServerRequest setParamsCharset(String charset) {
        Objects.requireNonNull(charset, "Charset must not be null");
        Charset current = this.paramsCharset;
        this.paramsCharset = Charset.forName(charset);
        if (!this.paramsCharset.equals(current)) {
            this.params = null;
        }
        return this;
    }

    @Override
    public String getParamsCharset() {
        return this.paramsCharset.name();
    }

    @Override
    public MultiMap params() {
        if (this.params == null) {
            this.params = HttpUtils.params(this.uri(), this.paramsCharset);
        }
        return this.params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerRequest handler(Handler<Buffer> handler) {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            HttpEventHandler eventHandler;
            if (handler != null) {
                this.checkEnded();
            }
            if ((eventHandler = this.eventHandler(handler != null)) != null) {
                eventHandler.chunkHandler(handler);
            }
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerRequest exceptionHandler(Handler<Throwable> handler) {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            HttpEventHandler eventHandler = this.eventHandler(handler != null);
            if (eventHandler != null) {
                eventHandler.exceptionHandler(handler);
            }
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerRequest pause() {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            this.pendingQueue().pause();
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerRequest fetch(long amount) {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            this.pendingQueue().fetch(amount);
            return this;
        }
    }

    @Override
    public HttpServerRequest resume() {
        return this.fetch(Long.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerRequest endHandler(Handler<Void> handler) {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            HttpEventHandler eventHandler;
            if (handler != null) {
                this.checkEnded();
            }
            if ((eventHandler = this.eventHandler(handler != null)) != null) {
                eventHandler.endHandler(handler);
            }
            return this;
        }
    }

    @Override
    public String scheme() {
        return this.isSSL() ? "https" : "http";
    }

    @Override
    public String absoluteURI() {
        if (this.absoluteURI == null) {
            try {
                this.absoluteURI = HttpUtils.absoluteURI(this.conn.getServerOrigin(), this);
            }
            catch (URISyntaxException e) {
                log.error("Failed to create abs uri", e);
            }
        }
        return this.absoluteURI;
    }

    @Override
    public SocketAddress remoteAddress() {
        return super.remoteAddress();
    }

    @Override
    public X509Certificate[] peerCertificateChain() throws SSLPeerUnverifiedException {
        return this.conn.peerCertificateChain();
    }

    @Override
    public Future<NetSocket> toNetSocket() {
        return this.response.netSocket(this.method(), this.headers());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerRequest uploadHandler(Handler<HttpServerFileUpload> handler) {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            if (handler != null) {
                this.checkEnded();
            }
            this.uploadHandler = handler;
            return this;
        }
    }

    @Override
    public MultiMap formAttributes() {
        return this.attributes();
    }

    @Override
    public String getFormAttribute(String attributeName) {
        return this.formAttributes().get(attributeName);
    }

    @Override
    public Future<ServerWebSocket> toWebSocket() {
        return this.webSocket().map(ws -> {
            ws.accept();
            return ws;
        });
    }

    Future<ServerWebSocket> webSocket() {
        PromiseInternal<ServerWebSocket> promise = this.context.promise();
        this.webSocket(promise);
        return promise.future();
    }

    private void webSocket(PromiseInternal<ServerWebSocket> promise) {
        Buffer body = Buffer.buffer();
        boolean[] failed = new boolean[1];
        this.handler(buff -> {
            if (!failed[0]) {
                body.appendBuffer((Buffer)buff);
                if (body.length() > 8192) {
                    failed[0] = true;
                    this.response.setStatusCode(413).end();
                    this.response.close();
                }
            }
        });
        this.exceptionHandler(promise::tryFail);
        this.endHandler(v -> {
            if (!failed[0]) {
                this.request = new DefaultFullHttpRequest(this.request.protocolVersion(), this.request.method(), this.request.uri(), body.getByteBuf(), this.request.headers(), (HttpHeaders)EmptyHttpHeaders.INSTANCE);
                this.conn.createWebSocket(this, promise);
            }
        });
        this.resume();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerRequest setExpectMultipart(boolean expect) {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            this.checkEnded();
            if (expect) {
                if (this.decoder == null) {
                    String contentType = this.request.headers().get((CharSequence)HttpHeaderNames.CONTENT_TYPE);
                    if (contentType == null) {
                        throw new IllegalStateException("Request must have a content-type header to decode a multipart request");
                    }
                    if (!HttpUtils.isValidMultipartContentType(contentType)) {
                        throw new IllegalStateException("Request must have a valid content-type header to decode a multipart request");
                    }
                    if (!HttpUtils.isValidMultipartMethod(this.request.method())) {
                        throw new IllegalStateException("Request method must be one of POST, PUT, PATCH or DELETE to decode a multipart request");
                    }
                    NettyFileUploadDataFactory factory = new NettyFileUploadDataFactory(this.context, this, () -> this.uploadHandler);
                    factory.setMaxLimit(this.conn.options.getMaxFormAttributeSize());
                    this.decoder = new HttpPostRequestDecoder((HttpDataFactory)factory, this.request);
                }
            } else {
                this.decoder = null;
            }
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isExpectMultipart() {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            return this.decoder != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEnded() {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            return this.ended && (this.pending == null || !this.pending.isPaused() && this.pending.isEmpty());
        }
    }

    @Override
    public HttpServerRequest customFrameHandler(Handler<HttpFrame> handler) {
        return this;
    }

    @Override
    public HttpConnection connection() {
        return this.conn;
    }

    @Override
    public synchronized Future<Buffer> body() {
        this.checkEnded();
        return this.eventHandler(true).body();
    }

    @Override
    public synchronized Future<Void> end() {
        this.checkEnded();
        return this.eventHandler(true).end();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onData(Buffer data) {
        HttpEventHandler handler;
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            this.bytesRead += (long)data.length();
            if (this.decoder != null) {
                try {
                    this.decoder.offer((HttpContent)new DefaultHttpContent(data.getByteBuf()));
                }
                catch (HttpPostRequestDecoder.ErrorDataDecoderException e) {
                    this.handleException(e);
                }
            }
            handler = this.eventHandler;
        }
        if (handler != null) {
            this.eventHandler.handleChunk(data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleEnd() {
        InboundBuffer<Object> queue;
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            this.ended = true;
            queue = this.pending;
        }
        if (queue != null) {
            queue.write(InboundBuffer.END_SENTINEL);
        } else {
            this.onEnd();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onEnd() {
        HttpEventHandler handler;
        if (Metrics.METRICS_ENABLED) {
            this.reportRequestComplete();
        }
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            if (this.decoder != null) {
                this.endDecode();
            }
            handler = this.eventHandler;
        }
        if (handler != null) {
            handler.handleEnd();
        }
    }

    private void reportRequestComplete() {
        HttpServerMetrics metrics = this.conn.metrics;
        if (metrics != null) {
            metrics.requestEnd(this.metric, this, this.bytesRead);
            this.conn.flushBytesRead();
        }
    }

    private void reportRequestBegin() {
        VertxTracer tracer;
        HttpServerMetrics metrics = this.conn.metrics;
        if (metrics != null) {
            this.metric = metrics.requestBegin(this.conn.metric(), this);
        }
        if ((tracer = this.context.tracer()) != null) {
            this.trace = tracer.receiveRequest(this.context, SpanKind.RPC, this.conn.tracingPolicy(), this, this.request.method().name(), (Iterable<Map.Entry<String, String>>)this.request.headers(), HttpUtils.SERVER_REQUEST_TAG_EXTRACTOR);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void endDecode() {
        try {
            this.decoder.offer((HttpContent)LastHttpContent.EMPTY_LAST_CONTENT);
            while (this.decoder.hasNext()) {
                InterfaceHttpData data = this.decoder.next();
                if (!(data instanceof Attribute)) continue;
                Attribute attr = (Attribute)data;
                try {
                    this.attributes().add(attr.getName(), attr.getValue());
                }
                catch (Exception e) {
                    this.handleException(e);
                }
                finally {
                    attr.release();
                }
            }
        }
        catch (HttpPostRequestDecoder.ErrorDataDecoderException e) {
            this.handleException(e);
        }
        catch (HttpPostRequestDecoder.EndOfDataDecoderException endOfDataDecoderException) {
        }
        finally {
            this.decoder.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleException(Throwable t) {
        HttpEventHandler handler = null;
        Http1xServerResponse resp = null;
        InterfaceHttpData upload = null;
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            if (!this.isEnded()) {
                handler = this.eventHandler;
                if (this.decoder != null) {
                    upload = this.decoder.currentPartialHttpData();
                }
            }
            if (!this.response.ended()) {
                if (Metrics.METRICS_ENABLED) {
                    this.reportRequestReset(t);
                }
                resp = this.response;
            }
        }
        if (resp != null) {
            resp.handleException(t);
        }
        if (upload instanceof NettyFileUpload) {
            ((NettyFileUpload)upload).handleException(t);
        }
        if (handler != null) {
            handler.handleException(t);
        }
    }

    private void reportRequestReset(Throwable err) {
        VertxTracer tracer;
        if (this.conn.metrics != null) {
            this.conn.metrics.requestReset(this.metric);
        }
        if ((tracer = this.context.tracer()) != null) {
            tracer.sendResponse(this.context, null, this.trace, err, TagExtractor.empty());
        }
    }

    private void checkEnded() {
        if (this.isEnded()) {
            throw new IllegalStateException("Request has already been read");
        }
    }

    private MultiMap attributes() {
        if (this.attributes == null) {
            this.attributes = MultiMap.caseInsensitiveMultiMap();
        }
        return this.attributes;
    }

    @Override
    public HttpServerRequest streamPriorityHandler(Handler<StreamPriority> handler) {
        return this;
    }

    @Override
    public DecoderResult decoderResult() {
        return this.request.decoderResult();
    }

    @Override
    public Set<Cookie> cookies() {
        return this.response.cookies();
    }

    @Override
    public Set<Cookie> cookies(String name) {
        return this.response.cookies().getAll(name);
    }

    @Override
    public Cookie getCookie(String name) {
        return this.response.cookies().get(name);
    }

    @Override
    public Cookie getCookie(String name, String domain, String path) {
        return this.response.cookies().get(name, domain, path);
    }

    @Override
    public HttpServerRequest routed(String route) {
        if (Metrics.METRICS_ENABLED && !this.response.ended() && this.conn.metrics != null) {
            this.conn.metrics.requestRouted(this.metric, route);
        }
        return this;
    }
}

