/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shade.io.vertx.core.http;

import org.apache.kyuubi.shade.io.vertx.codegen.annotations.CacheReturn;
import org.apache.kyuubi.shade.io.vertx.codegen.annotations.Fluent;
import org.apache.kyuubi.shade.io.vertx.codegen.annotations.GenIgnore;
import org.apache.kyuubi.shade.io.vertx.codegen.annotations.VertxGen;
import org.apache.kyuubi.shade.io.vertx.core.AsyncResult;
import org.apache.kyuubi.shade.io.vertx.core.Future;
import org.apache.kyuubi.shade.io.vertx.core.Handler;
import org.apache.kyuubi.shade.io.vertx.core.http.HttpConnection;
import org.apache.kyuubi.shade.io.vertx.core.http.HttpServerRequest;
import org.apache.kyuubi.shade.io.vertx.core.http.ServerWebSocket;
import org.apache.kyuubi.shade.io.vertx.core.metrics.Measured;
import org.apache.kyuubi.shade.io.vertx.core.net.SSLOptions;
import org.apache.kyuubi.shade.io.vertx.core.net.SocketAddress;
import org.apache.kyuubi.shade.io.vertx.core.net.TrafficShapingOptions;
import org.apache.kyuubi.shade.io.vertx.core.net.impl.SocketAddressImpl;
import org.apache.kyuubi.shade.io.vertx.core.streams.ReadStream;

@VertxGen
public interface HttpServer
extends Measured {
    @Deprecated
    @CacheReturn
    public ReadStream<HttpServerRequest> requestStream();

    @Fluent
    public HttpServer requestHandler(Handler<HttpServerRequest> var1);

    @GenIgnore
    public Handler<HttpServerRequest> requestHandler();

    public HttpServer invalidRequestHandler(Handler<HttpServerRequest> var1);

    @Fluent
    public HttpServer connectionHandler(Handler<HttpConnection> var1);

    @Fluent
    public HttpServer exceptionHandler(Handler<Throwable> var1);

    @Deprecated
    @CacheReturn
    public ReadStream<ServerWebSocket> webSocketStream();

    @Fluent
    public HttpServer webSocketHandler(Handler<ServerWebSocket> var1);

    @GenIgnore
    public Handler<ServerWebSocket> webSocketHandler();

    default public Future<Boolean> updateSSLOptions(SSLOptions options) {
        return this.updateSSLOptions(options, false);
    }

    default public void updateSSLOptions(SSLOptions options, Handler<AsyncResult<Boolean>> handler) {
        Future<Boolean> fut = this.updateSSLOptions(options);
        if (handler != null) {
            fut.onComplete(handler);
        }
    }

    public Future<Boolean> updateSSLOptions(SSLOptions var1, boolean var2);

    default public void updateSSLOptions(SSLOptions options, boolean force, Handler<AsyncResult<Boolean>> handler) {
        Future<Boolean> fut = this.updateSSLOptions(options, force);
        if (handler != null) {
            fut.onComplete(handler);
        }
    }

    public void updateTrafficShapingOptions(TrafficShapingOptions var1);

    public Future<HttpServer> listen();

    default public Future<HttpServer> listen(int port, String host) {
        return this.listen(new SocketAddressImpl(port, host));
    }

    @Fluent
    default public HttpServer listen(int port, String host, Handler<AsyncResult<HttpServer>> listenHandler) {
        Future<HttpServer> fut = this.listen(port, host);
        if (listenHandler != null) {
            fut.onComplete(listenHandler);
        }
        return this;
    }

    @Fluent
    default public HttpServer listen(SocketAddress address, Handler<AsyncResult<HttpServer>> listenHandler) {
        Future<HttpServer> fut = this.listen(address);
        if (listenHandler != null) {
            fut.onComplete(listenHandler);
        }
        return this;
    }

    public Future<HttpServer> listen(SocketAddress var1);

    default public Future<HttpServer> listen(int port) {
        return this.listen(port, "0.0.0.0");
    }

    @Fluent
    default public HttpServer listen(int port, Handler<AsyncResult<HttpServer>> listenHandler) {
        Future<HttpServer> fut = this.listen(port);
        if (listenHandler != null) {
            fut.onComplete(listenHandler);
        }
        return this;
    }

    @Fluent
    default public HttpServer listen(Handler<AsyncResult<HttpServer>> listenHandler) {
        Future<HttpServer> fut = this.listen();
        if (listenHandler != null) {
            fut.onComplete(listenHandler);
        }
        return this;
    }

    public Future<Void> close();

    public void close(Handler<AsyncResult<Void>> var1);

    public int actualPort();
}

