/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger.readers.operation;

import io.swagger.annotations.ApiImplicitParam;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import springfox.documentation.builders.ExampleBuilder;
import springfox.documentation.builders.ModelSpecificationBuilder;
import springfox.documentation.builders.ParameterBuilder;
import springfox.documentation.builders.RequestParameterBuilder;
import springfox.documentation.common.Compatibility;
import springfox.documentation.schema.CollectionType;
import springfox.documentation.schema.ModelKey;
import springfox.documentation.schema.ModelKeyBuilder;
import springfox.documentation.schema.ModelRef;
import springfox.documentation.schema.ModelReference;
import springfox.documentation.schema.ModelSpecification;
import springfox.documentation.schema.ScalarTypes;
import springfox.documentation.schema.Types;
import springfox.documentation.schema.property.PackageNames;
import springfox.documentation.service.AllowableValues;
import springfox.documentation.service.CollectionFormat;
import springfox.documentation.service.Parameter;
import springfox.documentation.service.ParameterType;
import springfox.documentation.service.RequestParameter;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.OperationBuilderPlugin;
import springfox.documentation.spi.service.contexts.OperationContext;
import springfox.documentation.spring.web.DescriptionResolver;
import springfox.documentation.swagger.common.SwaggerPluginSupport;
import springfox.documentation.swagger.readers.parameter.Examples;
import springfox.documentation.swagger.schema.ApiModelProperties;

@Component
@Order(value=-2147482648)
public class OperationImplicitParameterReader
implements OperationBuilderPlugin {
    private static final Logger LOGGER = LoggerFactory.getLogger(OperationImplicitParameterReader.class);
    private final DescriptionResolver descriptions;

    @Autowired
    public OperationImplicitParameterReader(DescriptionResolver descriptions) {
        this.descriptions = descriptions;
    }

    public void apply(OperationContext context) {
        List<Compatibility<Parameter, RequestParameter>> parameters = this.readParameters(context);
        context.operationBuilder().parameters(parameters.stream().map(Compatibility::getLegacy).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList()));
        context.operationBuilder().requestParameters((Collection)parameters.stream().map(Compatibility::getModern).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList()));
    }

    public boolean supports(DocumentationType delimiter) {
        return SwaggerPluginSupport.pluginDoesApply(delimiter);
    }

    static Compatibility<Parameter, RequestParameter> implicitParameter(DescriptionResolver descriptions, ApiImplicitParam param) {
        Compatibility<ModelRef, ModelSpecification> modelRef = OperationImplicitParameterReader.maybeGetModelRef(param);
        ParameterType in = ParameterType.from((String)param.paramType());
        return new Compatibility((Object)new ParameterBuilder().name(param.name()).description(descriptions.resolve(param.value())).defaultValue(param.defaultValue()).required(param.required()).allowMultiple(param.allowMultiple()).modelRef((ModelReference)modelRef.getLegacy().orElse(null)).allowableValues(ApiModelProperties.allowableValueFromString(param.allowableValues())).parameterType((String)Optional.ofNullable(param.paramType()).filter(((Predicate<String>)String::isEmpty).negate()).orElse(null)).parameterAccess(param.access()).order(-2147482648).scalarExample((Object)param.example()).complexExamples(Examples.examples(param.examples())).collectionFormat(param.collectionFormat()).build(), (Object)new RequestParameterBuilder().name(param.name()).description(descriptions.resolve(param.value())).required(Boolean.valueOf(param.required())).in(in).query(q -> q.model(m -> modelRef.getModern().ifPresent(arg_0 -> ((ModelSpecificationBuilder)m).copyOf(arg_0))).defaultValue(param.defaultValue()).enumerationFacet(e -> e.allowedValues(ApiModelProperties.allowableValueFromString(param.allowableValues()))).collectionFacet(c -> c.collectionFormat((CollectionFormat)CollectionFormat.convert((String)param.collectionFormat()).orElse(null)))).precedence(-2147482648).example(new ExampleBuilder().value((Object)param.example()).build()).examples((Collection)Examples.examples(param.examples()).entrySet().stream().flatMap(e -> ((List)e.getValue()).stream()).collect(Collectors.toList())).build());
    }

    private static Compatibility<ModelRef, ModelSpecification> maybeGetModelRef(ApiImplicitParam param) {
        String dataType = Optional.ofNullable(param.dataType()).filter(((Predicate<String>)String::isEmpty).negate()).orElse("string");
        ModelSpecification modelSpecification = OperationImplicitParameterReader.modelSpecification(param);
        AllowableValues allowableValues = null;
        if (Types.isBaseType((String)dataType)) {
            allowableValues = ApiModelProperties.allowableValueFromString(param.allowableValues());
        }
        if (param.allowMultiple()) {
            return new Compatibility((Object)new ModelRef("", (ModelReference)new ModelRef(dataType, allowableValues)), (Object)modelSpecification);
        }
        return new Compatibility((Object)new ModelRef(dataType, allowableValues), (Object)modelSpecification);
    }

    private static ModelSpecification modelSpecification(ApiImplicitParam param) {
        Class<?> clazz;
        try {
            param.dataTypeClass();
            clazz = param.dataTypeClass() != Void.class ? param.dataTypeClass() : Class.forName(param.dataType());
        }
        catch (ClassNotFoundException e) {
            LOGGER.warn("Unable to interpret the implicit parameter configuration with dataType: {}, dataTypeClass: {}", (Object)param.dataType(), (Object)param.dataTypeClass());
            return null;
        }
        ModelSpecification modelSpecification = ScalarTypes.builtInScalarType(clazz).map(scalar -> {
            if (param.allowMultiple()) {
                return new ModelSpecificationBuilder().collectionModel(c -> c.model(m -> m.scalarModel(scalar)).collectionType(CollectionType.LIST)).build();
            }
            return new ModelSpecificationBuilder().scalarModel(scalar).build();
        }).orElse(null);
        if (modelSpecification == null) {
            ModelKey dataTypeKey = new ModelKeyBuilder().qualifiedModelName(q -> q.namespace(PackageNames.safeGetPackageName((Class)clazz)).name(clazz.getSimpleName())).build();
            modelSpecification = OperationImplicitParameterReader.referenceModelSpecification(dataTypeKey, param.allowMultiple());
        }
        return modelSpecification;
    }

    private static ModelSpecification referenceModelSpecification(ModelKey dataTypeKey, boolean allowMultiple) {
        if (allowMultiple) {
            return new ModelSpecificationBuilder().collectionModel(c -> c.model(m -> m.referenceModel(r -> r.key(k -> k.copyOf(dataTypeKey)))).collectionType(CollectionType.LIST)).build();
        }
        return new ModelSpecificationBuilder().referenceModel(r -> r.key(k -> k.copyOf(dataTypeKey))).build();
    }

    private List<Compatibility<Parameter, RequestParameter>> readParameters(OperationContext context) {
        Optional annotation = context.findAnnotation(ApiImplicitParam.class);
        ArrayList<Compatibility<Parameter, RequestParameter>> parameters = new ArrayList<Compatibility<Parameter, RequestParameter>>();
        annotation.ifPresent(apiImplicitParam -> parameters.add(OperationImplicitParameterReader.implicitParameter(this.descriptions, apiImplicitParam)));
        return parameters;
    }
}

