/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger2.mappers;

import io.swagger.models.auth.OAuth2Definition;
import io.swagger.models.auth.SecuritySchemeDefinition;
import springfox.documentation.service.AuthorizationCodeGrant;
import springfox.documentation.service.ClientCredentialsGrant;
import springfox.documentation.service.GrantType;
import springfox.documentation.service.ImplicitGrant;
import springfox.documentation.service.OAuth;
import springfox.documentation.service.ResourceOwnerPasswordCredentialsGrant;
import springfox.documentation.service.SecurityScheme;
import springfox.documentation.swagger2.mappers.SecuritySchemeFactory;
import springfox.documentation.swagger2.mappers.VendorExtensionsMapper;

class OAuth2AuthFactory
implements SecuritySchemeFactory {
    OAuth2AuthFactory() {
    }

    @Override
    public SecuritySchemeDefinition create(SecurityScheme input) {
        OAuth oAuth = (OAuth)input;
        OAuth2Definition definition = new OAuth2Definition();
        for (GrantType each : oAuth.getGrantTypes()) {
            if ("authorization_code".equals(each.getType())) {
                definition.accessCode(((AuthorizationCodeGrant)each).getTokenRequestEndpoint().getUrl(), ((AuthorizationCodeGrant)each).getTokenEndpoint().getUrl());
                continue;
            }
            if ("implicit".equals(each.getType())) {
                definition.implicit(((ImplicitGrant)each).getLoginEndpoint().getUrl());
                continue;
            }
            if ("application".equals(each.getType())) {
                definition.application(((ClientCredentialsGrant)each).getTokenUrl());
                continue;
            }
            if ("password".equals(each.getType())) {
                definition.password(((ResourceOwnerPasswordCredentialsGrant)each).getTokenUrl());
                continue;
            }
            throw new IllegalArgumentException(String.format("Security scheme of type %s not supported", input.getClass().getSimpleName()));
        }
        for (GrantType each : oAuth.getScopes()) {
            definition.addScope(each.getScope(), each.getDescription());
        }
        VendorExtensionsMapper vendorMapper = new VendorExtensionsMapper();
        definition.setVendorExtensions(vendorMapper.mapExtensions(input.getVendorExtensions()));
        return definition;
    }
}

