/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.datasourcemanager.core.validate.strategy;

import java.util.List;
import java.util.Map;
import org.apache.linkis.datasourcemanager.common.domain.DataSourceParamKeyDefinition;
import org.apache.linkis.datasourcemanager.common.errorcode.LinkisDatasourceManagerErrorCodeSummary;
import org.apache.linkis.datasourcemanager.common.util.json.Json;
import org.apache.linkis.datasourcemanager.core.formdata.CustomMultiPartFormDataTransformer;
import org.apache.linkis.datasourcemanager.core.formdata.FormStreamContent;
import org.apache.linkis.datasourcemanager.core.validate.ParameterValidateException;
import org.apache.linkis.datasourcemanager.core.validate.ParameterValidateStrategy;

public class TypeParameterValidateStrategy
implements ParameterValidateStrategy {
    @Override
    public boolean accept(DataSourceParamKeyDefinition.ValueType valueType) {
        return true;
    }

    @Override
    public Object validate(DataSourceParamKeyDefinition keyDefinition, Object actualValue) throws ParameterValidateException {
        DataSourceParamKeyDefinition.ValueType valueType = keyDefinition.getValueType();
        Class javaType = valueType.getJavaType();
        if (valueType == DataSourceParamKeyDefinition.ValueType.FILE) {
            if (!actualValue.getClass().equals(FormStreamContent.class)) {
                throw new ParameterValidateException(LinkisDatasourceManagerErrorCodeSummary.PARAM_VALIDATE_FAILED.getErrorDesc() + ", [the value of '" + keyDefinition.getKey() + "' must be 'File']");
            }
            return actualValue;
        }
        if (!javaType.isAssignableFrom(actualValue.getClass())) {
            try {
                if (javaType.equals(List.class)) {
                    return Json.fromJson((String)String.valueOf(actualValue), List.class, (Class[])new Class[]{String.class});
                }
                if (javaType.equals(Map.class)) {
                    return Json.fromJson((String)String.valueOf(actualValue), Map.class, (Class[])new Class[]{String.class, String.class});
                }
                if (CustomMultiPartFormDataTransformer.PrimitiveUtils.isPrimitive(javaType)) {
                    return CustomMultiPartFormDataTransformer.PrimitiveUtils.primitiveTypeConverse(actualValue, javaType);
                }
            }
            catch (Exception e) {
                throw new ParameterValidateException(LinkisDatasourceManagerErrorCodeSummary.PARAM_VALIDATE_FAILED.getErrorDesc() + ", [type of value: '" + actualValue + "' is not '" + javaType.getSimpleName() + "']");
            }
            throw new ParameterValidateException(LinkisDatasourceManagerErrorCodeSummary.PARAM_VALIDATE_FAILED.getErrorDesc() + ", [type of value: '" + actualValue + "' is not '" + javaType.getSimpleName() + "']");
        }
        return actualValue;
    }
}

