/*
 * Decompiled with CFR 0.152.
 */
package com.redislabs.provider.redis.streaming;

import com.redislabs.provider.redis.ReadWriteConfig;
import com.redislabs.provider.redis.RedisConfig;
import com.redislabs.provider.redis.streaming.ConsumerConfig;
import com.redislabs.provider.redis.streaming.Earliest$;
import com.redislabs.provider.redis.streaming.IdOffset;
import com.redislabs.provider.redis.streaming.ItemId;
import com.redislabs.provider.redis.streaming.Latest$;
import com.redislabs.provider.redis.streaming.Offset;
import com.redislabs.provider.redis.streaming.StreamItem;
import com.redislabs.provider.redis.util.Logging;
import com.redislabs.provider.redis.util.PipelineUtils$;
import com.redislabs.provider.redis.util.StreamUtils$;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.apache.curator.utils.ThreadUtils;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.streaming.receiver.Receiver;
import org.slf4j.Logger;
import org.spark_project.guava.util.concurrent.RateLimiter;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.StreamEntry;
import redis.clients.jedis.StreamEntryID;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005]d\u0001\u0002\r\u001a\u0001\u0011B\u0001\u0002\u0010\u0001\u0003\u0002\u0003\u0006I!\u0010\u0005\t\u001d\u0002\u0011\t\u0011)A\u0005\u001f\"A1\u000b\u0001B\u0001B\u0003%A\u000bC\u0005X\u0001\t\u0005\t\u0015!\u0003Y=\")q\f\u0001C\u0001A\")a\r\u0001C!O\")A\u000e\u0001C!O\u001a!Q\u000e\u0001\u0003o\u0011!Q\bB!A!\u0002\u0013Y\u0005\u0002\u0003(\t\u0005\u0003\u0005\u000b\u0011B(\t\u0011MC!Q1A\u0005\u0004mD\u0001\u0002 \u0005\u0003\u0002\u0003\u0006I\u0001\u0016\u0005\u0006?\"!\t! \u0005\n\u0003\u000fA!\u0019!C\u0001\u0003\u0013A\u0001\"a\u0007\tA\u0003%\u00111\u0002\u0005\n\u0003;A!\u0019!C\u0001\u0003?A\u0001\"!\u0010\tA\u0003%\u0011\u0011\u0005\u0005\u0007\u0003\u007fAA\u0011I4\t\r\u0005\u0005\u0003\u0002\"\u0001h\u0011\u0019\t\u0019\u0005\u0003C\u0001O\"1\u0011Q\t\u0005\u0005\u0002\u001dDq!a\u0012\t\t\u0003\tI\u0005C\u0004\u0002l!!\t!!\u001c\u0003'I+G-[:TiJ,\u0017-\u001c*fG\u0016Lg/\u001a:\u000b\u0005iY\u0012!C:ue\u0016\fW.\u001b8h\u0015\taR$A\u0003sK\u0012L7O\u0003\u0002\u001f?\u0005A\u0001O]8wS\u0012,'O\u0003\u0002!C\u0005I!/\u001a3jg2\f'm\u001d\u0006\u0002E\u0005\u00191m\\7\u0004\u0001M\u0019\u0001!\n\u001c\u0011\u0007\u0019\u0002$'D\u0001(\u0015\tA\u0013&\u0001\u0005sK\u000e,\u0017N^3s\u0015\tQ\"F\u0003\u0002,Y\u0005)1\u000f]1sW*\u0011QFL\u0001\u0007CB\f7\r[3\u000b\u0003=\n1a\u001c:h\u0013\t\ttE\u0001\u0005SK\u000e,\u0017N^3s!\t\u0019D'D\u0001\u001a\u0013\t)\u0014D\u0001\u0006TiJ,\u0017-\\%uK6\u0004\"a\u000e\u001e\u000e\u0003aR!!O\u000e\u0002\tU$\u0018\u000e\\\u0005\u0003wa\u0012q\u0001T8hO&tw-A\bd_:\u001cX/\\3sg\u000e{gNZ5h!\rq\u0004j\u0013\b\u0003\u007f\u0015s!\u0001Q\"\u000e\u0003\u0005S!AQ\u0012\u0002\rq\u0012xn\u001c;?\u0013\u0005!\u0015!B:dC2\f\u0017B\u0001$H\u0003\u001d\u0001\u0018mY6bO\u0016T\u0011\u0001R\u0005\u0003\u0013*\u00131aU3r\u0015\t1u\t\u0005\u00024\u0019&\u0011Q*\u0007\u0002\u000f\u0007>t7/^7fe\u000e{gNZ5h\u0003-\u0011X\rZ5t\u0007>tg-[4\u0011\u0005A\u000bV\"A\u000e\n\u0005I[\"a\u0003*fI&\u001c8i\u001c8gS\u001e\fqB]3bI^\u0013\u0018\u000e^3D_:4\u0017n\u001a\t\u0003!VK!AV\u000e\u0003\u001fI+\u0017\rZ,sSR,7i\u001c8gS\u001e\fAb\u001d;pe\u0006<W\rT3wK2\u0004\"!\u0017/\u000e\u0003iS!a\u0017\u0016\u0002\u000fM$xN]1hK&\u0011QL\u0017\u0002\r'R|'/Y4f\u0019\u00164X\r\\\u0005\u0003/B\na\u0001P5oSRtD#B1cG\u0012,\u0007CA\u001a\u0001\u0011\u0015aT\u00011\u0001>\u0011\u0015qU\u00011\u0001P\u0011\u0015\u0019V\u00011\u0001U\u0011\u00159V\u00011\u0001Y\u0003\u001dygn\u0015;beR$\u0012\u0001\u001b\t\u0003S*l\u0011aR\u0005\u0003W\u001e\u0013A!\u00168ji\u00061qN\\*u_B\u0014a\"T3tg\u0006<W\rS1oI2,'oE\u0002\t_^\u0004\"\u0001];\u000e\u0003ET!A]:\u0002\t1\fgn\u001a\u0006\u0002i\u0006!!.\u0019<b\u0013\t1\u0018O\u0001\u0004PE*,7\r\u001e\t\u0003abL!!_9\u0003\u0011I+hN\\1cY\u0016\fAaY8oMV\tA+\u0001\tsK\u0006$wK]5uK\u000e{gNZ5hAQ9a0!\u0001\u0002\u0004\u0005\u0015\u0001CA@\t\u001b\u0005\u0001\u0001\"\u0002>\u000e\u0001\u0004Y\u0005\"\u0002(\u000e\u0001\u0004y\u0005\"B*\u000e\u0001\b!\u0016!\u00026fI&\u001cXCAA\u0006!\u0011\ti!a\u0006\u000e\u0005\u0005=!\u0002BA\u0004\u0003#QA!a\u0005\u0002\u0016\u000591\r\\5f]R\u001c(\"\u0001\u000f\n\t\u0005e\u0011q\u0002\u0002\u0006\u0015\u0016$\u0017n]\u0001\u0007U\u0016$\u0017n\u001d\u0011\u0002\u001dI\fG/\u001a'j[&$XM](qiV\u0011\u0011\u0011\u0005\t\u0006S\u0006\r\u0012qE\u0005\u0004\u0003K9%AB(qi&|g\u000e\u0005\u0003\u0002*\u0005eRBAA\u0016\u0015\u0011\ti#a\f\u0002\u0015\r|gnY;se\u0016tGOC\u0002:\u0003cQA!a\r\u00026\u0005)q-^1wC*\u0019\u0011q\u0007\u0018\u0002\u001bM\u0004\u0018M]6`aJ|'.Z2u\u0013\u0011\tY$a\u000b\u0003\u0017I\u000bG/\u001a'j[&$XM]\u0001\u0010e\u0006$X\rT5nSR,'o\u00149uA\u0005\u0019!/\u001e8\u0002;\r\u0014X-\u0019;f\u0007>t7/^7fe\u001e\u0013x.\u001e9JM:{G/\u0012=jgR\fQC]3dK&4X-\u00168bG.twn\u001e7fI\u001e,G-\u0001\nsK\u000e,\u0017N^3OK^lUm]:bO\u0016\u001c\u0018aC:u_J,\u0017I\u001c3BG.$R\u0001[A&\u0003?Bq!!\u0014\u0017\u0001\u0004\ty%A\u0005tiJ,\u0017-\\&fsB!\u0011\u0011KA-\u001d\u0011\t\u0019&!\u0016\u0011\u0005\u0001;\u0015bAA,\u000f\u00061\u0001K]3eK\u001aLA!a\u0017\u0002^\t11\u000b\u001e:j]\u001eT1!a\u0016H\u0011\u001d\t\tG\u0006a\u0001\u0003G\nq!\u001a8ue&,7\u000f\u0005\u0003?\u0011\u0006\u0015\u0004\u0003BA\u0007\u0003OJA!!\u001b\u0002\u0010\tY1\u000b\u001e:fC6,e\u000e\u001e:z\u00039)g\u000e\u001e:jKN$v.\u0013;f[N$b!a\u001c\u0002r\u0005U\u0004c\u0001 Ie!9\u00111O\fA\u0002\u0005=\u0013aA6fs\"9\u0011\u0011M\fA\u0002\u0005\r\u0004")
public class RedisStreamReceiver
extends Receiver<StreamItem>
implements Logging {
    private final Seq<ConsumerConfig> consumersConfig;
    private final RedisConfig redisConfig;
    private final ReadWriteConfig readWriteConfig;
    private transient Logger com$redislabs$provider$redis$util$Logging$$_logger;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public Logger logger() {
        return Logging.logger$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public Logger com$redislabs$provider$redis$util$Logging$$_logger() {
        return this.com$redislabs$provider$redis$util$Logging$$_logger;
    }

    @Override
    public void com$redislabs$provider$redis$util$Logging$$_logger_$eq(Logger x$1) {
        this.com$redislabs$provider$redis$util$Logging$$_logger = x$1;
    }

    public void onStart() {
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Starting Redis Stream Receiver");
        ExecutorService executorPool = ThreadUtils.newFixedThreadPool((int)this.consumersConfig.size(), (String)"RedisStreamMessageHandler");
        try {
            this.consumersConfig.foreach((Function1 & Serializable & scala.Serializable)c -> executorPool.submit(new MessageHandler(this, (ConsumerConfig)c, $this.redisConfig, $this.readWriteConfig)));
        }
        finally {
            executorPool.shutdown();
        }
    }

    public void onStop() {
    }

    public RedisStreamReceiver(Seq<ConsumerConfig> consumersConfig, RedisConfig redisConfig, ReadWriteConfig readWriteConfig, StorageLevel storageLevel) {
        this.consumersConfig = consumersConfig;
        this.redisConfig = redisConfig;
        this.readWriteConfig = readWriteConfig;
        super(storageLevel);
        Logging.$init$(this);
    }

    public class MessageHandler
    implements Runnable {
        private final ConsumerConfig conf;
        private final ReadWriteConfig readWriteConfig;
        private final Jedis jedis;
        private final Option<RateLimiter> rateLimiterOpt;
        public final /* synthetic */ RedisStreamReceiver $outer;

        public ReadWriteConfig readWriteConfig() {
            return this.readWriteConfig;
        }

        public Jedis jedis() {
            return this.jedis;
        }

        public Option<RateLimiter> rateLimiterOpt() {
            return this.rateLimiterOpt;
        }

        @Override
        public void run() {
            this.com$redislabs$provider$redis$streaming$RedisStreamReceiver$MessageHandler$$$outer().logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append("Starting MessageHandler ").append($this.conf).toString());
            try {
                this.createConsumerGroupIfNotExist();
                this.receiveUnacknowledged();
                this.receiveNewMessages();
            }
            catch (Exception e) {
                this.com$redislabs$provider$redis$streaming$RedisStreamReceiver$MessageHandler$$$outer().restart("Error handling message. Restarting.", e);
            }
        }

        public void createConsumerGroupIfNotExist() {
            StreamEntryID streamEntryID;
            Offset offset = this.conf.offset();
            if (Earliest$.MODULE$.equals(offset)) {
                streamEntryID = new StreamEntryID(0L, 0L);
            } else if (Latest$.MODULE$.equals(offset)) {
                streamEntryID = StreamEntryID.LAST_ENTRY;
            } else if (offset instanceof IdOffset) {
                IdOffset idOffset = (IdOffset)offset;
                long v1 = idOffset.v1();
                long v2 = idOffset.v2();
                streamEntryID = new StreamEntryID(v1, v2);
            } else {
                throw new MatchError((Object)offset);
            }
            StreamEntryID entryId = streamEntryID;
            StreamUtils$.MODULE$.createConsumerGroupIfNotExist(this.jedis(), this.conf.streamKey(), this.conf.groupName(), entryId);
        }

        public void receiveUnacknowledged() {
            this.com$redislabs$provider$redis$streaming$RedisStreamReceiver$MessageHandler$$$outer().logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(51).append("Starting receiving unacknowledged messages for key ").append($this.conf.streamKey()).toString());
            boolean bl = true;
            AbstractMap.SimpleEntry<String, StreamEntryID> unackId = new AbstractMap.SimpleEntry<String, StreamEntryID>(this.conf.streamKey(), new StreamEntryID(0L, 0L));
            while (!this.com$redislabs$provider$redis$streaming$RedisStreamReceiver$MessageHandler$$$outer().isStopped() && bl) {
                List response = this.jedis().xreadGroup(this.conf.groupName(), this.conf.consumerName(), this.conf.batchSize(), this.conf.block(), false, new Map.Entry[]{unackId});
                Map unackMessagesMap = ((TraversableOnce)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(response).map((Function1 & Serializable & scala.Serializable)e -> new Tuple2(e.getKey(), e.getValue()), Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                List entries = (List)unackMessagesMap.apply((Object)this.conf.streamKey());
                if (entries.isEmpty()) {
                    bl = false;
                }
                this.storeAndAck(this.conf.streamKey(), (Seq<StreamEntry>)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(entries));
            }
        }

        public void receiveNewMessages() {
            this.com$redislabs$provider$redis$streaming$RedisStreamReceiver$MessageHandler$$$outer().logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("Starting receiving new messages for key ").append($this.conf.streamKey()).toString());
            AbstractMap.SimpleEntry<String, StreamEntryID> newMessId = new AbstractMap.SimpleEntry<String, StreamEntryID>(this.conf.streamKey(), StreamEntryID.UNRECEIVED_ENTRY);
            while (!this.com$redislabs$provider$redis$streaming$RedisStreamReceiver$MessageHandler$$$outer().isStopped()) {
                List response = this.jedis().xreadGroup(this.conf.groupName(), this.conf.consumerName(), this.conf.batchSize(), this.conf.block(), false, new Map.Entry[]{newMessId});
                if (response == null) continue;
                JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(response).foreach((Function1 & Serializable & scala.Serializable)streamMessages -> {
                    MessageHandler.$anonfun$receiveNewMessages$2(this, streamMessages);
                    return BoxedUnit.UNIT;
                });
            }
        }

        public void storeAndAck(String streamKey, Seq<StreamEntry> entries) {
            block0: {
                if (!entries.nonEmpty()) break block0;
                this.rateLimiterOpt().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                    x$1.acquire(entries.size());
                    return BoxedUnit.UNIT;
                });
                Seq<StreamItem> streamItems = this.entriesToItems(streamKey, entries);
                this.com$redislabs$provider$redis$streaming$RedisStreamReceiver$MessageHandler$$$outer().store(streamItems.iterator());
                PipelineUtils$.MODULE$.foreachWithPipeline(this.jedis(), entries, (Function2 & Serializable & scala.Serializable)(pipeline, entry) -> {
                    pipeline.xack(streamKey, this.conf.groupName(), new StreamEntryID[]{entry.getID()});
                    return BoxedUnit.UNIT;
                }, this.readWriteConfig());
            }
        }

        public Seq<StreamItem> entriesToItems(String key, Seq<StreamEntry> entries) {
            return (Seq)entries.map((Function1 & Serializable & scala.Serializable)e -> {
                ItemId itemId = new ItemId(e.getID().getTime(), e.getID().getSequence());
                return new StreamItem(key, itemId, (Map<String, String>)JavaConversions$.MODULE$.deprecated$u0020mapAsScalaMap(e.getFields()).toMap(Predef$.MODULE$.$conforms()));
            }, Seq$.MODULE$.canBuildFrom());
        }

        public /* synthetic */ RedisStreamReceiver com$redislabs$provider$redis$streaming$RedisStreamReceiver$MessageHandler$$$outer() {
            return this.$outer;
        }

        public static final /* synthetic */ RateLimiter $anonfun$rateLimiterOpt$1(int r) {
            return RateLimiter.create((double)r);
        }

        public static final /* synthetic */ void $anonfun$receiveNewMessages$2(MessageHandler $this, Map.Entry streamMessages) {
            String key = (String)streamMessages.getKey();
            List entries = (List)streamMessages.getValue();
            $this.storeAndAck(key, (Seq<StreamEntry>)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(entries));
        }

        public MessageHandler(RedisStreamReceiver $outer, ConsumerConfig conf, RedisConfig redisConfig, ReadWriteConfig readWriteConfig) {
            this.conf = conf;
            this.readWriteConfig = readWriteConfig;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.jedis = redisConfig.connectionForKey(conf.streamKey());
            this.rateLimiterOpt = conf.rateLimitPerConsumer().map((Function1 & Serializable & scala.Serializable)r -> MessageHandler.$anonfun$rateLimiterOpt$1(BoxesRunTime.unboxToInt((Object)r)));
        }
    }
}

