/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.storage.utils;

import java.io.Serializable;
import org.apache.linkis.common.io.Fs;
import org.apache.linkis.common.io.FsPath;
import org.apache.linkis.common.io.MetaData;
import org.apache.linkis.common.io.Record;
import org.apache.linkis.common.io.resultset.ResultSet;
import org.apache.linkis.common.io.resultset.ResultSetReader;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.storage.FSFactory$;
import org.apache.linkis.storage.domain.Column;
import org.apache.linkis.storage.resultset.ResultSetFactory;
import org.apache.linkis.storage.resultset.ResultSetFactory$;
import org.apache.linkis.storage.resultset.ResultSetReader$;
import org.apache.linkis.storage.resultset.table.TableMetaData;
import org.apache.linkis.storage.resultset.table.TableRecord;
import org.apache.linkis.storage.utils.FileSystemUtils$;
import org.apache.linkis.storage.utils.StorageUtils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;

public final class StorageHelper$
implements Logging {
    public static StorageHelper$ MODULE$;
    private Logger logger;
    private volatile boolean bitmap$0;

    static {
        new StorageHelper$();
    }

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        StorageHelper$ storageHelper$ = this;
        synchronized (storageHelper$) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public void main(String[] args) {
        if (args.length < 2) {
            this.logger().info("Usage method params eg:getTableResLines path");
        }
        String method = args[0];
        String[] params = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).slice(1, args.length);
        Thread.sleep(10000L);
        String string = method;
        if ("getTableResLines".equals(string)) {
            this.getTableResLines(params);
            return;
        }
        if ("getTableRes".equals(string)) {
            this.getTableRes(params);
            return;
        }
        if ("createNewFile".equals(string)) {
            this.createNewFile(params);
            return;
        }
        this.logger().info("There is no such method");
    }

    public void getTableResLines(String[] args) {
        FsPath resPath = StorageUtils$.MODULE$.getFsPath(args[0]);
        ResultSetFactory resultSetFactory = ResultSetFactory$.MODULE$.getInstance();
        ResultSet<? extends MetaData, ? extends Record> resultSet = resultSetFactory.getResultSetByType(ResultSetFactory$.MODULE$.TABLE_TYPE());
        Fs fs = FSFactory$.MODULE$.getFs(resPath);
        fs.init(null);
        ResultSetReader<? extends MetaData, ? extends Record> reader = ResultSetReader$.MODULE$.getResultSetReader(resultSet, fs.read(resPath));
        MetaData rmetaData = reader.getMetaData();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((TableMetaData)rmetaData).columns())).foreach((Function1 & Serializable & scala.Serializable)column -> {
            StorageHelper$.$anonfun$getTableResLines$1(column);
            return BoxedUnit.UNIT;
        });
        int num = 0;
        Thread.sleep(10000L);
        while (reader.hasNext()) {
            reader.getRecord();
            ++num;
        }
        this.logger().info(Integer.toString(num));
        reader.close();
    }

    public void getTableRes(String[] args) {
        int len = Integer.parseInt(args[1]);
        int max = len + 10;
        FsPath resPath = StorageUtils$.MODULE$.getFsPath(args[0]);
        ResultSetFactory resultSetFactory = ResultSetFactory$.MODULE$.getInstance();
        ResultSet<? extends MetaData, ? extends Record> resultSet = resultSetFactory.getResultSetByType(ResultSetFactory$.MODULE$.TABLE_TYPE());
        Fs fs = FSFactory$.MODULE$.getFs(resPath);
        fs.init(null);
        ResultSetReader<? extends MetaData, ? extends Record> reader = ResultSetReader$.MODULE$.getResultSetReader(resultSet, fs.read(resPath));
        MetaData rmetaData = reader.getMetaData();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((TableMetaData)rmetaData).columns())).foreach((Function1 & Serializable & scala.Serializable)column -> {
            StorageHelper$.$anonfun$getTableRes$1(column);
            return BoxedUnit.UNIT;
        });
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((TableMetaData)rmetaData).columns())).map((Function1 & Serializable & scala.Serializable)x$1 -> new StringBuilder(1).append(x$1.columnName()).append(",").toString(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).foreach((Function1 & Serializable & scala.Serializable)column -> {
            StorageHelper$.$anonfun$getTableRes$3(column);
            return BoxedUnit.UNIT;
        });
        int num = 0;
        while (reader.hasNext()) {
            if (++num > max) {
                return;
            }
            if (num <= len) continue;
            Record record = reader.getRecord();
            Predef$.MODULE$.genericArrayOps((Object)((TableRecord)record).row()).foreach((Function1 & Serializable & scala.Serializable)value -> {
                StorageHelper$.$anonfun$getTableRes$4(value);
                return BoxedUnit.UNIT;
            });
            this.logger().info("\n");
        }
    }

    public void createNewFile(String[] args) {
        FsPath resPath = StorageUtils$.MODULE$.getFsPath(args[0]);
        String proxyUser = StorageUtils$.MODULE$.getJvmUser();
        FileSystemUtils$.MODULE$.createNewFile(resPath, proxyUser, true);
        this.logger().info("success");
    }

    public static final /* synthetic */ void $anonfun$getTableResLines$1(Column column) {
        MODULE$.logger().info(column.toString());
    }

    public static final /* synthetic */ void $anonfun$getTableRes$1(Column column) {
        MODULE$.logger().info(column.toString());
    }

    public static final /* synthetic */ void $anonfun$getTableRes$3(String column) {
        MODULE$.logger().info(column);
    }

    public static final /* synthetic */ void $anonfun$getTableRes$4(Object value) {
        MODULE$.logger().info(value.toString());
        MODULE$.logger().info(",");
    }

    private StorageHelper$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

