/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.manager.rm.service;

import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.manager.am.conf.AMConfiguration;
import org.apache.linkis.manager.am.vo.CanCreateECRes;
import org.apache.linkis.manager.common.entity.resource.CPUResource;
import org.apache.linkis.manager.common.entity.resource.CommonNodeResource;
import org.apache.linkis.manager.common.entity.resource.DriverAndYarnResource;
import org.apache.linkis.manager.common.entity.resource.InstanceResource;
import org.apache.linkis.manager.common.entity.resource.LoadInstanceResource;
import org.apache.linkis.manager.common.entity.resource.LoadResource;
import org.apache.linkis.manager.common.entity.resource.MemoryResource;
import org.apache.linkis.manager.common.entity.resource.NodeResource;
import org.apache.linkis.manager.common.entity.resource.Resource;
import org.apache.linkis.manager.common.entity.resource.ResourceType;
import org.apache.linkis.manager.common.entity.resource.SpecialResource;
import org.apache.linkis.manager.common.entity.resource.YarnResource;
import org.apache.linkis.manager.common.errorcode.ManagerCommonErrorCodeSummary;
import org.apache.linkis.manager.common.exception.RMErrorException;
import org.apache.linkis.manager.common.exception.RMWarnException;
import org.apache.linkis.manager.common.protocol.engine.EngineCreateRequest;
import org.apache.linkis.manager.label.entity.Label;
import org.apache.linkis.manager.label.entity.em.EMInstanceLabel;
import org.apache.linkis.manager.label.utils.LabelUtil$;
import org.apache.linkis.manager.rm.domain.RMLabelContainer;
import org.apache.linkis.manager.rm.exception.RMErrorCode;
import org.apache.linkis.manager.rm.external.service.ExternalResourceService;
import org.apache.linkis.manager.rm.external.yarn.YarnResourceIdentifier;
import org.apache.linkis.manager.rm.service.LabelResourceService;
import org.apache.linkis.manager.rm.utils.AcrossClusterRulesJudgeUtils$;
import org.apache.linkis.manager.rm.utils.RMUtils$;
import org.apache.linkis.manager.rm.utils.UserConfiguration$;
import org.slf4j.Logger;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005-d!B\t\u0013\u0003\u0003y\u0002\u0002\u0003\u0018\u0001\u0005\u0003\u0005\u000b\u0011B\u0018\t\u000bM\u0002A\u0011\u0001\u001b\t\u000f]\u0002!\u0019!C\u0001q!1!\t\u0001Q\u0001\neBqa\u0011\u0001C\u0002\u0013\u0005A\t\u0003\u0004I\u0001\u0001\u0006I!\u0012\u0005\b\u0013\u0002\u0001\r\u0011\"\u0001K\u0011\u001d\u0011\u0006\u00011A\u0005\u0002MCa!\u0017\u0001!B\u0013Y\u0005\"\u0002.\u0001\t\u0003Y\u0006\"B/\u0001\t\u0003q\u0006\"B?\u0001\t\u0013q\bbBA\u0002\u0001\u0011\u0005\u0011Q\u0001\u0005\b\u0003\u001b\u0001A\u0011BA\b\u0011\u001d\tI\u0003\u0001C\u0001\u0003WAq!!\u0019\u0001\t\u0003\t\u0019G\u0001\fSKF,Xm\u001d;SKN|WO]2f'\u0016\u0014h/[2f\u0015\t\u0019B#A\u0004tKJ4\u0018nY3\u000b\u0005U1\u0012A\u0001:n\u0015\t9\u0002$A\u0004nC:\fw-\u001a:\u000b\u0005eQ\u0012A\u00027j].L7O\u0003\u0002\u001c9\u00051\u0011\r]1dQ\u0016T\u0011!H\u0001\u0004_J<7\u0001A\n\u0004\u0001\u00012\u0003CA\u0011%\u001b\u0005\u0011#\"A\u0012\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0015\u0012#AB!osJ+g\r\u0005\u0002(Y5\t\u0001F\u0003\u0002*U\u0005)Q\u000f^5mg*\u00111\u0006G\u0001\u0007G>lWn\u001c8\n\u00055B#a\u0002'pO\u001eLgnZ\u0001\u0015Y\u0006\u0014W\r\u001c*fg>,(oY3TKJ4\u0018nY3\u0011\u0005A\nT\"\u0001\n\n\u0005I\u0012\"\u0001\u0006'bE\u0016d'+Z:pkJ\u001cWmU3sm&\u001cW-\u0001\u0004=S:LGO\u0010\u000b\u0003kY\u0002\"\u0001\r\u0001\t\u000b9\u0012\u0001\u0019A\u0018\u0002\u0019I,7o\\;sG\u0016$\u0016\u0010]3\u0016\u0003e\u0002\"A\u000f!\u000e\u0003mR!\u0001P\u001f\u0002\u0011I,7o\\;sG\u0016T!AP \u0002\r\u0015tG/\u001b;z\u0015\tYc#\u0003\u0002Bw\ta!+Z:pkJ\u001cW\rV=qK\u0006i!/Z:pkJ\u001cW\rV=qK\u0002\nQ\"\u001a8bE2,'+Z9vKN$X#A#\u0011\u0005\u00052\u0015BA$#\u0005\u001d\u0011un\u001c7fC:\fa\"\u001a8bE2,'+Z9vKN$\b%A\ffqR,'O\\1m%\u0016\u001cx.\u001e:dKN+'O^5dKV\t1\n\u0005\u0002M!6\tQJ\u0003\u0002\u0014\u001d*\u0011q\nF\u0001\tKb$XM\u001d8bY&\u0011\u0011+\u0014\u0002\u0018\u000bb$XM\u001d8bYJ+7o\\;sG\u0016\u001cVM\u001d<jG\u0016\f1$\u001a=uKJt\u0017\r\u001c*fg>,(oY3TKJ4\u0018nY3`I\u0015\fHC\u0001+X!\t\tS+\u0003\u0002WE\t!QK\\5u\u0011\u001dA\u0006\"!AA\u0002-\u000b1\u0001\u001f\u00132\u0003a)\u0007\u0010^3s]\u0006d'+Z:pkJ\u001cWmU3sm&\u001cW\rI\u0001\u001bg\u0016$X\t\u001f;fe:\fGNU3t_V\u00148-Z*feZL7-\u001a\u000b\u0003)rCQ!\u0013\u0006A\u0002-\u000b!cY1o%\u0016\fX/Z:u%\u0016\u001cx.\u001e:dKR!qlZ8t!\t\u0001W-D\u0001b\u0015\t\u00117-\u0001\u0002w_*\u0011AMF\u0001\u0003C6L!AZ1\u0003\u001d\r\u000bgn\u0011:fCR,Wi\u0011*fg\")\u0001n\u0003a\u0001S\u0006qA.\u00192fY\u000e{g\u000e^1j]\u0016\u0014\bC\u00016n\u001b\u0005Y'B\u00017\u0015\u0003\u0019!w.\\1j]&\u0011an\u001b\u0002\u0011%6c\u0015MY3m\u0007>tG/Y5oKJDQ\u0001P\u0006A\u0002A\u0004\"AO9\n\u0005I\\$\u0001\u0004(pI\u0016\u0014Vm]8ve\u000e,\u0007\"\u0002;\f\u0001\u0004)\u0018aE3oO&tWm\u0011:fCR,'+Z9vKN$\bC\u0001<|\u001b\u00059(B\u0001=z\u0003\u0019)gnZ5oK*\u0011!pP\u0001\taJ|Go\\2pY&\u0011Ap\u001e\u0002\u0014\u000b:<\u0017N\\3De\u0016\fG/\u001a*fcV,7\u000f^\u0001\u001eO\u0016$8i\\7cS:,G\rT1cK2\u0014Vm]8ve\u000e,Wk]1hKR!\u0001o`A\u0001\u0011\u0015AG\u00021\u0001j\u0011\u0015aD\u00021\u0001q\u0003)\u0019\u0017M\u001c*fcV,7\u000f\u001e\u000b\b\u000b\u0006\u001d\u0011\u0011BA\u0006\u0011\u0015AW\u00021\u0001j\u0011\u0015aT\u00021\u0001q\u0011\u0015!X\u00021\u0001v\u0003=\u0019\u0007.Z2l\u000b6\u0013Vm]8ve\u000e,G#B#\u0002\u0012\u0005\u001d\u0002bBA\n\u001d\u0001\u0007\u0011QC\u0001\u0010K6Len\u001d;b]\u000e,G*\u00192fYB!\u0011qCA\u0012\u001b\t\tIB\u0003\u0003\u0002\u001c\u0005u\u0011AA3n\u0015\rq\u0014q\u0004\u0006\u0004\u0003C1\u0012!\u00027bE\u0016d\u0017\u0002BA\u0013\u00033\u0011q\"R'J]N$\u0018M\\2f\u0019\u0006\u0014W\r\u001c\u0005\u0006y9\u0001\r\u0001]\u0001\u001cO\u0016tWM]1uK\u0016\u001bUJT8u\u000b:|Wo\u001a5NKN\u001c\u0018mZ3\u0015\u0011\u00055\u0012qJA-\u0003;\u0002r!IA\u0018\u0003g\tI$C\u0002\u00022\t\u0012a\u0001V;qY\u0016\u0014\u0004cA\u0011\u00026%\u0019\u0011q\u0007\u0012\u0003\u0007%sG\u000f\u0005\u0003\u0002<\u0005%c\u0002BA\u001f\u0003\u000b\u00022!a\u0010#\u001b\t\t\tEC\u0002\u0002Dy\ta\u0001\u0010:p_Rt\u0014bAA$E\u00051\u0001K]3eK\u001aLA!a\u0013\u0002N\t11\u000b\u001e:j]\u001eT1!a\u0012#\u0011\u001d\t\tf\u0004a\u0001\u0003'\nqB]3rk\u0016\u001cHOU3t_V\u00148-\u001a\t\u0004u\u0005U\u0013bAA,w\tA!+Z:pkJ\u001cW\rC\u0004\u0002\\=\u0001\r!a\u0015\u0002#\u00054\u0018-\u001b7bE2,'+Z:pkJ\u001cW\rC\u0004\u0002`=\u0001\r!a\u0015\u0002\u00175\f\u0007PU3t_V\u00148-Z\u0001\u0019O\u0016tWM]1uK:{G/\u00128pk\u001eDW*Z:tC\u001e,G\u0003CA\u0017\u0003K\n9'!\u001b\t\u000f\u0005E\u0003\u00031\u0001\u0002T!9\u00111\f\tA\u0002\u0005M\u0003bBA0!\u0001\u0007\u00111\u000b")
public abstract class RequestResourceService
implements Logging {
    private final LabelResourceService labelResourceService;
    private final ResourceType resourceType;
    private final boolean enableRequest;
    private ExternalResourceService externalResourceService;
    private Logger logger;
    private volatile boolean bitmap$0;

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        RequestResourceService requestResourceService = this;
        synchronized (requestResourceService) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public ResourceType resourceType() {
        return this.resourceType;
    }

    public boolean enableRequest() {
        return this.enableRequest;
    }

    public ExternalResourceService externalResourceService() {
        return this.externalResourceService;
    }

    public void externalResourceService_$eq(ExternalResourceService x$1) {
        this.externalResourceService = x$1;
    }

    public void setExternalResourceService(ExternalResourceService externalResourceService) {
        this.externalResourceService_$eq(externalResourceService);
    }

    public CanCreateECRes canRequestResource(RMLabelContainer labelContainer, NodeResource resource, EngineCreateRequest engineCreateRequest) {
        CanCreateECRes canCreateECRes;
        block3: {
            canCreateECRes = new CanCreateECRes();
            EMInstanceLabel emInstanceLabel = labelContainer.getEMInstanceLabel();
            NodeResource ecmResource = this.labelResourceService.getLabelResource((Label<?>)emInstanceLabel);
            Resource requestResource = resource.getMinResource();
            if (ecmResource != null) {
                Resource labelAvailableResource = ecmResource.getLeftResource();
                canCreateECRes.setEcmResource(RMUtils$.MODULE$.serializeResource(labelAvailableResource));
                if (!labelAvailableResource.notLess(requestResource)) {
                    this.logger().info(new StringBuilder(54).append("user want to use resource[").append(requestResource).append("] > em ").append(emInstanceLabel.getInstance()).append(" available resource[").append(labelAvailableResource).append("]").toString());
                    Tuple2<Object, String> notEnoughMessage = this.generateECMNotEnoughMessage(requestResource, labelAvailableResource, ecmResource.getMaxResource());
                    canCreateECRes.setCanCreateEC(false);
                    canCreateECRes.setReason((String)notEnoughMessage._2());
                }
            }
            labelContainer.setCurrentLabel((Label)labelContainer.getCombinedResourceLabel());
            NodeResource labelResource = this.getCombinedLabelResourceUsage(labelContainer, resource);
            this.labelResourceService.setLabelResource(labelContainer.getCurrentLabel(), labelResource, labelContainer.getCombinedResourceLabel().getStringValue());
            if (labelResource == null) break block3;
            Resource labelAvailableResource = labelResource.getLeftResource();
            canCreateECRes.setLabelResource(RMUtils$.MODULE$.serializeResource(labelAvailableResource));
            Resource labelMaxResource = labelResource.getMaxResource();
            if (!labelAvailableResource.notLess(requestResource)) {
                this.logger().info(new StringBuilder(75).append("Failed check: ").append(labelContainer.getUserCreatorLabel().getUser()).append(" want to use label [").append(labelContainer.getCurrentLabel()).append("] resource[").append(requestResource).append("] > ").append("label available resource[").append(labelAvailableResource).append("]").toString());
                Tuple2<Object, String> notEnoughMessage = this.generateNotEnoughMessage(requestResource, labelAvailableResource, labelMaxResource);
                canCreateECRes.setCanCreateEC(false);
                canCreateECRes.setReason((String)notEnoughMessage._2());
            }
        }
        return canCreateECRes;
    }

    private NodeResource getCombinedLabelResourceUsage(RMLabelContainer labelContainer, NodeResource resource) {
        NodeResource labelResource = this.labelResourceService.getLabelResource(labelContainer.getCurrentLabel());
        if (labelResource == null) {
            labelResource = new CommonNodeResource();
            labelResource.setResourceType(resource.getResourceType());
            labelResource.setUsedResource(Resource.initResource((ResourceType)resource.getResourceType()));
            labelResource.setLockedResource(Resource.initResource((ResourceType)resource.getResourceType()));
            this.logger().info(new StringBuilder(15).append("ResourceInit: ").append(labelContainer.getCurrentLabel().getStringValue()).append(" ").toString());
        }
        Resource configuredResource = UserConfiguration$.MODULE$.getUserConfiguredResource(resource.getResourceType(), labelContainer.getUserCreatorLabel(), labelContainer.getEngineTypeLabel());
        this.logger().debug(new StringBuilder(39).append("Get configured resource ").append(configuredResource).append(" for [").append(labelContainer.getUserCreatorLabel()).append("] and [").append(labelContainer.getEngineTypeLabel()).append("] ").toString());
        labelResource.setMaxResource(configuredResource);
        labelResource.setMinResource(Resource.initResource((ResourceType)labelResource.getResourceType()));
        labelResource.setLeftResource(labelResource.getMaxResource().minus(labelResource.getUsedResource()).minus(labelResource.getLockedResource()));
        this.logger().debug(new StringBuilder(41).append(labelContainer.getCurrentLabel()).append(" ecmResource: Max: ").append(labelResource.getMaxResource()).append("  \t ").append("use:  ").append(labelResource.getUsedResource()).append("  \t locked: ").append(labelResource.getLockedResource()).toString());
        return labelResource;
    }

    public boolean canRequest(RMLabelContainer labelContainer, NodeResource resource, EngineCreateRequest engineCreateRequest) {
        if (!this.enableRequest()) {
            this.logger().info("Resource judgment switch is not turned on, the judgment will be skipped");
            return true;
        }
        Label label = labelContainer.getCurrentLabel();
        if (label instanceof EMInstanceLabel) {
            EMInstanceLabel eMInstanceLabel = (EMInstanceLabel)label;
            return this.checkEMResource(eMInstanceLabel, resource);
        }
        if (!labelContainer.getCombinedResourceLabel().equals(labelContainer.getCurrentLabel())) {
            throw new RMErrorException(ManagerCommonErrorCodeSummary.RESOURCE_LATER_ERROR.getErrorCode(), new StringBuilder(0).append(ManagerCommonErrorCodeSummary.RESOURCE_LATER_ERROR.getErrorDesc()).append(labelContainer.getCurrentLabel()).toString());
        }
        List<Label<?>> labels = labelContainer.getLabels();
        String engineType = LabelUtil$.MODULE$.getEngineType(labels);
        Map props = engineCreateRequest.getProperties();
        boolean acrossClusterTask = false;
        if (props != null) {
            acrossClusterTask = new StringOps(Predef$.MODULE$.augmentString(props.getOrDefault("acrossClusterTask", "false"))).toBoolean();
        }
        if (this.externalResourceService() != null && StringUtils.isNotBlank((CharSequence)engineType) && AMConfiguration.SUPPORT_CLUSTER_RULE_EC_TYPES.contains(engineType) && props != null && acrossClusterTask && !"spark".equals(engineType)) {
            String queueName = props.getOrDefault("wds.linkis.rm.yarnqueue", "default");
            this.logger().info(new StringBuilder(31).append("hive cluster check with queue: ").append(queueName).toString());
            YarnResourceIdentifier yarnIdentifier = new YarnResourceIdentifier(queueName);
            NodeResource providedYarnResource = this.externalResourceService().getResource(ResourceType.Yarn, labelContainer, yarnIdentifier);
            Tuple2 tuple2 = new Tuple2((Object)providedYarnResource.getMaxResource(), (Object)providedYarnResource.getUsedResource());
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Resource maxCapacity = (Resource)tuple2._1();
            Resource usedCapacity = (Resource)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)maxCapacity, (Object)usedCapacity);
            Resource maxCapacity2 = (Resource)tuple22._1();
            Resource usedCapacity2 = (Resource)tuple22._2();
            AcrossClusterRulesJudgeUtils$.MODULE$.originClusterResourceCheck(engineCreateRequest, maxCapacity2, usedCapacity2);
            AcrossClusterRulesJudgeUtils$.MODULE$.targetClusterResourceCheck(labelContainer, engineCreateRequest, maxCapacity2, usedCapacity2, this.externalResourceService());
        }
        Resource requestResource = resource.getMinResource();
        NodeResource labelResource = this.getCombinedLabelResourceUsage(labelContainer, resource);
        this.labelResourceService.setLabelResource(labelContainer.getCurrentLabel(), labelResource, labelContainer.getCombinedResourceLabel().getStringValue());
        this.logger().debug(new StringBuilder(26).append("Label [").append(labelContainer.getCurrentLabel()).append("] has resource + [").append(labelResource).append("]").toString());
        if (labelResource != null) {
            Resource labelAvailableResource = labelResource.getLeftResource();
            Resource labelMaxResource = labelResource.getMaxResource();
            if (!labelAvailableResource.notLess(requestResource)) {
                this.logger().info(new StringBuilder(75).append("Failed check: ").append(labelContainer.getUserCreatorLabel().getUser()).append(" want to use label [").append(labelContainer.getCurrentLabel()).append("] resource[").append(requestResource).append("] > ").append("label available resource[").append(labelAvailableResource).append("]").toString());
                Tuple2<Object, String> notEnoughMessage = this.generateNotEnoughMessage(requestResource, labelAvailableResource, labelMaxResource);
                throw new RMWarnException(notEnoughMessage._1$mcI$sp(), (String)notEnoughMessage._2());
            }
            this.logger().debug(new StringBuilder(76).append("Passed check: ").append(labelContainer.getUserCreatorLabel().getUser()).append(" want to use label [").append(labelContainer.getCurrentLabel()).append("] resource[").append(requestResource).append("] <= ").append("label available resource[").append(labelAvailableResource).append("]").toString());
            return true;
        }
        this.logger().warn(new StringBuilder(38).append("No resource available found for label ").append(labelContainer.getCurrentLabel()).toString());
        throw new RMWarnException(ManagerCommonErrorCodeSummary.NO_RESOURCE.getErrorCode(), MessageFormat.format(ManagerCommonErrorCodeSummary.NO_RESOURCE.getErrorDesc(), labelContainer.getCurrentLabel()));
    }

    private boolean checkEMResource(EMInstanceLabel emInstanceLabel, NodeResource resource) {
        NodeResource labelResource = this.labelResourceService.getLabelResource((Label<?>)emInstanceLabel);
        Resource requestResource = resource.getMinResource();
        this.logger().debug(new StringBuilder(30).append("emInstanceLabel resource info ").append(labelResource).toString());
        if (labelResource != null) {
            Resource labelAvailableResource = labelResource.getLeftResource();
            if (!labelAvailableResource.notLess(requestResource)) {
                this.logger().info(new StringBuilder(54).append("user want to use resource[").append(requestResource).append("] > em ").append(emInstanceLabel.getInstance()).append(" available resource[").append(labelAvailableResource).append("]").toString());
                Tuple2<Object, String> notEnoughMessage = this.generateECMNotEnoughMessage(requestResource, labelAvailableResource, labelResource.getMaxResource());
                throw new RMWarnException(notEnoughMessage._1$mcI$sp(), new StringBuilder(13).append((String)notEnoughMessage._2()).append("ECM Instance:").append(emInstanceLabel.getInstance()).toString());
            }
            this.logger().debug(new StringBuilder(62).append("Passed check: resource[").append(requestResource).append("] want to use em ").append(emInstanceLabel.getInstance()).append("  available resource[").append(labelAvailableResource).append("]").toString());
            return true;
        }
        this.logger().warn(new StringBuilder(36).append("No resource available found for em ").append(emInstanceLabel.getInstance()).append(" ").toString());
        throw new RMWarnException(ManagerCommonErrorCodeSummary.NO_RESOURCE_AVAILABLE.getErrorCode(), MessageFormat.format(ManagerCommonErrorCodeSummary.NO_RESOURCE_AVAILABLE.getErrorDesc(), emInstanceLabel.getInstance()));
    }

    public Tuple2<Object, String> generateECMNotEnoughMessage(Resource requestResource, Resource availableResource, Resource maxResource) {
        LoadInstanceResource loadRequestResource;
        LoadInstanceResource loadInstanceResource;
        Resource resource = requestResource;
        if (resource instanceof LoadInstanceResource) {
            LoadInstanceResource loadInstanceResource2;
            loadInstanceResource = loadInstanceResource2 = (LoadInstanceResource)resource;
        } else if (resource instanceof DriverAndYarnResource) {
            DriverAndYarnResource driverAndYarnResource = (DriverAndYarnResource)resource;
            loadInstanceResource = driverAndYarnResource.getLoadInstanceResource();
        } else {
            loadInstanceResource = null;
        }
        LoadInstanceResource loadInstanceResource3 = loadRequestResource = loadInstanceResource;
        if (loadInstanceResource3 != null) {
            LoadInstanceResource loadInstanceResource4 = loadInstanceResource3;
            LoadInstanceResource loadInstanceAvailable = (LoadInstanceResource)availableResource;
            LoadInstanceResource loadInstanceMax = (LoadInstanceResource)maxResource;
            if (loadInstanceResource4.getCores() > loadInstanceAvailable.getCores()) {
                return new Tuple2((Object)BoxesRunTime.boxToInteger((int)RMErrorCode.ECM_CPU_INSUFFICIENT.getErrorCode()), (Object)new StringBuilder(0).append(RMErrorCode.ECM_CPU_INSUFFICIENT.getErrorDesc()).append(RMUtils$.MODULE$.getResourceInfoMsg("CPU", "cores", BoxesRunTime.boxToInteger((int)loadInstanceResource4.getCores()), BoxesRunTime.boxToInteger((int)loadInstanceAvailable.getCores()), BoxesRunTime.boxToInteger((int)loadInstanceMax.getCores()), RMUtils$.MODULE$.getResourceInfoMsg$default$6())).toString());
            }
            if (loadInstanceResource4.getMemory() > loadInstanceAvailable.getMemory()) {
                return new Tuple2((Object)BoxesRunTime.boxToInteger((int)RMErrorCode.ECM_MEMORY_INSUFFICIENT.getErrorCode()), (Object)new StringBuilder(0).append(RMErrorCode.ECM_MEMORY_INSUFFICIENT.getErrorDesc()).append(RMUtils$.MODULE$.getResourceInfoMsg("Memory", "bytes", BoxesRunTime.boxToLong((long)loadInstanceResource4.getMemory()), BoxesRunTime.boxToLong((long)loadInstanceAvailable.getMemory()), BoxesRunTime.boxToLong((long)loadInstanceMax.getMemory()), RMUtils$.MODULE$.getResourceInfoMsg$default$6())).toString());
            }
            return new Tuple2((Object)BoxesRunTime.boxToInteger((int)RMErrorCode.ECM_INSTANCES_INSUFFICIENT.getErrorCode()), (Object)new StringBuilder(0).append(RMErrorCode.ECM_INSTANCES_INSUFFICIENT.getErrorDesc()).append(RMUtils$.MODULE$.getResourceInfoMsg("Instance", "", BoxesRunTime.boxToInteger((int)loadInstanceResource4.getInstances()), BoxesRunTime.boxToInteger((int)loadInstanceAvailable.getInstances()), BoxesRunTime.boxToInteger((int)loadInstanceMax.getInstances()), RMUtils$.MODULE$.getResourceInfoMsg$default$6())).toString());
        }
        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)RMErrorCode.ECM_RESOURCE_INSUFFICIENT.getErrorCode()), (Object)new StringBuilder(35).append(RMErrorCode.ECM_RESOURCE_INSUFFICIENT.getErrorDesc()).append(" Unusual insufficient queue memory.").toString());
    }

    public Tuple2<Object, String> generateNotEnoughMessage(Resource requestResource, Resource availableResource, Resource maxResource) {
        Resource resource = requestResource;
        if (resource instanceof MemoryResource) {
            MemoryResource memoryResource = (MemoryResource)resource;
            MemoryResource avail = (MemoryResource)availableResource;
            MemoryResource max = (MemoryResource)maxResource;
            return new Tuple2((Object)BoxesRunTime.boxToInteger((int)RMErrorCode.DRIVER_MEMORY_INSUFFICIENT.getErrorCode()), (Object)new StringBuilder(0).append(RMErrorCode.DRIVER_MEMORY_INSUFFICIENT.getErrorDesc()).append(RMUtils$.MODULE$.getResourceInfoMsg("Memory", "bytes", BoxesRunTime.boxToLong((long)memoryResource.getMemory()), BoxesRunTime.boxToLong((long)avail.getMemory()), BoxesRunTime.boxToLong((long)max.getMemory()), RMUtils$.MODULE$.getResourceInfoMsg$default$6())).toString());
        }
        if (resource instanceof InstanceResource) {
            InstanceResource instanceResource = (InstanceResource)resource;
            InstanceResource avail = (InstanceResource)availableResource;
            InstanceResource max = (InstanceResource)maxResource;
            return new Tuple2((Object)BoxesRunTime.boxToInteger((int)RMErrorCode.INSTANCES_INSUFFICIENT.getErrorCode()), (Object)new StringBuilder(0).append(RMErrorCode.INSTANCES_INSUFFICIENT.getErrorDesc()).append(RMUtils$.MODULE$.getResourceInfoMsg("Instance", "", BoxesRunTime.boxToInteger((int)instanceResource.getInstances()), BoxesRunTime.boxToInteger((int)avail.getInstances()), BoxesRunTime.boxToInteger((int)max.getInstances()), RMUtils$.MODULE$.getResourceInfoMsg$default$6())).toString());
        }
        if (resource instanceof CPUResource) {
            CPUResource cPUResource = (CPUResource)resource;
            CPUResource avail = (CPUResource)availableResource;
            CPUResource max = (CPUResource)maxResource;
            return new Tuple2((Object)BoxesRunTime.boxToInteger((int)RMErrorCode.DRIVER_CPU_INSUFFICIENT.getErrorCode()), (Object)new StringBuilder(0).append(RMErrorCode.DRIVER_CPU_INSUFFICIENT.getErrorDesc()).append(RMUtils$.MODULE$.getResourceInfoMsg("CPU", "cores", BoxesRunTime.boxToInteger((int)cPUResource.getCores()), BoxesRunTime.boxToInteger((int)avail.getCores()), BoxesRunTime.boxToInteger((int)max.getCores()), RMUtils$.MODULE$.getResourceInfoMsg$default$6())).toString());
        }
        if (resource instanceof LoadResource) {
            LoadResource loadResource = (LoadResource)resource;
            LoadResource loadAvailable = (LoadResource)availableResource;
            LoadResource avail = (LoadResource)availableResource;
            LoadResource max = (LoadResource)maxResource;
            if (loadResource.getCores() > loadAvailable.getCores()) {
                return new Tuple2((Object)BoxesRunTime.boxToInteger((int)RMErrorCode.DRIVER_CPU_INSUFFICIENT.getErrorCode()), (Object)new StringBuilder(0).append(RMErrorCode.DRIVER_CPU_INSUFFICIENT.getErrorDesc()).append(RMUtils$.MODULE$.getResourceInfoMsg("CPU", "cores", BoxesRunTime.boxToInteger((int)loadResource.getCores()), BoxesRunTime.boxToInteger((int)avail.getCores()), BoxesRunTime.boxToInteger((int)max.getCores()), RMUtils$.MODULE$.getResourceInfoMsg$default$6())).toString());
            }
            return new Tuple2((Object)BoxesRunTime.boxToInteger((int)RMErrorCode.DRIVER_MEMORY_INSUFFICIENT.getErrorCode()), (Object)new StringBuilder(0).append(RMErrorCode.DRIVER_MEMORY_INSUFFICIENT.getErrorDesc()).append(RMUtils$.MODULE$.getResourceInfoMsg("Memory", "bytes", BoxesRunTime.boxToLong((long)loadResource.getMemory()), BoxesRunTime.boxToLong((long)avail.getMemory()), BoxesRunTime.boxToLong((long)max.getMemory()), RMUtils$.MODULE$.getResourceInfoMsg$default$6())).toString());
        }
        if (resource instanceof LoadInstanceResource) {
            LoadInstanceResource loadInstanceResource = (LoadInstanceResource)resource;
            LoadInstanceResource loadInstanceAvailable = (LoadInstanceResource)availableResource;
            LoadInstanceResource avail = (LoadInstanceResource)availableResource;
            LoadInstanceResource max = (LoadInstanceResource)maxResource;
            if (loadInstanceResource.getCores() > loadInstanceAvailable.getCores()) {
                return new Tuple2((Object)BoxesRunTime.boxToInteger((int)RMErrorCode.DRIVER_CPU_INSUFFICIENT.getErrorCode()), (Object)new StringBuilder(0).append(RMErrorCode.DRIVER_CPU_INSUFFICIENT.getErrorDesc()).append(RMUtils$.MODULE$.getResourceInfoMsg("CPU", "cores", BoxesRunTime.boxToInteger((int)loadInstanceResource.getCores()), BoxesRunTime.boxToInteger((int)avail.getCores()), BoxesRunTime.boxToInteger((int)max.getCores()), RMUtils$.MODULE$.getResourceInfoMsg$default$6())).toString());
            }
            if (loadInstanceResource.getMemory() > loadInstanceAvailable.getMemory()) {
                return new Tuple2((Object)BoxesRunTime.boxToInteger((int)RMErrorCode.DRIVER_MEMORY_INSUFFICIENT.getErrorCode()), (Object)new StringBuilder(0).append(RMErrorCode.DRIVER_MEMORY_INSUFFICIENT.getErrorDesc()).append(RMUtils$.MODULE$.getResourceInfoMsg("Memory", "bytes", BoxesRunTime.boxToLong((long)loadInstanceResource.getMemory()), BoxesRunTime.boxToLong((long)avail.getMemory()), BoxesRunTime.boxToLong((long)max.getMemory()), RMUtils$.MODULE$.getResourceInfoMsg$default$6())).toString());
            }
            return new Tuple2((Object)BoxesRunTime.boxToInteger((int)RMErrorCode.INSTANCES_INSUFFICIENT.getErrorCode()), (Object)new StringBuilder(0).append(RMErrorCode.INSTANCES_INSUFFICIENT.getErrorDesc()).append(RMUtils$.MODULE$.getResourceInfoMsg("Instance", "", BoxesRunTime.boxToInteger((int)loadInstanceResource.getInstances()), BoxesRunTime.boxToInteger((int)avail.getInstances()), BoxesRunTime.boxToInteger((int)max.getInstances()), RMUtils$.MODULE$.getResourceInfoMsg$default$6())).toString());
        }
        if (resource instanceof YarnResource) {
            YarnResource yarnResource = (YarnResource)resource;
            YarnResource yarnAvailable = (YarnResource)availableResource;
            YarnResource avail = (YarnResource)availableResource;
            YarnResource max = (YarnResource)maxResource;
            if (yarnResource.getQueueCores() > yarnAvailable.getQueueCores()) {
                return new Tuple2((Object)BoxesRunTime.boxToInteger((int)RMErrorCode.QUEUE_CPU_INSUFFICIENT.getErrorCode()), (Object)new StringBuilder(0).append(RMErrorCode.QUEUE_CPU_INSUFFICIENT.getErrorDesc()).append(RMUtils$.MODULE$.getResourceInfoMsg("CPU", "cores", BoxesRunTime.boxToInteger((int)yarnResource.getQueueCores()), BoxesRunTime.boxToInteger((int)avail.getQueueCores()), BoxesRunTime.boxToInteger((int)max.getQueueCores()), RMUtils$.MODULE$.getResourceInfoMsg$default$6())).toString());
            }
            if (yarnResource.getQueueMemory() > yarnAvailable.getQueueMemory()) {
                return new Tuple2((Object)BoxesRunTime.boxToInteger((int)RMErrorCode.QUEUE_MEMORY_INSUFFICIENT.getErrorCode()), (Object)new StringBuilder(0).append(RMErrorCode.QUEUE_MEMORY_INSUFFICIENT.getErrorDesc()).append(RMUtils$.MODULE$.getResourceInfoMsg("Memory", "bytes", BoxesRunTime.boxToLong((long)yarnResource.getQueueMemory()), BoxesRunTime.boxToLong((long)avail.getQueueMemory()), BoxesRunTime.boxToLong((long)max.getQueueMemory()), RMUtils$.MODULE$.getResourceInfoMsg$default$6())).toString());
            }
            return new Tuple2((Object)BoxesRunTime.boxToInteger((int)RMErrorCode.QUEUE_INSTANCES_INSUFFICIENT.getErrorCode()), (Object)new StringBuilder(0).append(RMErrorCode.QUEUE_INSTANCES_INSUFFICIENT.getErrorDesc()).append(RMUtils$.MODULE$.getResourceInfoMsg("Instance", "", BoxesRunTime.boxToInteger((int)yarnResource.getQueueInstances()), BoxesRunTime.boxToInteger((int)avail.getQueueInstances()), BoxesRunTime.boxToInteger((int)max.getQueueInstances()), RMUtils$.MODULE$.getResourceInfoMsg$default$6())).toString());
        }
        if (resource instanceof DriverAndYarnResource) {
            DriverAndYarnResource driverAndYarnResource = (DriverAndYarnResource)resource;
            DriverAndYarnResource dyAvailable = (DriverAndYarnResource)availableResource;
            DriverAndYarnResource dyMax = (DriverAndYarnResource)maxResource;
            if (driverAndYarnResource.getLoadInstanceResource().getMemory() > dyAvailable.getLoadInstanceResource().getMemory() || driverAndYarnResource.getLoadInstanceResource().getCores() > dyAvailable.getLoadInstanceResource().getCores() || driverAndYarnResource.getLoadInstanceResource().getInstances() > dyAvailable.getLoadInstanceResource().getInstances()) {
                Tuple2<Object, String> detail = this.generateNotEnoughMessage((Resource)driverAndYarnResource.getLoadInstanceResource(), (Resource)dyAvailable.getLoadInstanceResource(), (Resource)dyMax.getLoadInstanceResource());
                return new Tuple2((Object)BoxesRunTime.boxToInteger((int)detail._1$mcI$sp()), detail._2());
            }
            Tuple2<Object, String> detail = this.generateNotEnoughMessage((Resource)driverAndYarnResource.getYarnResource(), (Resource)dyAvailable.getYarnResource(), (Resource)dyMax.getYarnResource());
            return new Tuple2((Object)BoxesRunTime.boxToInteger((int)detail._1$mcI$sp()), detail._2());
        }
        if (resource instanceof SpecialResource) {
            SpecialResource specialResource = (SpecialResource)resource;
            throw new RMWarnException(ManagerCommonErrorCodeSummary.NOT_RESOURCE_TYPE.getErrorCode(), MessageFormat.format(ManagerCommonErrorCodeSummary.NOT_RESOURCE_TYPE.getErrorDesc(), specialResource.getClass()));
        }
        if (resource != null) {
            Resource resource2 = resource;
            throw new RMWarnException(ManagerCommonErrorCodeSummary.NOT_RESOURCE_TYPE.getErrorCode(), MessageFormat.format(ManagerCommonErrorCodeSummary.NOT_RESOURCE_TYPE.getErrorDesc(), resource2.getClass()));
        }
        throw new MatchError((Object)resource);
    }

    public RequestResourceService(LabelResourceService labelResourceService) {
        this.labelResourceService = labelResourceService;
        Logging.$init$((Logging)this);
        this.resourceType = ResourceType.Default;
        this.enableRequest = BoxesRunTime.unboxToBoolean((Object)RMUtils$.MODULE$.RM_REQUEST_ENABLE().getValue());
        this.externalResourceService = null;
    }
}

