/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.entrance.log;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.sql.Date;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hdfs.client.HdfsDataOutputStream;
import org.apache.hadoop.io.IOUtils;
import org.apache.linkis.common.io.FsPath;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.entrance.conf.EntranceConfiguration$;
import org.apache.linkis.entrance.errorcode.EntranceErrorCodeSummary;
import org.apache.linkis.entrance.exception.EntranceErrorException;
import org.apache.linkis.entrance.log.Cache;
import org.apache.linkis.entrance.log.LogWriter;
import org.apache.linkis.storage.FSFactory$;
import org.apache.linkis.storage.fs.FileSystem;
import org.apache.linkis.storage.utils.FileSystemUtils$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.List;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001de\u0001B\u0010!\u0001-B\u0001\u0002\r\u0001\u0003\u0002\u0003\u0006I!\r\u0005\t}\u0001\u0011\t\u0011)A\u0005c!Aq\b\u0001B\u0001B\u0003%\u0001\t\u0003\u0005D\u0001\t\u0005\t\u0015!\u00032\u0011\u0015!\u0005\u0001\"\u0001F\u0011\u001dY\u0005\u00011A\u0005\u00121Cq!\u0016\u0001A\u0002\u0013Ea\u000b\u0003\u0004^\u0001\u0001\u0006K!\u0014\u0005\b=\u0002\u0001\r\u0011\"\u0015`\u0011\u001dA\u0007\u00011A\u0005R%Daa\u001b\u0001!B\u0013\u0001\u0007b\u00027\u0001\u0005\u0004%I!\u001c\u0005\u0007i\u0002\u0001\u000b\u0011\u00028\t\u000fU\u0004!\u0019!C\u0005[\"1a\u000f\u0001Q\u0001\n9Dqa\u001e\u0001A\u0002\u0013%\u0001\u0010C\u0004}\u0001\u0001\u0007I\u0011B?\t\r}\u0004\u0001\u0015)\u0003z\u0011\u001d\t\t\u0001\u0001C\u0005\u0003\u0007Aa!!\u0002\u0001\t\u0003y\u0006bBA&\u0001\u0011%\u0011Q\n\u0005\n\u0003\u001f\u0002!\u0019!C\u0001\u0003#B\u0001\"a\u0018\u0001A\u0003%\u00111\u000b\u0005\b\u0003C\u0002A\u0011AA2\u0011\u001d\tY\u0007\u0001C\u0005\u0003[Bq!a\u001d\u0001\t\u0013\t)\bC\u0004\u0002z\u0001!\t%a\u001f\t\u000f\u0005}\u0004\u0001\"\u0011\u0002\u0004!9\u0011\u0011\u0011\u0001\u0005B\u0005\r\u0001bBAB\u0001\u0011\u0005\u0013Q\u0011\u0002\u0013\u0011\u001235kQ1dQ\u0016dunZ,sSR,'O\u0003\u0002\"E\u0005\u0019An\\4\u000b\u0005\r\"\u0013\u0001C3oiJ\fgnY3\u000b\u0005\u00152\u0013A\u00027j].L7O\u0003\u0002(Q\u00051\u0011\r]1dQ\u0016T\u0011!K\u0001\u0004_J<7\u0001A\n\u0003\u00011\u0002\"!\f\u0018\u000e\u0003\u0001J!a\f\u0011\u0003\u00131{wm\u0016:ji\u0016\u0014\u0018a\u00027pOB\u000bG\u000f\u001b\t\u0003emr!aM\u001d\u0011\u0005Q:T\"A\u001b\u000b\u0005YR\u0013A\u0002\u001fs_>$hHC\u00019\u0003\u0015\u00198-\u00197b\u0013\tQt'\u0001\u0004Qe\u0016$WMZ\u0005\u0003yu\u0012aa\u0015;sS:<'B\u0001\u001e8\u0003\u001d\u0019\u0007.\u0019:tKR\f1b\u001d5be\u0016$7)Y2iKB\u0011Q&Q\u0005\u0003\u0005\u0002\u0012QaQ1dQ\u0016\fA!^:fe\u00061A(\u001b8jiz\"RAR$I\u0013*\u0003\"!\f\u0001\t\u000bA*\u0001\u0019A\u0019\t\u000by*\u0001\u0019A\u0019\t\u000b}*\u0001\u0019\u0001!\t\u000b\r+\u0001\u0019A\u0019\u0002\u0015\u0019LG.Z*zgR,W.F\u0001N!\tq5+D\u0001P\u0015\t\u0001\u0016+\u0001\u0002gg*\u0011!\u000bJ\u0001\bgR|'/Y4f\u0013\t!vJ\u0001\u0006GS2,7+_:uK6\faBZ5mKNK8\u000f^3n?\u0012*\u0017\u000f\u0006\u0002X7B\u0011\u0001,W\u0007\u0002o%\u0011!l\u000e\u0002\u0005+:LG\u000fC\u0004]\u000f\u0005\u0005\t\u0019A'\u0002\u0007a$\u0013'A\u0006gS2,7+_:uK6\u0004\u0013\u0001D8viB,Ho\u0015;sK\u0006lW#\u00011\u0011\u0005\u00054W\"\u00012\u000b\u0005\r$\u0017AA5p\u0015\u0005)\u0017\u0001\u00026bm\u0006L!a\u001a2\u0003\u0019=+H\u000f];u'R\u0014X-Y7\u0002!=,H\u000f];u'R\u0014X-Y7`I\u0015\fHCA,k\u0011\u001da&\"!AA\u0002\u0001\fQb\\;uaV$8\u000b\u001e:fC6\u0004\u0013AC(V)~cujQ&F%V\ta\u000e\u0005\u0002pe6\t\u0001O\u0003\u0002rI\u0006!A.\u00198h\u0013\t\u0019\bO\u0001\u0004PE*,7\r^\u0001\f\u001fV#v\fT(D\u0017\u0016\u0013\u0006%\u0001\u0007X%&#Vi\u0018'P\u0007.+%+A\u0007X%&#Vi\u0018'P\u0007.+%\u000bI\u0001\u000bM&\u00148\u000f^,sSR,W#A=\u0011\u0005aS\u0018BA>8\u0005\u001d\u0011un\u001c7fC:\faBZ5sgR<&/\u001b;f?\u0012*\u0017\u000f\u0006\u0002X}\"9A,EA\u0001\u0002\u0004I\u0018a\u00034jeN$xK]5uK\u0002\nA!\u001b8jiR\tq+A\bhKR|U\u000f\u001e9viN#(/Z1nQ\u0015!\u0012\u0011BA\u000b!\u0015A\u00161BA\b\u0013\r\tia\u000e\u0002\u0007i\"\u0014xn^:\u0011\u0007\u0005\f\t\"C\u0002\u0002\u0014\t\u00141\"S(Fq\u000e,\u0007\u000f^5p]F2a$MA\f\u0003\u0013\n\u0014bIA\r\u0003C\ty$a\t\u0016\t\u0005m\u0011QD\u000b\u0002c\u00119\u0011q\u0004\u0016C\u0002\u0005%\"!\u0001+\n\t\u0005\r\u0012QE\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u0019\u000b\u0007\u0005\u001dr'\u0001\u0004uQJ|wo]\t\u0005\u0003W\t\t\u0004E\u0002Y\u0003[I1!a\f8\u0005\u001dqu\u000e\u001e5j]\u001e\u0004B!a\r\u0002:9\u0019\u0001,!\u000e\n\u0007\u0005]r'A\u0004qC\u000e\\\u0017mZ3\n\t\u0005m\u0012Q\b\u0002\n)\"\u0014xn^1cY\u0016T1!a\u000e8c%\u0019\u0013\u0011IA\"\u0003\u000b\n9CD\u0002Y\u0003\u0007J1!a\n8c\u0015\u0011\u0003lNA$\u0005\u0015\u00198-\u00197bc\r1\u0013qB\u0001\u0012G2|7/Z(viB+Ho\u0015;sK\u0006lW#A,\u0002\u0011A,8\u000f\u001b+j[\u0016,\"!a\u0015\u0011\t\u0005U\u00131L\u0007\u0003\u0003/R1!!\u0017e\u0003\r\u0019\u0018\u000f\\\u0005\u0005\u0003;\n9F\u0001\u0003ECR,\u0017!\u00039vg\"$\u0016.\\3!\u0003!9W\r^\"bG\",WCAA3!\u0011A\u0016q\r!\n\u0007\u0005%tG\u0001\u0004PaRLwN\\\u0001\u0006G\u0006\u001c\u0007.\u001a\u000b\u0004/\u0006=\u0004BBA93\u0001\u0007\u0011'A\u0002ng\u001e\f1b\u001e:ji\u0016$vNR5mKR\u0019q+a\u001e\t\r\u0005E$\u00041\u00012\u0003\u00159(/\u001b;f)\r9\u0016Q\u0010\u0005\u0007\u0003cZ\u0002\u0019A\u0019\u0002\u000b\u0019dWo\u001d5\u0002\u000b\rdwn]3\u0002\u0011Q|7\u000b\u001e:j]\u001e$\u0012!\r")
public class HDFSCacheLogWriter
extends LogWriter {
    private final String logPath;
    private final String charset;
    private final Cache sharedCache;
    private final String user;
    private FileSystem fileSystem;
    private OutputStream outputStream;
    private final Object OUT_LOCKER;
    private final Object WRITE_LOCKER;
    private boolean firstWrite;
    private final Date pushTime;

    public FileSystem fileSystem() {
        return this.fileSystem;
    }

    public void fileSystem_$eq(FileSystem x$1) {
        this.fileSystem = x$1;
    }

    @Override
    public OutputStream outputStream() {
        return this.outputStream;
    }

    @Override
    public void outputStream_$eq(OutputStream x$1) {
        this.outputStream = x$1;
    }

    private Object OUT_LOCKER() {
        return this.OUT_LOCKER;
    }

    private Object WRITE_LOCKER() {
        return this.WRITE_LOCKER;
    }

    private boolean firstWrite() {
        return this.firstWrite;
    }

    private void firstWrite_$eq(boolean x$1) {
        this.firstWrite = x$1;
    }

    private void init() {
        this.fileSystem().init(new HashMap());
        FileSystemUtils$.MODULE$.createNewFileAndSetOwnerWithFileSystem(this.fileSystem(), new FsPath(this.logPath), this.user, true);
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.outputStream() == null) {
            Object object = this.OUT_LOCKER();
            synchronized (object) {
                if (this.outputStream() == null) {
                    if (this.fileSystem() != null) {
                        this.outputStream_$eq(this.fileSystem().write(new FsPath(this.logPath), false));
                    } else {
                        this.logger().warn("fileSystem is null");
                    }
                }
            }
        }
        return this.outputStream();
    }

    private void closeOutPutStream() {
        if (this.outputStream() != null) {
            Object object = this.OUT_LOCKER();
            synchronized (object) {
                if (this.outputStream() != null) {
                    OutputStream outputStream = this.outputStream();
                    if (outputStream instanceof HdfsDataOutputStream) {
                        HdfsDataOutputStream hdfsDataOutputStream = (HdfsDataOutputStream)outputStream;
                        hdfsDataOutputStream.hflush();
                    }
                    IOUtils.closeStream((Closeable)this.outputStream());
                    this.outputStream_$eq(null);
                }
            }
            return;
        }
    }

    public Date pushTime() {
        return this.pushTime;
    }

    public Option<Cache> getCache() {
        return new Some((Object)this.sharedCache);
    }

    private void cache(String msg) {
        if (this.sharedCache.cachedLogs() == null) {
            return;
        }
        Object object = this.WRITE_LOCKER();
        synchronized (object) {
            boolean isNextOneEmpty = this.sharedCache.cachedLogs().isNextOneEmpty();
            Date currentTime = new Date(System.currentTimeMillis());
            if (!isNextOneEmpty || currentTime.after(this.pushTime())) {
                List<String> logs = this.sharedCache.cachedLogs().toList();
                scala.collection.mutable.StringBuilder sb = new scala.collection.mutable.StringBuilder();
                ((List)logs.filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)HDFSCacheLogWriter.$anonfun$cache$1(x$1)))).foreach((Function1 & Serializable & scala.Serializable)log -> sb.append(log).append("\n"));
                this.sharedCache.cachedLogs().fakeClear();
                this.writeToFile(sb.toString());
                this.pushTime().setTime(currentTime.getTime() + (long)BoxesRunTime.unboxToInt((Object)EntranceConfiguration$.MODULE$.LOG_PUSH_INTERVAL_TIME().getValue()));
            }
            this.sharedCache.cachedLogs().add(msg);
        }
    }

    private void writeToFile(String msg) {
        Object object = this.WRITE_LOCKER();
        synchronized (object) {
            Object object2;
            String log = msg;
            if (this.firstWrite()) {
                this.logger().info(new StringBuilder(25).append(this.toString()).append(" write first one line log").toString());
                this.firstWrite_$eq(false);
                object2 = msg;
            } else {
                object2 = BoxedUnit.UNIT;
            }
            Utils$.MODULE$.tryAndWarnMsg((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.getOutputStream().write(log.getBytes($this.charset)), new StringBuilder(44).append(this.toString()).append(" error when write query log to outputStream.").toString(), this.logger());
            this.closeOutPutStream();
        }
    }

    @Override
    public void write(String msg) {
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            String[] rows = msg.split("\n");
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rows)).foreach((Function1 & Serializable & scala.Serializable)row -> {
                HDFSCacheLogWriter.$anonfun$write$1(this, row);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    @Override
    public void flush() {
        scala.collection.mutable.StringBuilder sb = new scala.collection.mutable.StringBuilder();
        if (this.sharedCache.cachedLogs() != null) {
            ((List)this.sharedCache.cachedLogs().toList().filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)HDFSCacheLogWriter.$anonfun$flush$1(x$2)))).foreach((Function1 & Serializable & scala.Serializable)x$3 -> sb.append(x$3).append("\n"));
            this.sharedCache.cachedLogs().clear();
        }
        this.writeToFile(sb.toString());
    }

    @Override
    public void close() {
        super.close();
        Object object = this.fileSystem() != null ? Utils$.MODULE$.tryAndWarnMsg((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.fileSystem().close();
            this.fileSystem_$eq(null);
        }, new StringBuilder(41).append(this.toString()).append(" Error encounters when closing fileSystem").toString(), this.logger()) : BoxedUnit.UNIT;
        this.sharedCache.clearCachedLogs();
    }

    public String toString() {
        return this.logPath;
    }

    public static final /* synthetic */ boolean $anonfun$cache$1(String x$1) {
        return x$1 != null;
    }

    public static final /* synthetic */ void $anonfun$write$1(HDFSCacheLogWriter $this, String row) {
        if (StringUtils.isNotBlank((CharSequence)row)) {
            $this.cache(row);
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$flush$1(String x$2) {
        return x$2 != null;
    }

    public HDFSCacheLogWriter(String logPath, String charset, Cache sharedCache, String user) {
        this.logPath = logPath;
        this.charset = charset;
        this.sharedCache = sharedCache;
        this.user = user;
        super(charset);
        if (StringUtils.isBlank((CharSequence)logPath)) {
            throw new EntranceErrorException(EntranceErrorCodeSummary.LOGPATH_NOT_NULL.getErrorCode(), EntranceErrorCodeSummary.LOGPATH_NOT_NULL.getErrorDesc());
        }
        this.fileSystem = EntranceConfiguration$.MODULE$.ENABLE_HDFS_JVM_USER() ? (FileSystem)FSFactory$.MODULE$.getFs(new FsPath(logPath)) : (FileSystem)FSFactory$.MODULE$.getFsByProxyUser(new FsPath(logPath), user);
        this.outputStream = null;
        this.OUT_LOCKER = new Object();
        this.WRITE_LOCKER = new Object();
        this.firstWrite = true;
        this.init();
        this.pushTime = new Date(System.currentTimeMillis() + (long)BoxesRunTime.unboxToInt((Object)EntranceConfiguration$.MODULE$.LOG_PUSH_INTERVAL_TIME().getValue()));
    }
}

