/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.tokenize;

import java.util.ArrayList;
import opennlp.tools.tokenize.AbstractTokenizer;
import opennlp.tools.util.Span;
import opennlp.tools.util.StringUtil;

public class SimpleTokenizer
extends AbstractTokenizer {
    public static final SimpleTokenizer INSTANCE = new SimpleTokenizer();

    private SimpleTokenizer() {
    }

    @Override
    public Span[] tokenizePos(String s) {
        CharacterEnum charType;
        CharacterEnum state = charType = CharacterEnum.WHITESPACE;
        ArrayList<Span> tokens = new ArrayList<Span>();
        int sl = s.length();
        int start = -1;
        char pc = '\u0000';
        for (int ci = 0; ci < sl; ++ci) {
            char c = s.charAt(ci);
            charType = StringUtil.isWhitespace(c) ? CharacterEnum.WHITESPACE : (Character.isAlphabetic(c) ? CharacterEnum.ALPHABETIC : (Character.isDigit(c) ? CharacterEnum.NUMERIC : CharacterEnum.OTHER));
            if (state == CharacterEnum.WHITESPACE) {
                if (charType != CharacterEnum.WHITESPACE) {
                    start = ci;
                }
            } else if (charType != state || charType == CharacterEnum.OTHER && c != pc) {
                tokens.add(new Span(start, ci));
                start = ci;
            }
            if (this.keepNewLines && this.isLineSeparator(c)) {
                tokens.add(new Span(start, start + 1));
                ++start;
            }
            state = charType;
            pc = c;
        }
        if (charType != CharacterEnum.WHITESPACE) {
            tokens.add(new Span(start, sl));
        }
        return tokens.toArray(new Span[0]);
    }

    private boolean isLineSeparator(char character) {
        return character == '\r' || character == '\n';
    }

    static class CharacterEnum {
        static final CharacterEnum WHITESPACE = new CharacterEnum("whitespace");
        static final CharacterEnum ALPHABETIC = new CharacterEnum("alphabetic");
        static final CharacterEnum NUMERIC = new CharacterEnum("numeric");
        static final CharacterEnum OTHER = new CharacterEnum("other");
        private final String name;

        private CharacterEnum(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

