/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.tag.faces;

import jakarta.faces.component.UIComponent;
import jakarta.faces.component.ValueHolder;
import jakarta.faces.convert.Converter;
import jakarta.faces.view.facelets.FaceletContext;
import jakarta.faces.view.facelets.MetaRule;
import jakarta.faces.view.facelets.Metadata;
import jakarta.faces.view.facelets.MetadataTarget;
import jakarta.faces.view.facelets.TagAttribute;

public final class ValueHolderRule
extends MetaRule {
    public static final ValueHolderRule INSTANCE = new ValueHolderRule();

    @Override
    public Metadata applyRule(String name, TagAttribute attribute, MetadataTarget meta) {
        if (meta.isTargetInstanceOf(ValueHolder.class)) {
            if ("converter".equals(name)) {
                if (attribute.isLiteral()) {
                    return new LiteralConverterMetadata(attribute.getValue());
                }
                return new DynamicConverterMetadata2(attribute);
            }
            if ("value".equals(name)) {
                if (attribute.isLiteral()) {
                    return new LiteralValueMetadata(attribute.getValue());
                }
                return new DynamicValueExpressionMetadata(attribute);
            }
        }
        return null;
    }

    static final class LiteralConverterMetadata
    extends Metadata {
        private final String converterId;

        public LiteralConverterMetadata(String converterId) {
            this.converterId = converterId;
        }

        @Override
        public void applyMetadata(FaceletContext ctx, Object instance) {
            ((ValueHolder)instance).setConverter(ctx.getFacesContext().getApplication().createConverter(this.converterId));
        }
    }

    static final class DynamicConverterMetadata2
    extends Metadata {
        private final TagAttribute attr;

        public DynamicConverterMetadata2(TagAttribute attr) {
            this.attr = attr;
        }

        @Override
        public void applyMetadata(FaceletContext ctx, Object instance) {
            ((UIComponent)instance).setValueExpression("converter", this.attr.getValueExpression(ctx, Converter.class));
        }
    }

    static final class LiteralValueMetadata
    extends Metadata {
        private final String value;

        public LiteralValueMetadata(String value) {
            this.value = value;
        }

        @Override
        public void applyMetadata(FaceletContext ctx, Object instance) {
            ((ValueHolder)instance).setValue(this.value);
        }
    }

    static final class DynamicValueExpressionMetadata
    extends Metadata {
        private final TagAttribute attr;

        public DynamicValueExpressionMetadata(TagAttribute attr) {
            this.attr = attr;
        }

        @Override
        public void applyMetadata(FaceletContext ctx, Object instance) {
            ((UIComponent)instance).setValueExpression("value", this.attr.getValueExpression(ctx, Object.class));
        }
    }
}

