/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
#ifndef __SYS_CONFIG_STORE_H_
#define __SYS_CONFIG_STORE_H_

/**
 * @addtogroup SysConfig Configuration of Apache Mynewt System
 * @{
 */

#include <os/queue.h>
#include <stdint.h>

#ifdef __cplusplus
extern "C" {
#endif

struct conf_store;

/*
 * API for config storage.
 */
typedef void (*conf_store_load_cb)(char *name, char *val, void *cb_arg);
struct conf_store_itf {
    int (*csi_load)(struct conf_store *cs, conf_store_load_cb cb, void *cb_arg);
    int (*csi_save_start)(struct conf_store *cs);
    int (*csi_save)(struct conf_store *cs, const char *name, const char *value);
    int (*csi_save_end)(struct conf_store *cs);
};

struct conf_store {
    SLIST_ENTRY(conf_store) cs_next;
    const struct conf_store_itf *cs_itf;
};

void conf_src_register(struct conf_store *cs);
void conf_dst_register(struct conf_store *cs);


#ifdef __cplusplus
}
#endif

/**
 * @} SysConfig
 */


#endif /* __SYS_CONFIG_H_ */
