/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.authentication.single.user.command;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Properties;
import org.apache.nifi.authentication.single.user.SingleUserCredentials;
import org.apache.nifi.authentication.single.user.encoder.BCryptPasswordEncoder;
import org.apache.nifi.authentication.single.user.encoder.PasswordEncoder;
import org.apache.nifi.authentication.single.user.writer.StandardLoginCredentialsWriter;

public class SetSingleUserCredentials {
    protected static final String PROPERTIES_FILE_PATH = "nifi.properties.file.path";
    protected static final String PROVIDERS_PROPERTY = "nifi.login.identity.provider.configuration.file";
    private static final String PROVIDER_CLASS = "org.apache.nifi.authentication.single.user.SingleUserLoginIdentityProvider";
    private static final PasswordEncoder PASSWORD_ENCODER = new BCryptPasswordEncoder();
    private static final int MINIMUM_USERNAME_LENGTH = 4;
    private static final int MINIMUM_PASSWORD_LENGTH = 12;

    public static void main(String[] arguments) {
        if (arguments.length == 2) {
            String username = arguments[0];
            String password = arguments[1];
            if (username.length() < 4) {
                System.err.printf("ERROR: Username must be at least %d characters%n", 4);
            } else if (password.length() < 12) {
                System.err.printf("ERROR: Password must be at least %d characters%n", 12);
            } else {
                String encodedPassword = PASSWORD_ENCODER.encode(password.toCharArray());
                SetSingleUserCredentials.run(username, encodedPassword);
            }
        } else {
            System.err.printf("Unexpected number of arguments [%d]%n", arguments.length);
            System.err.printf("Usage: %s <username> <password>%n", SetSingleUserCredentials.class.getSimpleName());
        }
    }

    private static void run(String username, String encodedPassword) {
        String propertiesFilePath = System.getProperty(PROPERTIES_FILE_PATH);
        File propertiesFile = new File(propertiesFilePath);
        Properties properties = SetSingleUserCredentials.loadProperties(propertiesFile);
        SingleUserCredentials credentials = new SingleUserCredentials(username, encodedPassword, PROVIDER_CLASS);
        File providersFile = SetSingleUserCredentials.getLoginIdentityProvidersFile(properties);
        SetSingleUserCredentials.setCredentials(credentials, providersFile);
        System.out.printf("Login Identity Providers Processed [%s]%n", providersFile.getAbsolutePath());
    }

    private static void setCredentials(SingleUserCredentials singleUserCredentials, File providersFile) {
        StandardLoginCredentialsWriter writer = new StandardLoginCredentialsWriter(providersFile);
        writer.writeLoginCredentials(singleUserCredentials);
    }

    private static Properties loadProperties(File propertiesFile) {
        Properties properties = new Properties();
        try (FileReader reader = new FileReader(propertiesFile);){
            properties.load(reader);
        }
        catch (IOException e) {
            String message = String.format("Failed to read NiFi Properties [%s]", propertiesFile);
            throw new UncheckedIOException(message, e);
        }
        return properties;
    }

    private static File getLoginIdentityProvidersFile(Properties properties) {
        return new File(properties.getProperty(PROVIDERS_PROPERTY));
    }
}

