/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.management.plugin.servlet.rest;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.qpid.server.management.plugin.RequestType;
import org.apache.qpid.server.management.plugin.servlet.rest.NotFoundException;
import org.apache.qpid.server.management.plugin.servlet.rest.RequestInfo;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.preferences.Preference;
import org.apache.qpid.server.model.preferences.PreferenceFactory;
import org.apache.qpid.server.model.preferences.UserPreferences;
import org.apache.qpid.server.util.FutureHelper;

public class RestUserPreferenceHandler {
    private final long _preferenceOperationTimeout;

    public RestUserPreferenceHandler(long preferenceOperationTimeout) {
        this._preferenceOperationTimeout = preferenceOperationTimeout;
    }

    public void handleDELETE(UserPreferences userPreferences, RequestInfo requestInfo) {
        if (userPreferences == null) {
            throw new NotFoundException("User preferences are not available");
        }
        List<String> preferencesParts = requestInfo.getPreferencesParts();
        Map<String, List<String>> queryParameters = requestInfo.getQueryParameters();
        UUID id = this.getIdFromQueryParameters(queryParameters);
        String type = null;
        String name = null;
        if (preferencesParts.size() == 2) {
            type = preferencesParts.get(0);
            name = preferencesParts.get(1);
        } else if (preferencesParts.size() == 1) {
            type = preferencesParts.get(0);
        } else if (preferencesParts.size() != 0) {
            throw new IllegalArgumentException(String.format("unexpected path '%s'", String.join((CharSequence)"/", preferencesParts)));
        }
        this.awaitFuture(userPreferences.delete(type, name, id));
    }

    public void handlePUT(ConfiguredObject<?> target, RequestInfo requestInfo, Object providedObject) {
        UserPreferences userPreferences = target.getUserPreferences();
        if (userPreferences == null) {
            throw new NotFoundException("User preferences are not available");
        }
        List<String> preferencesParts = requestInfo.getPreferencesParts();
        if (preferencesParts.size() == 2) {
            if (!(providedObject instanceof Map)) {
                throw new IllegalArgumentException("expected object");
            }
            Map providedAttributes = (Map)providedObject;
            String type = preferencesParts.get(0);
            String name = preferencesParts.get(1);
            this.ensureAttributeMatches(providedAttributes, "name", name);
            this.ensureAttributeMatches(providedAttributes, "type", type);
            Preference preference = PreferenceFactory.fromAttributes(target, (Map)providedAttributes);
            this.awaitFuture(userPreferences.replaceByTypeAndName(type, name, preference));
        } else if (preferencesParts.size() == 1) {
            String type = preferencesParts.get(0);
            if (!(providedObject instanceof List)) {
                throw new IllegalArgumentException("expected a list of objects");
            }
            List<Preference> replacementPreferences = this.validateAndConvert(target, type, (List)providedObject);
            this.awaitFuture(userPreferences.replaceByType(type, replacementPreferences));
        } else if (preferencesParts.size() == 0) {
            if (!(providedObject instanceof Map)) {
                throw new IllegalArgumentException("expected object");
            }
            List<Preference> replacementPreferences = this.validateAndConvert(target, (Map)providedObject);
            this.awaitFuture(userPreferences.replace(replacementPreferences));
        } else {
            throw new IllegalArgumentException(String.format("unexpected path '%s'", String.join((CharSequence)"/", preferencesParts)));
        }
    }

    public void handlePOST(ConfiguredObject<?> target, RequestInfo requestInfo, Object providedObject) {
        UserPreferences userPreferences = target.getUserPreferences();
        if (userPreferences == null) {
            throw new NotFoundException("User preferences are not available");
        }
        List<String> preferencesParts = requestInfo.getPreferencesParts();
        LinkedHashSet<Preference> preferences = new LinkedHashSet<Preference>();
        if (preferencesParts.size() == 1) {
            String type = preferencesParts.get(0);
            if (!(providedObject instanceof List)) {
                throw new IllegalArgumentException("expected a list of objects");
            }
            preferences.addAll(this.validateAndConvert(target, type, (List)providedObject));
        } else if (preferencesParts.size() == 0) {
            if (!(providedObject instanceof Map)) {
                throw new IllegalArgumentException("expected object");
            }
            preferences.addAll(this.validateAndConvert(target, (Map)providedObject));
        } else {
            throw new IllegalArgumentException(String.format("unexpected path '%s'", String.join((CharSequence)"/", preferencesParts)));
        }
        this.awaitFuture(userPreferences.updateOrAppend(preferences));
    }

    public Object handleGET(UserPreferences userPreferences, RequestInfo requestInfo) {
        CompletableFuture allPreferencesFuture;
        if (userPreferences == null) {
            throw new NotFoundException("User preferences are not available");
        }
        List<String> preferencesParts = requestInfo.getPreferencesParts();
        Map<String, List<String>> queryParameters = requestInfo.getQueryParameters();
        UUID id = this.getIdFromQueryParameters(queryParameters);
        if (requestInfo.getType() == RequestType.USER_PREFERENCES) {
            allPreferencesFuture = userPreferences.getPreferences();
        } else if (requestInfo.getType() == RequestType.VISIBLE_PREFERENCES) {
            allPreferencesFuture = userPreferences.getVisiblePreferences();
        } else {
            throw new IllegalStateException(String.format("RestUserPreferenceHandler called with a unsupported request type: %s", new Object[]{requestInfo.getType()}));
        }
        Set allPreferences = (Set)this.awaitFuture(allPreferencesFuture);
        if (preferencesParts.size() == 2) {
            String type = preferencesParts.get(0);
            String name = preferencesParts.get(1);
            Preference foundPreference = null;
            for (Preference preference : allPreferences) {
                if (!preference.getType().equals(type) || !preference.getName().equals(name)) continue;
                if (id != null && !id.equals(preference.getId())) break;
                foundPreference = preference;
                break;
            }
            if (foundPreference != null) {
                return foundPreference.getAttributes();
            }
            String errorMessage = id == null ? String.format("Preference with name '%s' of type '%s' cannot be found", name, type) : String.format("Preference with name '%s' of type '%s' and id '%s' cannot be found", name, type, id);
            throw new NotFoundException(errorMessage);
        }
        if (preferencesParts.size() == 1) {
            String type = preferencesParts.get(0);
            ArrayList<Map> preferences = new ArrayList<Map>();
            for (Preference preference : allPreferences) {
                if (!preference.getType().equals(type) || id != null && !id.equals(preference.getId())) continue;
                preferences.add(preference.getAttributes());
            }
            return preferences;
        }
        if (preferencesParts.size() == 0) {
            HashMap preferences = new HashMap();
            for (Preference preference : allPreferences) {
                if (id != null && !id.equals(preference.getId())) continue;
                String type = preference.getType();
                if (!preferences.containsKey(type)) {
                    preferences.put(type, new ArrayList());
                }
                ((List)preferences.get(type)).add(preference.getAttributes());
            }
            return preferences;
        }
        throw new IllegalArgumentException(String.format("unexpected path '%s'", String.join((CharSequence)"/", preferencesParts)));
    }

    private <T> T awaitFuture(CompletableFuture<T> future) {
        return (T)FutureHelper.await(future, (long)this._preferenceOperationTimeout, (TimeUnit)TimeUnit.MILLISECONDS);
    }

    private List<Preference> validateAndConvert(ConfiguredObject<?> target, Map<String, Object> providedObjectMap) {
        ArrayList<Preference> replacementPreferences = new ArrayList<Preference>();
        for (String type : providedObjectMap.keySet()) {
            if (!(providedObjectMap.get(type) instanceof List)) {
                String errorMessage = String.format("expected a list of objects for attribute '%s'", type);
                throw new IllegalArgumentException(errorMessage);
            }
            for (Object preferenceObject : (List)providedObjectMap.get(type)) {
                if (!(preferenceObject instanceof Map)) {
                    String errorMessage = String.format("encountered non preference object in list of type '%s'", type);
                    throw new IllegalArgumentException(errorMessage);
                }
                Map preferenceAttributes = (Map)preferenceObject;
                this.ensureAttributeMatches(preferenceAttributes, "type", type);
                Preference preference = PreferenceFactory.fromAttributes(target, (Map)preferenceAttributes);
                replacementPreferences.add(preference);
            }
        }
        return replacementPreferences;
    }

    private List<Preference> validateAndConvert(ConfiguredObject<?> target, String type, List<Object> providedObjects) {
        ArrayList<Preference> replacementPreferences = new ArrayList<Preference>();
        for (Object preferenceObject : providedObjects) {
            if (!(preferenceObject instanceof Map)) {
                throw new IllegalArgumentException("expected a list of objects");
            }
            Map preferenceAttributes = (Map)preferenceObject;
            this.ensureAttributeMatches(preferenceAttributes, "type", type);
            Preference preference = PreferenceFactory.fromAttributes(target, (Map)preferenceAttributes);
            replacementPreferences.add(preference);
        }
        return replacementPreferences;
    }

    private UUID getIdFromQueryParameters(Map<String, List<String>> queryParameters) {
        List<String> ids = queryParameters.get("id");
        if (ids != null && ids.size() > 1) {
            throw new IllegalArgumentException("Multiple ids in query string are not allowed");
        }
        return ids == null ? null : UUID.fromString(ids.get(0));
    }

    private void ensureAttributeMatches(Map<String, Object> preferenceAttributes, String attributeName, String expectedValue) {
        Object providedValue = preferenceAttributes.get(attributeName);
        if (providedValue != null) {
            if (!Objects.equals(providedValue, expectedValue)) {
                String errorMessage = String.format("The attribute '%s' within the payload ('%s') contradicts the value implied by the url ('%s')", attributeName, providedValue, expectedValue);
                throw new IllegalArgumentException(errorMessage);
            }
        } else {
            preferenceAttributes.put(attributeName, expectedValue);
        }
    }

    private String getProvidedAttributeAsString(Map<String, Object> preferenceAttributes, String attributeName) {
        Object providedValue = preferenceAttributes.get(attributeName);
        if (providedValue != null && !(providedValue instanceof String)) {
            String errorMessage = String.format("Attribute '%s' must be of type string. Found : '%s'", attributeName, providedValue);
            throw new IllegalArgumentException(errorMessage);
        }
        return (String)providedValue;
    }
}

