/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.client.impl;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.qpid.protonj2.client.Accepted;
import org.apache.qpid.protonj2.client.DeliveryState;
import org.apache.qpid.protonj2.client.Modified;
import org.apache.qpid.protonj2.client.Rejected;
import org.apache.qpid.protonj2.client.Released;
import org.apache.qpid.protonj2.client.Transactional;
import org.apache.qpid.protonj2.client.impl.ClientConversionSupport;
import org.apache.qpid.protonj2.types.Symbol;
import org.apache.qpid.protonj2.types.messaging.Outcome;
import org.apache.qpid.protonj2.types.transactions.TransactionalState;
import org.apache.qpid.protonj2.types.transport.ErrorCondition;

public abstract class ClientDeliveryState
implements DeliveryState {
    abstract org.apache.qpid.protonj2.types.transport.DeliveryState getProtonDeliveryState();

    static DeliveryState fromProtonType(Outcome outcome) {
        if (outcome == null) {
            return null;
        }
        if (outcome instanceof org.apache.qpid.protonj2.types.messaging.Accepted) {
            return ClientAccepted.getInstance();
        }
        if (outcome instanceof org.apache.qpid.protonj2.types.messaging.Released) {
            return ClientReleased.getInstance();
        }
        if (outcome instanceof org.apache.qpid.protonj2.types.messaging.Rejected) {
            return ClientRejected.fromProtonType((org.apache.qpid.protonj2.types.messaging.Rejected)outcome);
        }
        if (outcome instanceof org.apache.qpid.protonj2.types.messaging.Modified) {
            return ClientModified.fromProtonType((org.apache.qpid.protonj2.types.messaging.Modified)outcome);
        }
        throw new IllegalArgumentException("Cannot map to unknown Proton Outcome to a DeliveryStateType: " + String.valueOf(outcome));
    }

    static DeliveryState fromProtonType(org.apache.qpid.protonj2.types.transport.DeliveryState state) {
        if (state == null) {
            return null;
        }
        switch (state.getType()) {
            case Accepted: {
                return ClientAccepted.getInstance();
            }
            case Released: {
                return ClientReleased.getInstance();
            }
            case Rejected: {
                return ClientRejected.fromProtonType((org.apache.qpid.protonj2.types.messaging.Rejected)state);
            }
            case Modified: {
                return ClientModified.fromProtonType((org.apache.qpid.protonj2.types.messaging.Modified)state);
            }
            case Transactional: {
                return ClientTransactional.fromProtonType((TransactionalState)state);
            }
        }
        throw new IllegalArgumentException("Cannot map to unknown Proton Delivery State type");
    }

    static DeliveryState.Type fromOutcomeSymbol(Symbol outcome) {
        if (outcome == null) {
            return null;
        }
        try {
            return DeliveryState.Type.valueOf(outcome.toString().toUpperCase());
        }
        catch (Throwable error) {
            throw new IllegalArgumentException("Cannot map outcome name to unknown Proton DeliveryState.Type");
        }
    }

    static org.apache.qpid.protonj2.types.transport.DeliveryState asProtonType(DeliveryState state) {
        if (state == null) {
            return null;
        }
        if (state instanceof ClientDeliveryState) {
            return ((ClientDeliveryState)state).getProtonDeliveryState();
        }
        switch (state.getType()) {
            case ACCEPTED: {
                return org.apache.qpid.protonj2.types.messaging.Accepted.getInstance();
            }
            case RELEASED: {
                return org.apache.qpid.protonj2.types.messaging.Released.getInstance();
            }
            case REJECTED: {
                return ClientRejected.fromUnknownClientType(state);
            }
            case MODIFIED: {
                return ClientModified.fromUnknownClientType(state);
            }
            case TRANSACTIONAL: {
                throw new IllegalArgumentException("Cannot manually enlist delivery in AMQP Transactions");
            }
        }
        throw new UnsupportedOperationException("Client does not support the given Delivery State type: " + String.valueOf((Object)state.getType()));
    }

    public static class ClientAccepted
    extends ClientDeliveryState
    implements Accepted {
        private static final ClientAccepted INSTANCE = new ClientAccepted();

        private ClientAccepted() {
        }

        @Override
        org.apache.qpid.protonj2.types.transport.DeliveryState getProtonDeliveryState() {
            return org.apache.qpid.protonj2.types.messaging.Accepted.getInstance();
        }

        public static ClientAccepted getInstance() {
            return INSTANCE;
        }
    }

    public static class ClientReleased
    extends ClientDeliveryState
    implements Released {
        private static final ClientReleased INSTANCE = new ClientReleased();

        private ClientReleased() {
        }

        @Override
        org.apache.qpid.protonj2.types.transport.DeliveryState getProtonDeliveryState() {
            return org.apache.qpid.protonj2.types.messaging.Released.getInstance();
        }

        public static ClientReleased getInstance() {
            return INSTANCE;
        }
    }

    public static class ClientRejected
    extends ClientDeliveryState
    implements Rejected {
        private final org.apache.qpid.protonj2.types.messaging.Rejected rejected = new org.apache.qpid.protonj2.types.messaging.Rejected();

        ClientRejected(org.apache.qpid.protonj2.types.messaging.Rejected source) {
            if (source.getError() != null) {
                this.rejected.setError(source.getError().copy());
            }
        }

        public ClientRejected(String condition, String description) {
            if (condition != null || description != null) {
                this.rejected.setError(new ErrorCondition(Symbol.valueOf((String)condition), description));
            }
        }

        public ClientRejected(String condition, String description, Map<String, Object> info) {
            if (condition != null || description != null) {
                this.rejected.setError(new ErrorCondition(Symbol.valueOf((String)condition), description, ClientConversionSupport.toSymbolKeyedMap(info)));
            }
        }

        @Override
        org.apache.qpid.protonj2.types.transport.DeliveryState getProtonDeliveryState() {
            return this.rejected;
        }

        @Override
        public String getCondition() {
            if (this.rejected != null && this.rejected.getError() != null && this.rejected.getError().getCondition() != null) {
                return this.rejected.getError().getCondition().toString();
            }
            return null;
        }

        @Override
        public String getDescription() {
            if (this.rejected != null && this.rejected.getError() != null) {
                return this.rejected.getError().getDescription();
            }
            return null;
        }

        @Override
        public Map<String, Object> getInfo() {
            if (this.rejected != null && this.rejected.getError() != null) {
                return ClientConversionSupport.toStringKeyedMap(this.rejected.getError().getInfo());
            }
            return null;
        }

        static ClientRejected fromProtonType(org.apache.qpid.protonj2.types.messaging.Rejected rejected) {
            return new ClientRejected(rejected);
        }

        static org.apache.qpid.protonj2.types.messaging.Rejected fromUnknownClientType(DeliveryState deliveryState) {
            if (deliveryState instanceof Rejected) {
                Rejected rejectedState = (Rejected)deliveryState;
                return new org.apache.qpid.protonj2.types.messaging.Rejected(new ErrorCondition(rejectedState.getCondition(), rejectedState.getDescription(), ClientConversionSupport.toSymbolKeyedMap(rejectedState.getInfo())));
            }
            return new org.apache.qpid.protonj2.types.messaging.Rejected();
        }
    }

    public static class ClientModified
    extends ClientDeliveryState
    implements Modified {
        private final org.apache.qpid.protonj2.types.messaging.Modified modified = new org.apache.qpid.protonj2.types.messaging.Modified();

        ClientModified(org.apache.qpid.protonj2.types.messaging.Modified modified) {
            this.modified.setDeliveryFailed(modified.isDeliveryFailed());
            this.modified.setUndeliverableHere(modified.isUndeliverableHere());
            if (modified.getMessageAnnotations() != null) {
                this.modified.setMessageAnnotations(new LinkedHashMap(modified.getMessageAnnotations()));
            }
        }

        public ClientModified(boolean failed, boolean undeliverable) {
            this.modified.setDeliveryFailed(failed);
            this.modified.setUndeliverableHere(undeliverable);
        }

        public ClientModified(boolean failed, boolean undeliverable, Map<String, Object> annotations) {
            this.modified.setDeliveryFailed(failed);
            this.modified.setUndeliverableHere(undeliverable);
            this.modified.setMessageAnnotations(ClientConversionSupport.toSymbolKeyedMap(annotations));
        }

        @Override
        org.apache.qpid.protonj2.types.transport.DeliveryState getProtonDeliveryState() {
            return this.modified;
        }

        @Override
        public boolean isDeliveryFailed() {
            return this.modified.isDeliveryFailed();
        }

        @Override
        public boolean isUndeliverableHere() {
            return this.modified.isUndeliverableHere();
        }

        @Override
        public Map<String, Object> getMessageAnnotations() {
            return ClientConversionSupport.toStringKeyedMap(this.modified.getMessageAnnotations());
        }

        static ClientModified fromProtonType(org.apache.qpid.protonj2.types.messaging.Modified modified) {
            return new ClientModified(modified);
        }

        static org.apache.qpid.protonj2.types.messaging.Modified fromUnknownClientType(DeliveryState deliveryState) {
            if (deliveryState instanceof Modified) {
                Modified modifiedState = (Modified)deliveryState;
                return new org.apache.qpid.protonj2.types.messaging.Modified(modifiedState.isDeliveryFailed(), modifiedState.isUndeliverableHere(), ClientConversionSupport.toSymbolKeyedMap(modifiedState.getMessageAnnotations()));
            }
            return new org.apache.qpid.protonj2.types.messaging.Modified();
        }
    }

    public static class ClientTransactional
    extends ClientDeliveryState
    implements Transactional {
        private final TransactionalState txnState = new TransactionalState();

        ClientTransactional(TransactionalState txnState) {
            this.txnState.setOutcome(txnState.getOutcome());
            this.txnState.setTxnId(txnState.getTxnId().copy());
        }

        @Override
        public boolean isAccepted() {
            return this.txnState.getOutcome() instanceof org.apache.qpid.protonj2.types.messaging.Accepted;
        }

        @Override
        public boolean isRejected() {
            return this.txnState.getOutcome() instanceof org.apache.qpid.protonj2.types.messaging.Rejected;
        }

        @Override
        public boolean isReleased() {
            return this.txnState.getOutcome() instanceof org.apache.qpid.protonj2.types.messaging.Released;
        }

        @Override
        public boolean isModified() {
            return this.txnState.getOutcome() instanceof org.apache.qpid.protonj2.types.messaging.Modified;
        }

        @Override
        public DeliveryState getOutcome() {
            return ClientTransactional.fromProtonType(this.txnState.getOutcome());
        }

        @Override
        org.apache.qpid.protonj2.types.transport.DeliveryState getProtonDeliveryState() {
            return this.txnState;
        }

        static ClientTransactional fromProtonType(TransactionalState txnState) {
            return new ClientTransactional(txnState);
        }
    }
}

