/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.consumer.store;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.rocketmq.client.consumer.store.ControllableOffset;
import org.apache.rocketmq.client.consumer.store.OffsetStore;
import org.apache.rocketmq.client.consumer.store.ReadOffsetType;
import org.apache.rocketmq.client.exception.MQBrokerException;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.client.exception.OffsetNotFoundException;
import org.apache.rocketmq.client.impl.FindBrokerResult;
import org.apache.rocketmq.client.impl.factory.MQClientInstance;
import org.apache.rocketmq.common.UtilAll;
import org.apache.rocketmq.common.message.MessageQueue;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.remoting.exception.RemotingException;
import org.apache.rocketmq.remoting.protocol.header.QueryConsumerOffsetRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.UpdateConsumerOffsetRequestHeader;

public class RemoteBrokerOffsetStore
implements OffsetStore {
    private static final Logger log = LoggerFactory.getLogger(RemoteBrokerOffsetStore.class);
    private final MQClientInstance mQClientFactory;
    private final String groupName;
    private ConcurrentMap<MessageQueue, ControllableOffset> offsetTable = new ConcurrentHashMap<MessageQueue, ControllableOffset>();

    public RemoteBrokerOffsetStore(MQClientInstance mQClientFactory, String groupName) {
        this.mQClientFactory = mQClientFactory;
        this.groupName = groupName;
    }

    @Override
    public void load() {
    }

    @Override
    public void updateOffset(MessageQueue mq, long offset, boolean increaseOnly) {
        if (mq != null) {
            ControllableOffset offsetOld = (ControllableOffset)this.offsetTable.get(mq);
            if (null == offsetOld) {
                offsetOld = this.offsetTable.putIfAbsent(mq, new ControllableOffset(offset));
            }
            if (null != offsetOld) {
                if (increaseOnly) {
                    offsetOld.update(offset, true);
                } else {
                    offsetOld.update(offset);
                }
            }
        }
    }

    @Override
    public void updateAndFreezeOffset(MessageQueue mq, long offset) {
        if (mq != null) {
            this.offsetTable.computeIfAbsent(mq, k -> new ControllableOffset(offset)).updateAndFreeze(offset);
        }
    }

    @Override
    public long readOffset(MessageQueue mq, ReadOffsetType type) {
        if (mq != null) {
            switch (type) {
                case MEMORY_FIRST_THEN_STORE: 
                case READ_FROM_MEMORY: {
                    ControllableOffset offset = (ControllableOffset)this.offsetTable.get(mq);
                    if (offset != null) {
                        return offset.getOffset();
                    }
                    if (ReadOffsetType.READ_FROM_MEMORY == type) {
                        return -1L;
                    }
                }
                case READ_FROM_STORE: {
                    try {
                        long brokerOffset = this.fetchConsumeOffsetFromBroker(mq);
                        this.updateOffset(mq, brokerOffset, false);
                        return brokerOffset;
                    }
                    catch (OffsetNotFoundException e) {
                        return -1L;
                    }
                    catch (Exception e) {
                        log.warn("fetchConsumeOffsetFromBroker exception, " + mq, (Throwable)e);
                        return -2L;
                    }
                }
            }
        }
        return -3L;
    }

    @Override
    public void persistAll(Set<MessageQueue> mqs) {
        if (null == mqs || mqs.isEmpty()) {
            return;
        }
        HashSet<MessageQueue> unusedMQ = new HashSet<MessageQueue>();
        for (Map.Entry entry : this.offsetTable.entrySet()) {
            MessageQueue mq = (MessageQueue)entry.getKey();
            ControllableOffset offset = (ControllableOffset)entry.getValue();
            if (offset == null) continue;
            if (mqs.contains(mq)) {
                try {
                    this.updateConsumeOffsetToBroker(mq, offset.getOffset());
                    log.info("[persistAll] Group: {} ClientId: {} updateConsumeOffsetToBroker {} {}", new Object[]{this.groupName, this.mQClientFactory.getClientId(), mq, offset.getOffset()});
                }
                catch (Exception e) {
                    log.error("updateConsumeOffsetToBroker exception, " + mq.toString(), (Throwable)e);
                }
                continue;
            }
            unusedMQ.add(mq);
        }
        if (!unusedMQ.isEmpty()) {
            for (MessageQueue mq : unusedMQ) {
                this.offsetTable.remove(mq);
                log.info("remove unused mq, {}, {}", (Object)mq, (Object)this.groupName);
            }
        }
    }

    @Override
    public void persist(MessageQueue mq) {
        ControllableOffset offset = (ControllableOffset)this.offsetTable.get(mq);
        if (offset != null) {
            try {
                this.updateConsumeOffsetToBroker(mq, offset.getOffset());
                log.info("[persist] Group: {} ClientId: {} updateConsumeOffsetToBroker {} {}", new Object[]{this.groupName, this.mQClientFactory.getClientId(), mq, offset.getOffset()});
            }
            catch (Exception e) {
                log.error("updateConsumeOffsetToBroker exception, " + mq.toString(), (Throwable)e);
            }
        }
    }

    @Override
    public void removeOffset(MessageQueue mq) {
        if (mq != null) {
            this.offsetTable.remove(mq);
            log.info("remove unnecessary messageQueue offset. group={}, mq={}, offsetTableSize={}", new Object[]{this.groupName, mq, this.offsetTable.size()});
        }
    }

    @Override
    public Map<MessageQueue, Long> cloneOffsetTable(String topic) {
        HashMap<MessageQueue, Long> cloneOffsetTable = new HashMap<MessageQueue, Long>(this.offsetTable.size(), 1.0f);
        for (Map.Entry entry : this.offsetTable.entrySet()) {
            MessageQueue mq = (MessageQueue)entry.getKey();
            if (!UtilAll.isBlank((String)topic) && !topic.equals(mq.getTopic())) continue;
            cloneOffsetTable.put(mq, ((ControllableOffset)entry.getValue()).getOffset());
        }
        return cloneOffsetTable;
    }

    private void updateConsumeOffsetToBroker(MessageQueue mq, long offset) throws RemotingException, MQBrokerException, InterruptedException, MQClientException {
        this.updateConsumeOffsetToBroker(mq, offset, true);
    }

    @Override
    public void updateConsumeOffsetToBroker(MessageQueue mq, long offset, boolean isOneway) throws RemotingException, MQBrokerException, InterruptedException, MQClientException {
        FindBrokerResult findBrokerResult = this.mQClientFactory.findBrokerAddressInSubscribe(this.mQClientFactory.getBrokerNameFromMessageQueue(mq), 0L, false);
        if (null == findBrokerResult) {
            this.mQClientFactory.updateTopicRouteInfoFromNameServer(mq.getTopic());
            findBrokerResult = this.mQClientFactory.findBrokerAddressInSubscribe(this.mQClientFactory.getBrokerNameFromMessageQueue(mq), 0L, false);
        }
        if (findBrokerResult != null) {
            UpdateConsumerOffsetRequestHeader requestHeader = new UpdateConsumerOffsetRequestHeader();
            requestHeader.setTopic(mq.getTopic());
            requestHeader.setConsumerGroup(this.groupName);
            requestHeader.setQueueId(Integer.valueOf(mq.getQueueId()));
            requestHeader.setCommitOffset(Long.valueOf(offset));
            requestHeader.setBrokerName(mq.getBrokerName());
            if (isOneway) {
                this.mQClientFactory.getMQClientAPIImpl().updateConsumerOffsetOneway(findBrokerResult.getBrokerAddr(), requestHeader, 5000L);
            } else {
                this.mQClientFactory.getMQClientAPIImpl().updateConsumerOffset(findBrokerResult.getBrokerAddr(), requestHeader, 5000L);
            }
        } else {
            throw new MQClientException("The broker[" + mq.getBrokerName() + "] not exist", null);
        }
    }

    private long fetchConsumeOffsetFromBroker(MessageQueue mq) throws RemotingException, MQBrokerException, InterruptedException, MQClientException {
        FindBrokerResult findBrokerResult = this.mQClientFactory.findBrokerAddressInSubscribe(this.mQClientFactory.getBrokerNameFromMessageQueue(mq), 0L, true);
        if (null == findBrokerResult) {
            this.mQClientFactory.updateTopicRouteInfoFromNameServer(mq.getTopic());
            findBrokerResult = this.mQClientFactory.findBrokerAddressInSubscribe(this.mQClientFactory.getBrokerNameFromMessageQueue(mq), 0L, false);
        }
        if (findBrokerResult != null) {
            QueryConsumerOffsetRequestHeader requestHeader = new QueryConsumerOffsetRequestHeader();
            requestHeader.setTopic(mq.getTopic());
            requestHeader.setConsumerGroup(this.groupName);
            requestHeader.setQueueId(Integer.valueOf(mq.getQueueId()));
            requestHeader.setBrokerName(mq.getBrokerName());
            return this.mQClientFactory.getMQClientAPIImpl().queryConsumerOffset(findBrokerResult.getBrokerAddr(), requestHeader, 5000L);
        }
        throw new MQClientException("The broker[" + mq.getBrokerName() + "] not exist", null);
    }
}

