/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.registry.lightweight;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.vertx.core.json.jackson.DatabindCodec;
import java.io.IOException;
import org.apache.servicecomb.registry.lightweight.MessageType;
import org.apache.servicecomb.registry.lightweight.RegisterRequest;
import org.apache.servicecomb.registry.lightweight.UnregisterRequest;

public class Message<T> {
    private MessageType type;
    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type", include=JsonTypeInfo.As.EXTERNAL_PROPERTY)
    @JsonSubTypes(value={@JsonSubTypes.Type(name="REGISTER", value=RegisterRequest.class), @JsonSubTypes.Type(name="UNREGISTER", value=UnregisterRequest.class)})
    private T body;

    public static <T> Message<T> of(MessageType type, T body) {
        return new Message<T>().setType(type).setBody(body);
    }

    public MessageType getType() {
        return this.type;
    }

    public Message<T> setType(MessageType type) {
        this.type = type;
        return this;
    }

    public T getBody() {
        return this.body;
    }

    public Message<T> setBody(T body) {
        this.body = body;
        return this;
    }

    public byte[] encode() throws IOException {
        return DatabindCodec.mapper().writeValueAsBytes((Object)this);
    }

    public static Message<?> decode(byte[] bytes, int length) throws IOException {
        return (Message)DatabindCodec.mapper().readValue(bytes, 0, length, Message.class);
    }
}

