/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.config;

import org.apache.shenyu.admin.config.properties.HttpSyncProperties;
import org.apache.shenyu.admin.listener.http.HttpLongPollingDataChangedListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={HttpSyncProperties.class})
@ConditionalOnProperty(prefix="shenyu.sync.http", name={"enabled"}, havingValue="true")
public class HttpLongPollingSyncConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(HttpLongPollingSyncConfiguration.class);

    @Bean
    @ConditionalOnMissingBean(value={HttpLongPollingDataChangedListener.class})
    public HttpLongPollingDataChangedListener httpLongPollingDataChangedListener(HttpSyncProperties httpSyncProperties) {
        LOG.info("you use http long polling sync");
        return new HttpLongPollingDataChangedListener(httpSyncProperties);
    }
}

