/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.breeze.serializer;

import com.weibo.breeze.BreezeBuffer;
import com.weibo.breeze.BreezeException;
import com.weibo.breeze.BreezeReader;
import com.weibo.breeze.BreezeWriter;
import com.weibo.breeze.serializer.Serializer;
import com.weibo.breeze.type.Types;
import java.util.Date;

public class DateSerializer
implements Serializer<Date> {
    private static final String[] names = new String[]{Date.class.getName()};

    @Override
    public void writeToBuf(Date date, BreezeBuffer buffer) throws BreezeException {
        BreezeWriter.writeMessage(buffer, () -> Types.TYPE_INT64.writeMessageField(buffer, 1, date.getTime()));
    }

    @Override
    public Date readFromBuf(BreezeBuffer buffer) throws BreezeException {
        Date date = new Date(0L);
        BreezeReader.readMessage(buffer, index -> {
            switch (index) {
                case 1: {
                    date.setTime((Long)Types.TYPE_INT64.read(buffer));
                }
            }
        });
        return date;
    }

    @Override
    public String[] getNames() {
        return names;
    }
}

