/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core;

import co.elastic.clients.elasticsearch._types.ShardStatistics;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class TermsEnumResponse
implements JsonpSerializable {
    private final ShardStatistics shards;
    private final List<String> terms;
    private final boolean complete;
    public static final JsonpDeserializer<TermsEnumResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TermsEnumResponse::setupTermsEnumResponseDeserializer);

    private TermsEnumResponse(Builder builder) {
        this.shards = ApiTypeHelper.requireNonNull(builder.shards, this, "shards");
        this.terms = ApiTypeHelper.unmodifiableRequired(builder.terms, (Object)this, "terms");
        this.complete = ApiTypeHelper.requireNonNull(builder.complete, this, "complete");
    }

    public static TermsEnumResponse of(Function<Builder, ObjectBuilder<TermsEnumResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final ShardStatistics shards() {
        return this.shards;
    }

    public final List<String> terms() {
        return this.terms;
    }

    public final boolean complete() {
        return this.complete;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("_shards");
        this.shards.serialize(generator, mapper);
        if (ApiTypeHelper.isDefined(this.terms)) {
            generator.writeKey("terms");
            generator.writeStartArray();
            for (String item0 : this.terms) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        generator.writeKey("complete");
        generator.write(this.complete);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupTermsEnumResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::shards, ShardStatistics._DESERIALIZER, "_shards");
        op.add(Builder::terms, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "terms");
        op.add(Builder::complete, JsonpDeserializer.booleanDeserializer(), "complete");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<TermsEnumResponse> {
        private ShardStatistics shards;
        private List<String> terms;
        private Boolean complete;

        public final Builder shards(ShardStatistics value) {
            this.shards = value;
            return this;
        }

        public final Builder shards(Function<ShardStatistics.Builder, ObjectBuilder<ShardStatistics>> fn) {
            return this.shards(fn.apply(new ShardStatistics.Builder()).build());
        }

        public final Builder terms(List<String> list) {
            this.terms = Builder._listAddAll(this.terms, list);
            return this;
        }

        public final Builder terms(String value, String ... values) {
            this.terms = Builder._listAdd(this.terms, value, values);
            return this;
        }

        public final Builder complete(boolean value) {
            this.complete = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public TermsEnumResponse build() {
            this._checkSingleUse();
            return new TermsEnumResponse(this);
        }
    }
}

