/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.health_report;

import co.elastic.clients.elasticsearch.core.health_report.Diagnosis;
import co.elastic.clients.elasticsearch.core.health_report.Impact;
import co.elastic.clients.elasticsearch.core.health_report.IndicatorHealthStatus;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

public abstract class BaseIndicator
implements JsonpSerializable {
    private final IndicatorHealthStatus status;
    private final String symptom;
    private final List<Impact> impacts;
    private final List<Diagnosis> diagnosis;

    protected BaseIndicator(AbstractBuilder<?> builder) {
        this.status = ApiTypeHelper.requireNonNull(((AbstractBuilder)builder).status, this, "status");
        this.symptom = ApiTypeHelper.requireNonNull(((AbstractBuilder)builder).symptom, this, "symptom");
        this.impacts = ApiTypeHelper.unmodifiable(((AbstractBuilder)builder).impacts);
        this.diagnosis = ApiTypeHelper.unmodifiable(((AbstractBuilder)builder).diagnosis);
    }

    public final IndicatorHealthStatus status() {
        return this.status;
    }

    public final String symptom() {
        return this.symptom;
    }

    public final List<Impact> impacts() {
        return this.impacts;
    }

    public final List<Diagnosis> diagnosis() {
        return this.diagnosis;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("status");
        this.status.serialize(generator, mapper);
        generator.writeKey("symptom");
        generator.write(this.symptom);
        if (ApiTypeHelper.isDefined(this.impacts)) {
            generator.writeKey("impacts");
            generator.writeStartArray();
            for (Impact impact : this.impacts) {
                impact.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.diagnosis)) {
            generator.writeKey("diagnosis");
            generator.writeStartArray();
            for (Diagnosis diagnosis : this.diagnosis) {
                diagnosis.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupBaseIndicatorDeserializer(ObjectDeserializer<BuilderT> op) {
        op.add(AbstractBuilder::status, IndicatorHealthStatus._DESERIALIZER, "status");
        op.add(AbstractBuilder::symptom, JsonpDeserializer.stringDeserializer(), "symptom");
        op.add(AbstractBuilder::impacts, JsonpDeserializer.arrayDeserializer(Impact._DESERIALIZER), "impacts");
        op.add(AbstractBuilder::diagnosis, JsonpDeserializer.arrayDeserializer(Diagnosis._DESERIALIZER), "diagnosis");
    }

    public static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends WithJsonObjectBuilderBase<BuilderT> {
        private IndicatorHealthStatus status;
        private String symptom;
        @Nullable
        private List<Impact> impacts;
        @Nullable
        private List<Diagnosis> diagnosis;

        public final BuilderT status(IndicatorHealthStatus value) {
            this.status = value;
            return (BuilderT)this.self();
        }

        public final BuilderT symptom(String value) {
            this.symptom = value;
            return (BuilderT)this.self();
        }

        public final BuilderT impacts(List<Impact> list) {
            this.impacts = AbstractBuilder._listAddAll(this.impacts, list);
            return (BuilderT)this.self();
        }

        public final BuilderT impacts(Impact value, Impact ... values) {
            this.impacts = AbstractBuilder._listAdd(this.impacts, value, values);
            return (BuilderT)this.self();
        }

        public final BuilderT impacts(Function<Impact.Builder, ObjectBuilder<Impact>> fn) {
            return this.impacts(fn.apply(new Impact.Builder()).build(), new Impact[0]);
        }

        public final BuilderT diagnosis(List<Diagnosis> list) {
            this.diagnosis = AbstractBuilder._listAddAll(this.diagnosis, list);
            return (BuilderT)this.self();
        }

        public final BuilderT diagnosis(Diagnosis value, Diagnosis ... values) {
            this.diagnosis = AbstractBuilder._listAdd(this.diagnosis, value, values);
            return (BuilderT)this.self();
        }

        public final BuilderT diagnosis(Function<Diagnosis.Builder, ObjectBuilder<Diagnosis>> fn) {
            return this.diagnosis(fn.apply(new Diagnosis.Builder()).build(), new Diagnosis[0]);
        }

        @Override
        protected abstract BuilderT self();
    }
}

