/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.watcher;

import co.elastic.clients.elasticsearch.watcher.ActionStatus;
import co.elastic.clients.elasticsearch.watcher.ActivationState;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.DateTime;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class WatchStatus
implements JsonpSerializable {
    private final Map<String, ActionStatus> actions;
    @Nullable
    private final DateTime lastChecked;
    @Nullable
    private final DateTime lastMetCondition;
    private final ActivationState state;
    private final long version;
    @Nullable
    private final String executionState;
    public static final JsonpDeserializer<WatchStatus> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, WatchStatus::setupWatchStatusDeserializer);

    private WatchStatus(Builder builder) {
        this.actions = ApiTypeHelper.unmodifiableRequired(builder.actions, (Object)this, "actions");
        this.lastChecked = builder.lastChecked;
        this.lastMetCondition = builder.lastMetCondition;
        this.state = ApiTypeHelper.requireNonNull(builder.state, this, "state");
        this.version = ApiTypeHelper.requireNonNull(builder.version, this, "version");
        this.executionState = builder.executionState;
    }

    public static WatchStatus of(Function<Builder, ObjectBuilder<WatchStatus>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final Map<String, ActionStatus> actions() {
        return this.actions;
    }

    @Nullable
    public final DateTime lastChecked() {
        return this.lastChecked;
    }

    @Nullable
    public final DateTime lastMetCondition() {
        return this.lastMetCondition;
    }

    public final ActivationState state() {
        return this.state;
    }

    public final long version() {
        return this.version;
    }

    @Nullable
    public final String executionState() {
        return this.executionState;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.actions)) {
            generator.writeKey("actions");
            generator.writeStartObject();
            for (Map.Entry<String, ActionStatus> item0 : this.actions.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.lastChecked != null) {
            generator.writeKey("last_checked");
            this.lastChecked.serialize(generator, mapper);
        }
        if (this.lastMetCondition != null) {
            generator.writeKey("last_met_condition");
            this.lastMetCondition.serialize(generator, mapper);
        }
        generator.writeKey("state");
        this.state.serialize(generator, mapper);
        generator.writeKey("version");
        generator.write(this.version);
        if (this.executionState != null) {
            generator.writeKey("execution_state");
            generator.write(this.executionState);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupWatchStatusDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::actions, JsonpDeserializer.stringMapDeserializer(ActionStatus._DESERIALIZER), "actions");
        op.add(Builder::lastChecked, DateTime._DESERIALIZER, "last_checked");
        op.add(Builder::lastMetCondition, DateTime._DESERIALIZER, "last_met_condition");
        op.add(Builder::state, ActivationState._DESERIALIZER, "state");
        op.add(Builder::version, JsonpDeserializer.longDeserializer(), "version");
        op.add(Builder::executionState, JsonpDeserializer.stringDeserializer(), "execution_state");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<WatchStatus> {
        private Map<String, ActionStatus> actions;
        @Nullable
        private DateTime lastChecked;
        @Nullable
        private DateTime lastMetCondition;
        private ActivationState state;
        private Long version;
        @Nullable
        private String executionState;

        public final Builder actions(Map<String, ActionStatus> map) {
            this.actions = Builder._mapPutAll(this.actions, map);
            return this;
        }

        public final Builder actions(String key, ActionStatus value) {
            this.actions = Builder._mapPut(this.actions, key, value);
            return this;
        }

        public final Builder actions(String key, Function<ActionStatus.Builder, ObjectBuilder<ActionStatus>> fn) {
            return this.actions(key, fn.apply(new ActionStatus.Builder()).build());
        }

        public final Builder lastChecked(@Nullable DateTime value) {
            this.lastChecked = value;
            return this;
        }

        public final Builder lastMetCondition(@Nullable DateTime value) {
            this.lastMetCondition = value;
            return this;
        }

        public final Builder state(ActivationState value) {
            this.state = value;
            return this;
        }

        public final Builder state(Function<ActivationState.Builder, ObjectBuilder<ActivationState>> fn) {
            return this.state(fn.apply(new ActivationState.Builder()).build());
        }

        public final Builder version(long value) {
            this.version = value;
            return this;
        }

        public final Builder executionState(@Nullable String value) {
            this.executionState = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public WatchStatus build() {
            this._checkSingleUse();
            return new WatchStatus(this);
        }
    }
}

