/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.com.yahoo.sketches.quantiles;

import org.apache.pulsar.shade.com.yahoo.memory.Memory;
import org.apache.pulsar.shade.com.yahoo.sketches.SketchesArgumentException;
import org.apache.pulsar.shade.com.yahoo.sketches.quantiles.DoublesMergeImpl;
import org.apache.pulsar.shade.com.yahoo.sketches.quantiles.DoublesSketch;
import org.apache.pulsar.shade.com.yahoo.sketches.quantiles.DoublesUpdateImpl;
import org.apache.pulsar.shade.com.yahoo.sketches.quantiles.DoublesUtil;
import org.apache.pulsar.shade.com.yahoo.sketches.quantiles.PreambleUtil;
import org.apache.pulsar.shade.com.yahoo.sketches.quantiles.Util;

final class HeapDoublesSketch
extends DoublesSketch {
    double minValue_;
    double maxValue_;
    long n_;
    int baseBufferCount_;
    long bitPattern_;
    int combinedBufferItemCapacity_;
    double[] combinedBuffer_;

    private HeapDoublesSketch(int k) {
        super(k);
    }

    static HeapDoublesSketch newInstance(int k) {
        HeapDoublesSketch hqs = new HeapDoublesSketch(k);
        int bufAlloc = Math.min(4, 2 * k);
        hqs.n_ = 0L;
        hqs.combinedBufferItemCapacity_ = bufAlloc;
        hqs.combinedBuffer_ = new double[bufAlloc];
        hqs.baseBufferCount_ = 0;
        hqs.bitPattern_ = 0L;
        hqs.minValue_ = Double.POSITIVE_INFINITY;
        hqs.maxValue_ = Double.NEGATIVE_INFINITY;
        return hqs;
    }

    static HeapDoublesSketch heapifyInstance(Memory srcMem) {
        long memCapBytes = srcMem.getCapacity();
        if (memCapBytes < 8L) {
            throw new SketchesArgumentException("Source Memory too small: " + memCapBytes + " < 8");
        }
        long cumOffset = srcMem.getCumulativeOffset(0L);
        Object memArr = srcMem.array();
        int preLongs = PreambleUtil.extractPreLongs(memArr, cumOffset);
        int serVer = PreambleUtil.extractSerVer(memArr, cumOffset);
        int familyID = PreambleUtil.extractFamilyID(memArr, cumOffset);
        int flags = PreambleUtil.extractFlags(memArr, cumOffset);
        int k = PreambleUtil.extractK(memArr, cumOffset);
        DoublesUtil.checkDoublesSerVer(serVer);
        boolean empty = Util.checkPreLongsFlagsCap(preLongs, flags, memCapBytes);
        Util.checkFamilyID(familyID);
        HeapDoublesSketch hds = HeapDoublesSketch.newInstance(k);
        if (empty) {
            return hds;
        }
        boolean compact = serVer == 2 | (flags & 8) > 0;
        long n = PreambleUtil.extractN(memArr, cumOffset);
        DoublesUtil.checkMemCapacity(k, n, compact, memCapBytes);
        hds.n_ = n;
        hds.combinedBufferItemCapacity_ = Util.computeExpandedCombinedBufferItemCapacity(k, n);
        hds.baseBufferCount_ = Util.computeBaseBufferItems(k, n);
        hds.bitPattern_ = Util.computeBitPattern(k, n);
        hds.combinedBuffer_ = new double[hds.combinedBufferItemCapacity_];
        hds.srcMemoryToCombinedBuffer(compact, srcMem);
        return hds;
    }

    @Override
    public void update(double dataItem) {
        if (Double.isNaN(dataItem)) {
            return;
        }
        double maxValue = this.getMaxValue();
        double minValue = this.getMinValue();
        if (dataItem > maxValue) {
            this.putMaxValue(dataItem);
        }
        if (dataItem < minValue) {
            this.putMinValue(dataItem);
        }
        if (this.baseBufferCount_ + 1 > this.combinedBufferItemCapacity_) {
            DoublesUpdateImpl.growBaseBuffer(this);
        }
        this.combinedBuffer_[this.baseBufferCount_++] = dataItem;
        ++this.n_;
        if (this.baseBufferCount_ == 2 * this.k_) {
            DoublesUpdateImpl.processFullBaseBuffer(this);
        }
    }

    @Override
    public int getK() {
        return this.k_;
    }

    @Override
    public long getN() {
        return this.n_;
    }

    @Override
    public boolean isEmpty() {
        return this.n_ == 0L;
    }

    @Override
    public double getMinValue() {
        return this.minValue_;
    }

    @Override
    public double getMaxValue() {
        return this.maxValue_;
    }

    @Override
    public void reset() {
        this.n_ = 0L;
        this.combinedBufferItemCapacity_ = Math.min(4, 2 * this.k_);
        this.combinedBuffer_ = new double[this.combinedBufferItemCapacity_];
        this.baseBufferCount_ = 0;
        this.bitPattern_ = 0L;
        this.minValue_ = Double.POSITIVE_INFINITY;
        this.maxValue_ = Double.NEGATIVE_INFINITY;
    }

    private void srcMemoryToCombinedBuffer(boolean compact, Memory srcMem) {
        int preLongs = 2;
        int extra = 2;
        int preBytes = 32;
        long cumOffset = srcMem.getCumulativeOffset(0L);
        Object memArr = srcMem.array();
        int bbCnt = this.baseBufferCount_;
        int k = this.getK();
        long n = this.getN();
        double[] combinedBuffer = this.getCombinedBuffer();
        this.putMinValue(PreambleUtil.extractMinDouble(memArr, cumOffset));
        this.putMaxValue(PreambleUtil.extractMaxDouble(memArr, cumOffset));
        if (compact) {
            long bits;
            srcMem.getDoubleArray(32L, combinedBuffer, 0, bbCnt);
            if (bits != 0L) {
                long memOffset = 32 + (bbCnt << 3);
                int combBufOffset = 2 * k;
                for (bits = this.bitPattern_; bits != 0L; bits >>>= 1) {
                    if ((bits & 1L) > 0L) {
                        srcMem.getDoubleArray(memOffset, combinedBuffer, combBufOffset, k);
                        memOffset += (long)(k << 3);
                    }
                    combBufOffset += k;
                }
            }
        } else {
            int levels = Util.computeNumLevelsNeeded(k, n);
            int totItems = levels == 0 ? bbCnt : (2 + levels) * k;
            srcMem.getDoubleArray(32L, combinedBuffer, 0, totItems);
        }
    }

    @Override
    public DoublesSketch downSample(int smallerK) {
        HeapDoublesSketch oldSketch = this;
        HeapDoublesSketch newSketch = HeapDoublesSketch.newInstance(smallerK);
        DoublesMergeImpl.downSamplingMergeInto(oldSketch, newSketch);
        return newSketch;
    }

    @Override
    int getBaseBufferCount() {
        return this.baseBufferCount_;
    }

    @Override
    int getCombinedBufferItemCapacity() {
        return this.combinedBufferItemCapacity_;
    }

    @Override
    double[] getCombinedBuffer() {
        return this.combinedBuffer_;
    }

    @Override
    long getBitPattern() {
        return this.bitPattern_;
    }

    @Override
    void putCombinedBuffer(double[] combinedBuffer) {
        this.combinedBuffer_ = combinedBuffer;
    }

    @Override
    void putMinValue(double minValue) {
        this.minValue_ = minValue;
    }

    @Override
    void putMaxValue(double maxValue) {
        this.maxValue_ = maxValue;
    }

    @Override
    void putN(long n) {
        this.n_ = n;
    }

    @Override
    void putCombinedBufferItemCapacity(int combBufItemCap) {
        this.combinedBufferItemCapacity_ = combBufItemCap;
    }

    @Override
    void putBaseBufferCount(int baseBufferCount) {
        this.baseBufferCount_ = baseBufferCount;
    }

    @Override
    void putBitPattern(long bitPattern) {
        this.bitPattern_ = bitPattern;
    }

    @Override
    Memory getMemory() {
        return null;
    }
}

