/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import io.lettuce.core.RedisCredentials;
import io.lettuce.core.RedisCredentialsProvider;
import org.springframework.data.redis.connection.RedisConfiguration;
import org.springframework.data.redis.connection.RedisSentinelConfiguration;
import org.springframework.lang.Nullable;
import reactor.core.publisher.Mono;

public interface RedisCredentialsProviderFactory {
    @Nullable
    default public RedisCredentialsProvider createCredentialsProvider(RedisConfiguration redisConfiguration) {
        if (redisConfiguration instanceof RedisConfiguration.WithAuthentication && ((RedisConfiguration.WithAuthentication)((Object)redisConfiguration)).getPassword().isPresent()) {
            return RedisCredentialsProvider.from(() -> {
                RedisConfiguration.WithAuthentication withAuthentication = (RedisConfiguration.WithAuthentication)((Object)redisConfiguration);
                return RedisCredentials.just((String)withAuthentication.getUsername(), (char[])withAuthentication.getPassword().get());
            });
        }
        return () -> Mono.just((Object)((Object)AbsentRedisCredentials.ANONYMOUS));
    }

    default public RedisCredentialsProvider createSentinelCredentialsProvider(RedisSentinelConfiguration redisConfiguration) {
        if (redisConfiguration.getSentinelPassword().isPresent()) {
            return RedisCredentialsProvider.from(() -> RedisCredentials.just((String)redisConfiguration.getSentinelUsername(), (char[])redisConfiguration.getSentinelPassword().get()));
        }
        return () -> Mono.just((Object)((Object)AbsentRedisCredentials.ANONYMOUS));
    }

    public static enum AbsentRedisCredentials implements RedisCredentials
    {
        ANONYMOUS;


        @Nullable
        public String getUsername() {
            return null;
        }

        public boolean hasUsername() {
            return false;
        }

        @Nullable
        public char[] getPassword() {
            return null;
        }

        public boolean hasPassword() {
            return false;
        }
    }
}

