/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.config.jmx;

import com.netflix.config.jmx.BaseConfigMBean;
import com.netflix.config.jmx.ConfigMBean;
import java.lang.management.ManagementFactory;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.apache.commons.configuration.AbstractConfiguration;

public class ConfigJMXManager {
    public static ConfigMBean registerConfigMbean(AbstractConfiguration abstractConfiguration) {
        StandardMBean standardMBean = null;
        BaseConfigMBean baseConfigMBean = null;
        try {
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            baseConfigMBean = new BaseConfigMBean(abstractConfiguration);
            standardMBean = new StandardMBean(baseConfigMBean, ConfigMBean.class);
            mBeanServer.registerMBean(standardMBean, ConfigJMXManager.getJMXObjectName(abstractConfiguration, baseConfigMBean));
        }
        catch (NotCompliantMBeanException notCompliantMBeanException) {
            throw new RuntimeException("NotCompliantMBeanException", notCompliantMBeanException);
        }
        catch (InstanceAlreadyExistsException instanceAlreadyExistsException) {
            throw new RuntimeException("InstanceAlreadyExistsException", instanceAlreadyExistsException);
        }
        catch (MBeanRegistrationException mBeanRegistrationException) {
            throw new RuntimeException("MBeanRegistrationException", mBeanRegistrationException);
        }
        catch (Exception exception) {
            throw new RuntimeException("registerConfigMbeanException", exception);
        }
        return baseConfigMBean;
    }

    public static void unRegisterConfigMBean(AbstractConfiguration abstractConfiguration, ConfigMBean configMBean) {
        if (configMBean == null) {
            throw new RuntimeException("Cannot unregister JMX Mbean. The object is null");
        }
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        try {
            mBeanServer.unregisterMBean(ConfigJMXManager.getJMXObjectName(abstractConfiguration, configMBean));
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw new RuntimeException("InstanceNotFoundException", instanceNotFoundException);
        }
        catch (MBeanRegistrationException mBeanRegistrationException) {
            throw new RuntimeException("MBeanRegistrationException", mBeanRegistrationException);
        }
        catch (Exception exception) {
            throw new RuntimeException("unRegisterConfigMBeanException", exception);
        }
    }

    private static ObjectName getJMXObjectName(AbstractConfiguration abstractConfiguration, ConfigMBean configMBean) throws Exception {
        try {
            Class<?> clazz = configMBean.getClass();
            String string = clazz.getName();
            int n = string.lastIndexOf(46);
            ObjectName objectName = new ObjectName("Config-" + string.substring(0, n) + ":class=" + string.substring(n + 1));
            return objectName;
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            throw new RuntimeException("MalformedObjectNameException", malformedObjectNameException);
        }
        catch (NullPointerException nullPointerException) {
            throw new RuntimeException("NullPointerException", nullPointerException);
        }
    }
}

