/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.context.trace;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.skywalking.apm.agent.core.context.util.KeyValuePair;
import org.apache.skywalking.apm.network.language.agent.v3.Log;

public class LogDataEntity {
    private long timestamp;
    private List<KeyValuePair> logs;

    private LogDataEntity(long timestamp, List<KeyValuePair> logs) {
        this.timestamp = timestamp;
        this.logs = logs;
    }

    public List<KeyValuePair> getLogs() {
        return this.logs;
    }

    public Log transform() {
        Log.Builder logMessageBuilder = Log.newBuilder();
        for (KeyValuePair log : this.logs) {
            logMessageBuilder.addData(log.transform());
        }
        logMessageBuilder.setTime(this.timestamp);
        return logMessageBuilder.build();
    }

    public static class Builder {
        protected List<KeyValuePair> logs = new LinkedList<KeyValuePair>();

        public Builder add(KeyValuePair ... fields) {
            Collections.addAll(this.logs, fields);
            return this;
        }

        public LogDataEntity build(long timestamp) {
            return new LogDataEntity(timestamp, this.logs);
        }
    }
}

