/*
 * Decompiled with CFR 0.152.
 */
package spire.math.poly;

import algebra.ring.Ring;
import algebra.ring.Rng;
import algebra.ring.Semiring;
import cats.kernel.Eq;
import java.util.Arrays;
import scala.Function2;
import scala.reflect.ClassTag;
import scala.runtime.BoxesRunTime;
import spire.algebra.Field;
import spire.math.Polynomial;
import spire.math.Polynomial$;
import spire.math.Polynomial$mcD$sp;
import spire.math.package$;
import spire.math.poly.PolyDense;
import spire.math.poly.PolySparse;
import spire.math.poly.PolySparse$;
import spire.syntax.LiteralIntMultiplicativeSemigroupOps$;
import spire.syntax.package$field$;

public class PolySparse$mcD$sp
extends PolySparse<Object>
implements Polynomial$mcD$sp {
    public final double[] coeff$mcD$sp;

    @Override
    public double[] coeff$mcD$sp() {
        return this.coeff$mcD$sp;
    }

    public double[] coeff() {
        return this.coeff$mcD$sp();
    }

    @Override
    public PolyDense<Object> toDense(Semiring<Object> ring, Eq<Object> eq) {
        return this.toDense$mcD$sp(ring, eq);
    }

    @Override
    public PolyDense<Object> toDense$mcD$sp(Semiring<Object> ring, Eq<Object> eq) {
        return Polynomial$.MODULE$.dense$mDc$sp(this.coeffsArray$mcD$sp(ring), ring, eq, this.ct());
    }

    @Override
    public PolySparse<Object> toSparse(Semiring<Object> ring, Eq<Object> eq) {
        return this.toSparse$mcD$sp(ring, eq);
    }

    @Override
    public PolySparse<Object> toSparse$mcD$sp(Semiring<Object> ring, Eq<Object> eq) {
        return this;
    }

    @Override
    public <U> void foreach(Function2<Object, Object, U> f) {
        this.foreach$mcD$sp(f);
    }

    @Override
    public <U> void foreach$mcD$sp(Function2<Object, Object, U> f) {
        for (int index$macro$1 = 0; index$macro$1 < this.exp().length; ++index$macro$1) {
            f.apply((Object)BoxesRunTime.boxToInteger((int)this.exp()[index$macro$1]), (Object)BoxesRunTime.boxToDouble((double)this.coeff()[index$macro$1]));
        }
    }

    @Override
    public <U> void foreachNonZero(Function2<Object, Object, U> f, Semiring<Object> ring, Eq<Object> eq) {
        this.foreachNonZero$mcD$sp(f, ring, eq);
    }

    @Override
    public <U> void foreachNonZero$mcD$sp(Function2<Object, Object, U> f, Semiring<Object> ring, Eq<Object> eq) {
        this.foreach$mcD$sp(f);
    }

    public double[] coeffsArray(Semiring<Object> ring) {
        return this.coeffsArray$mcD$sp(ring);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public double[] coeffsArray$mcD$sp(Semiring<Object> ring) {
        double[] dArray;
        if (this.isZero()) {
            dArray = (double[])this.ct().newArray(0);
        } else {
            void var2_2;
            double[] cs = (double[])this.ct().newArray(this.degree() + 1);
            for (int index$macro$1 = 0; index$macro$1 < cs.length; ++index$macro$1) {
                cs[index$macro$1] = ring.zero$mcD$sp();
            }
            for (int index$macro$2 = 0; index$macro$2 < this.exp().length; ++index$macro$2) {
                cs[this.exp()[index$macro$2]] = this.coeff()[index$macro$2];
            }
            dArray = var2_2;
        }
        return dArray;
    }

    @Override
    public double nth(int n, Semiring<Object> ring) {
        return this.nth$mcD$sp(n, ring);
    }

    @Override
    public double nth$mcD$sp(int n, Semiring<Object> ring) {
        int i = Arrays.binarySearch(this.exp(), n);
        return i >= 0 ? this.coeff()[i] : ring.zero$mcD$sp();
    }

    @Override
    public double maxOrderTermCoeff(Semiring<Object> ring) {
        return this.maxOrderTermCoeff$mcD$sp(ring);
    }

    @Override
    public double maxOrderTermCoeff$mcD$sp(Semiring<Object> ring) {
        return this.isZero() ? ring.zero$mcD$sp() : this.coeff()[this.coeff().length - 1];
    }

    @Override
    public Polynomial<Object> reductum(Eq<Object> e, Semiring<Object> ring, ClassTag<Object> ct) {
        return this.reductum$mcD$sp(e, ring, ct);
    }

    @Override
    public Polynomial<Object> reductum$mcD$sp(Eq<Object> e, Semiring<Object> ring, ClassTag<Object> ct) {
        PolySparse$mcD$sp polySparse$mcD$sp;
        int i;
        for (i = this.coeff().length - 2; i >= 0 && e.eqv$mcD$sp(this.coeff()[i], ring.zero$mcD$sp()); --i) {
        }
        if (i < 0) {
            polySparse$mcD$sp = new PolySparse$mcD$sp(new int[0], (double[])ct.newArray(0), ct);
        } else {
            int len = i + 1;
            int[] es = new int[len];
            double[] cs = (double[])ct.newArray(len);
            System.arraycopy(this.coeff(), 0, cs, 0, len);
            System.arraycopy(this.exp(), 0, es, 0, len);
            polySparse$mcD$sp = new PolySparse$mcD$sp(es, cs, ct);
        }
        return polySparse$mcD$sp;
    }

    public final double[] expBits(double x, Semiring<Object> ring) {
        return this.expBits$mcD$sp(x, ring);
    }

    @Override
    public final double[] expBits$mcD$sp(double x, Semiring<Object> ring) {
        double[] bits = (double[])this.ct().newArray(package$.MODULE$.max(2, 32 - Integer.numberOfLeadingZeros(this.degree())));
        bits[0] = x;
        if (bits.length > 1) {
            bits[1] = ring.pow$mcD$sp(x, 2);
        }
        for (int index$macro$1 = 2; index$macro$1 < bits.length; ++index$macro$1) {
            double prev = bits[index$macro$1 - 1];
            bits[index$macro$1] = ring.times$mcD$sp(prev, prev);
        }
        return bits;
    }

    public final double fastExp(double[] bits, int e, int i, double acc, Semiring<Object> ring) {
        return this.fastExp$mcD$sp(bits, e, i, acc, ring);
    }

    @Override
    public final double fastExp$mcD$sp(double[] bits, int e, int i, double acc, Semiring<Object> ring) {
        while (e != 0) {
            int lb = Integer.numberOfTrailingZeros(e) + 1;
            int j = i + lb;
            double d = ring.times$mcD$sp(acc, bits[j - 1]);
            acc = d;
            i = j;
            e >>>= lb;
        }
        return acc;
    }

    public final double fastExp(double[] bits, int e, Semiring<Object> ring) {
        return this.fastExp$mcD$sp(bits, e, ring);
    }

    @Override
    public final double fastExp$mcD$sp(double[] bits, int e, Semiring<Object> ring) {
        int lb = Integer.numberOfTrailingZeros(e) + 1;
        return this.fastExp$mcD$sp(bits, e >>> lb, lb, bits[lb - 1], ring);
    }

    @Override
    public double apply(double x, Semiring<Object> ring) {
        return this.apply$mcD$sp(x, ring);
    }

    @Override
    public double apply$mcD$sp(double x, Semiring<Object> ring) {
        double d;
        if (this.isZero()) {
            d = ring.zero$mcD$sp();
        } else if (this.exp().length == 1) {
            d = this.exp()[0] != 0 ? ring.times$mcD$sp(this.coeff()[0], ring.pow$mcD$sp(x, this.exp()[0])) : this.coeff()[0];
        } else {
            double[] bits = this.expBits$mcD$sp(x, ring);
            int e0 = this.exp()[0];
            double c0 = this.coeff()[0];
            double sum = e0 == 0 ? c0 : ring.times$mcD$sp(c0, this.fastExp$mcD$sp(bits, e0, ring));
            for (int index$macro$1 = 1; index$macro$1 < this.exp().length; ++index$macro$1) {
                sum = ring.plus$mcD$sp(sum, ring.times$mcD$sp(this.coeff()[index$macro$1], this.fastExp$mcD$sp(bits, this.exp()[index$macro$1], ring)));
            }
            d = sum;
        }
        return d;
    }

    @Override
    public Polynomial<Object> derivative(Ring<Object> ring, Eq<Object> eq) {
        return this.derivative$mcD$sp(ring, eq);
    }

    @Override
    public Polynomial<Object> derivative$mcD$sp(Ring<Object> ring, Eq<Object> eq) {
        PolySparse polySparse;
        if (this.exp().length == 0) {
            polySparse = this;
        } else {
            int i0 = this.exp()[0] == 0 ? 1 : 0;
            int[] es = new int[this.exp().length - i0];
            double[] cs = (double[])this.ct().newArray(es.length);
            this.loop$9(i0, 0, es, cs, ring);
            polySparse = PolySparse$.MODULE$.safe$mDc$sp(es, cs, (Semiring<Object>)ring, eq, (ClassTag<Object>)this.ct());
        }
        return polySparse;
    }

    @Override
    public Polynomial<Object> integral(Field<Object> field, Eq<Object> eq) {
        return this.integral$mcD$sp(field, eq);
    }

    @Override
    public Polynomial<Object> integral$mcD$sp(Field<Object> field, Eq<Object> eq) {
        int[] es = new int[this.exp().length];
        double[] cs = (double[])this.ct().newArray(es.length);
        for (int index$macro$1 = 0; index$macro$1 < es.length; ++index$macro$1) {
            int e;
            es[index$macro$1] = e = this.exp()[index$macro$1] + 1;
            cs[index$macro$1] = field.div$mcD$sp(this.coeff()[index$macro$1], field.fromInt$mcD$sp(e));
        }
        return PolySparse$.MODULE$.safe$mDc$sp(es, cs, (Semiring<Object>)field, eq, (ClassTag<Object>)this.ct());
    }

    @Override
    public Polynomial<Object> unary_$minus(Rng<Object> ring) {
        return this.unary_$minus$mcD$sp(ring);
    }

    @Override
    public Polynomial<Object> unary_$minus$mcD$sp(Rng<Object> ring) {
        double[] cs = (double[])this.ct().newArray(this.coeff().length);
        for (int index$macro$1 = 0; index$macro$1 < cs.length; ++index$macro$1) {
            cs[index$macro$1] = ring.negate$mcD$sp(this.coeff()[index$macro$1]);
        }
        return new PolySparse$mcD$sp(this.exp(), cs, this.ct());
    }

    @Override
    public Polynomial<Object> $plus(Polynomial<Object> rhs0, Semiring<Object> ring, Eq<Object> eq) {
        return this.$plus$mcD$sp(rhs0, ring, eq);
    }

    @Override
    public Polynomial<Object> $plus$mcD$sp(Polynomial<Object> rhs0, Semiring<Object> ring, Eq<Object> eq) {
        PolySparse<Object> rhs = PolySparse$.MODULE$.apply$mDc$sp(rhs0, ring, eq, this.ct());
        return PolySparse$.MODULE$.spire$math$poly$PolySparse$$addSparse(this, rhs, eq, ring, this.ct());
    }

    @Override
    public Polynomial<Object> $times(Polynomial<Object> rhs0, Semiring<Object> ring, Eq<Object> eq) {
        return this.$times$mcD$sp(rhs0, ring, eq);
    }

    @Override
    public Polynomial<Object> $times$mcD$sp(Polynomial<Object> rhs0, Semiring<Object> ring, Eq<Object> eq) {
        PolySparse<Object> rhs = PolySparse$.MODULE$.apply$mDc$sp(rhs0, ring, eq, this.ct());
        return PolySparse$.MODULE$.spire$math$poly$PolySparse$$multiplySparse(this, rhs, ring, eq, this.ct());
    }

    @Override
    public Polynomial<Object> $times$colon(double k, Semiring<Object> ring, Eq<Object> eq) {
        return this.$times$colon$mcD$sp(k, ring, eq);
    }

    @Override
    public Polynomial<Object> $times$colon$mcD$sp(double k, Semiring<Object> ring, Eq<Object> eq) {
        PolySparse$mcD$sp polySparse$mcD$sp;
        if (eq.eqv$mcD$sp(k, ring.zero$mcD$sp())) {
            polySparse$mcD$sp = PolySparse$.MODULE$.zero$mDc$sp(ring, eq, this.ct());
        } else {
            double[] cs = (double[])this.ct().newArray(this.coeff().length);
            for (int index$macro$1 = 0; index$macro$1 < cs.length; ++index$macro$1) {
                cs[index$macro$1] = ring.times$mcD$sp(k, this.coeff()[index$macro$1]);
            }
            polySparse$mcD$sp = new PolySparse$mcD$sp(this.exp(), cs, this.ct());
        }
        return polySparse$mcD$sp;
    }

    public <C> double[] copy$default$2() {
        return this.copy$default$2$mcD$sp();
    }

    @Override
    public <C> double[] copy$default$2$mcD$sp() {
        return this.coeff();
    }

    @Override
    public boolean specInstance$() {
        return true;
    }

    private final void loop$9(int i, int j, int[] es$8, double[] cs$8, Ring ring$2) {
        while (j < es$8.length) {
            int e = this.exp()[i];
            es$8[j] = e - 1;
            cs$8[j] = BoxesRunTime.unboxToDouble((Object)LiteralIntMultiplicativeSemigroupOps$.MODULE$.$times$extension(package$field$.MODULE$.literalIntMultiplicativeSemigroupOps(e), BoxesRunTime.boxToDouble((double)this.coeff()[i]), ring$2));
            ++j;
            ++i;
        }
    }

    public PolySparse$mcD$sp(int[] exp, double[] coeff$mcD$sp, ClassTag<Object> ct) {
        this.coeff$mcD$sp = coeff$mcD$sp;
        super(exp, null, ct);
    }
}

