/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connector.catalog;

import java.io.Serializable;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.analysis.NoSuchDatabaseException;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.util.StringUtils$;
import org.apache.spark.sql.connector.catalog.CatalogExtension;
import org.apache.spark.sql.connector.catalog.CatalogManager$;
import org.apache.spark.sql.connector.catalog.CatalogNotFoundException;
import org.apache.spark.sql.connector.catalog.CatalogPlugin;
import org.apache.spark.sql.connector.catalog.CatalogV2Util$;
import org.apache.spark.sql.connector.catalog.Catalogs$;
import org.apache.spark.sql.connector.catalog.SupportsNamespaces;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.SeqOps;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u0005uc!B\u000f\u001f\u0001\tR\u0003\u0002C\u001f\u0001\u0005\u0003\u0005\u000b\u0011B \t\u0011\r\u0003!Q1A\u0005\u0002\u0011C\u0001B\u0013\u0001\u0003\u0002\u0003\u0006I!\u0012\u0005\u0006\u0017\u0002!\t\u0001\u0014\u0005\b!\u0002\u0011\r\u0011\"\u0003R\u0011\u0019)\u0007\u0001)A\u0005%\")q\u0004\u0001C\u0001M\")\u0011\u000e\u0001C\u0001U\")q\u000e\u0001C\u0005a\"1\u0011\u000f\u0001C\u0001EIDqa\u001d\u0001A\u0002\u0013%A\u000fC\u0004|\u0001\u0001\u0007I\u0011\u0002?\t\u000f\u0005\u0015\u0001\u0001)Q\u0005k\"9\u0011q\u0001\u0001\u0005\u0002\u0005%\u0001bBA\u0006\u0001\u0011%\u0011Q\u0002\u0005\b\u0003'\u0001A\u0011AA\u000b\u0011%\tI\u0002\u0001a\u0001\n\u0013\tY\u0002C\u0005\u0002 \u0001\u0001\r\u0011\"\u0003\u0002\"!A\u0011Q\u0005\u0001!B\u0013\ti\u0002\u0003\u0004\u0002(\u0001!\tA\u001d\u0005\b\u0003S\u0001A\u0011AA\u0016\u0011\u001d\t\t\u0004\u0001C\u0001\u0003gA\u0001\"a\u0013\u0001\t\u0003\u0011\u0013QJ\u0004\t\u0003\u001fr\u0002\u0012\u0001\u0012\u0002R\u00199QD\bE\u0001E\u0005M\u0003BB&\u001a\t\u0003\t)\u0006C\u0005\u0002Xe\u0011\r\u0011\"\u0001\u0002Z!9\u00111L\r!\u0002\u0013Q&AD\"bi\u0006dwnZ'b]\u0006<WM\u001d\u0006\u0003?\u0001\nqaY1uC2|wM\u0003\u0002\"E\u0005I1m\u001c8oK\u000e$xN\u001d\u0006\u0003G\u0011\n1a]9m\u0015\t)c%A\u0003ta\u0006\u00148N\u0003\u0002(Q\u00051\u0011\r]1dQ\u0016T\u0011!K\u0001\u0004_J<7\u0003\u0002\u0001,c]\u0002\"\u0001L\u0018\u000e\u00035R\u0011AL\u0001\u0006g\u000e\fG.Y\u0005\u0003a5\u0012a!\u00118z%\u00164\u0007C\u0001\u001a6\u001b\u0005\u0019$B\u0001\u001b#\u0003!\u0019\u0017\r^1msN$\u0018B\u0001\u001c4\u00055\u0019\u0016\u000bT\"p]\u001aDU\r\u001c9feB\u0011\u0001hO\u0007\u0002s)\u0011!\bJ\u0001\tS:$XM\u001d8bY&\u0011A(\u000f\u0002\b\u0019><w-\u001b8h\u0003U!WMZ1vYR\u001cVm]:j_:\u001c\u0015\r^1m_\u001e\u001c\u0001\u0001\u0005\u0002A\u00036\ta$\u0003\u0002C=\ti1)\u0019;bY><\u0007\u000b\\;hS:\f\u0001C^\u0019TKN\u001c\u0018n\u001c8DCR\fGn\\4\u0016\u0003\u0015\u0003\"A\u0012%\u000e\u0003\u001dS!aH\u001a\n\u0005%;%AD*fgNLwN\\\"bi\u0006dwnZ\u0001\u0012mF\u001aVm]:j_:\u001c\u0015\r^1m_\u001e\u0004\u0013A\u0002\u001fj]&$h\bF\u0002N\u001d>\u0003\"\u0001\u0011\u0001\t\u000bu\"\u0001\u0019A \t\u000b\r#\u0001\u0019A#\u0002\u0011\r\fG/\u00197pON,\u0012A\u0015\t\u0005'bSv(D\u0001U\u0015\t)f+A\u0004nkR\f'\r\\3\u000b\u0005]k\u0013AC2pY2,7\r^5p]&\u0011\u0011\f\u0016\u0002\b\u0011\u0006\u001c\b.T1q!\tY&M\u0004\u0002]AB\u0011Q,L\u0007\u0002=*\u0011qLP\u0001\u0007yI|w\u000e\u001e \n\u0005\u0005l\u0013A\u0002)sK\u0012,g-\u0003\u0002dI\n11\u000b\u001e:j]\u001eT!!Y\u0017\u0002\u0013\r\fG/\u00197pON\u0004CCA h\u0011\u0015Aw\u00011\u0001[\u0003\u0011q\u0017-\\3\u0002'%\u001c8)\u0019;bY><'+Z4jgR,'/\u001a3\u0015\u0005-t\u0007C\u0001\u0017m\u0013\tiWFA\u0004C_>dW-\u00198\t\u000b!D\u0001\u0019\u0001.\u0002)1|\u0017\r\u001a,3'\u0016\u001c8/[8o\u0007\u0006$\u0018\r\\8h)\u0005y\u0014\u0001\u0005<3'\u0016\u001c8/[8o\u0007\u0006$\u0018\r\\8h+\u0005y\u0014!E0dkJ\u0014XM\u001c;OC6,7\u000f]1dKV\tQ\u000fE\u0002-mbL!a^\u0017\u0003\r=\u0003H/[8o!\ra\u0013PW\u0005\u0003u6\u0012Q!\u0011:sCf\fQcX2veJ,g\u000e\u001e(b[\u0016\u001c\b/Y2f?\u0012*\u0017\u000fF\u0002~\u0003\u0003\u0001\"\u0001\f@\n\u0005}l#\u0001B+oSRD\u0001\"a\u0001\r\u0003\u0003\u0005\r!^\u0001\u0004q\u0012\n\u0014AE0dkJ\u0014XM\u001c;OC6,7\u000f]1dK\u0002\n\u0001cY;se\u0016tGOT1nKN\u0004\u0018mY3\u0016\u0003a\fA#Y:tKJ$h*Y7fgB\f7-Z#ySN$HcA?\u0002\u0010!1\u0011\u0011C\bA\u0002a\f\u0011B\\1nKN\u0004\u0018mY3\u0002'M,GoQ;se\u0016tGOT1nKN\u0004\u0018mY3\u0015\u0007u\f9\u0002\u0003\u0004\u0002\u0012A\u0001\r\u0001_\u0001\u0014?\u000e,(O]3oi\u000e\u000bG/\u00197pO:\u000bW.Z\u000b\u0003\u0003;\u00012\u0001\f<[\u0003]y6-\u001e:sK:$8)\u0019;bY><g*Y7f?\u0012*\u0017\u000fF\u0002~\u0003GA\u0011\"a\u0001\u0013\u0003\u0003\u0005\r!!\b\u0002)}\u001bWO\u001d:f]R\u001c\u0015\r^1m_\u001et\u0015-\\3!\u00039\u0019WO\u001d:f]R\u001c\u0015\r^1m_\u001e\f\u0011c]3u\u0007V\u0014(/\u001a8u\u0007\u0006$\u0018\r\\8h)\ri\u0018Q\u0006\u0005\u0007\u0003_)\u0002\u0019\u0001.\u0002\u0017\r\fG/\u00197pO:\u000bW.Z\u0001\rY&\u001cHoQ1uC2|wm\u001d\u000b\u0005\u0003k\t9\u0005E\u0003\u00028\u0005\u0005#L\u0004\u0003\u0002:\u0005ubbA/\u0002<%\ta&C\u0002\u0002@5\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002D\u0005\u0015#aA*fc*\u0019\u0011qH\u0017\t\u000f\u0005%c\u00031\u0001\u0002\u001e\u00059\u0001/\u0019;uKJt\u0017!\u0002:fg\u0016$H#A?\u0002\u001d\r\u000bG/\u00197pO6\u000bg.Y4feB\u0011\u0001)G\n\u00033-\"\"!!\u0015\u0002)M+5kU%P\u001d~\u001b\u0015\tV!M\u001f\u001e{f*Q'F+\u0005Q\u0016!F*F'NKuJT0D\u0003R\u000bEjT$`\u001d\u0006kU\t\t")
public class CatalogManager
implements SQLConfHelper,
Logging {
    private final CatalogPlugin defaultSessionCatalog;
    private final SessionCatalog v1SessionCatalog;
    private final HashMap<String, CatalogPlugin> catalogs;
    private Option<String[]> _currentNamespace;
    private Option<String> _currentCatalogName;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static String SESSION_CATALOG_NAME() {
        return CatalogManager$.MODULE$.SESSION_CATALOG_NAME();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    @Override
    public SQLConf conf() {
        return SQLConfHelper.conf$(this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public SessionCatalog v1SessionCatalog() {
        return this.v1SessionCatalog;
    }

    private HashMap<String, CatalogPlugin> catalogs() {
        return this.catalogs;
    }

    public synchronized CatalogPlugin catalog(String name) {
        return name.equalsIgnoreCase(CatalogManager$.MODULE$.SESSION_CATALOG_NAME()) ? this.v2SessionCatalog() : (CatalogPlugin)this.catalogs().getOrElseUpdate((Object)name, (Function0 & Serializable)() -> Catalogs$.MODULE$.load(name, this.conf()));
    }

    public boolean isCatalogRegistered(String name) {
        boolean bl;
        try {
            this.catalog(name);
            bl = true;
        }
        catch (CatalogNotFoundException catalogNotFoundException) {
            bl = false;
        }
        return bl;
    }

    private CatalogPlugin loadV2SessionCatalog() {
        CatalogPlugin catalogPlugin;
        CatalogPlugin catalogPlugin2 = Catalogs$.MODULE$.load(CatalogManager$.MODULE$.SESSION_CATALOG_NAME(), this.conf());
        if (catalogPlugin2 instanceof CatalogExtension) {
            CatalogExtension catalogExtension = (CatalogExtension)catalogPlugin2;
            catalogExtension.setDelegateCatalog(this.defaultSessionCatalog);
            catalogPlugin = catalogExtension;
        } else {
            catalogPlugin = catalogPlugin2;
        }
        return catalogPlugin;
    }

    public CatalogPlugin v2SessionCatalog() {
        return (CatalogPlugin)this.conf().getConf(SQLConf$.MODULE$.V2_SESSION_CATALOG_IMPLEMENTATION()).map((Function1 & Serializable)x$1 -> (CatalogPlugin)this.catalogs().getOrElseUpdate((Object)CatalogManager$.MODULE$.SESSION_CATALOG_NAME(), (Function0 & Serializable)() -> this.loadV2SessionCatalog())).getOrElse((Function0 & Serializable)() -> $this.defaultSessionCatalog);
    }

    private Option<String[]> _currentNamespace() {
        return this._currentNamespace;
    }

    private void _currentNamespace_$eq(Option<String[]> x$1) {
        this._currentNamespace = x$1;
    }

    public String[] currentNamespace() {
        String[] stringArray;
        String string = this.currentCatalog().name();
        String string2 = CatalogManager$.MODULE$.SESSION_CATALOG_NAME();
        String[] defaultNamespace = !(string != null ? !string.equals(string2) : string2 != null) ? (String[])((Object[])new String[]{this.v1SessionCatalog().getCurrentDatabase()}) : this.currentCatalog().defaultNamespace();
        CatalogManager catalogManager = this;
        synchronized (catalogManager) {
            stringArray = (String[])this._currentNamespace().getOrElse((Function0 & Serializable)() -> defaultNamespace);
        }
        return stringArray;
    }

    private void assertNamespaceExist(String[] namespace) {
        SupportsNamespaces supportsNamespaces;
        CatalogPlugin catalogPlugin = this.currentCatalog();
        if (catalogPlugin instanceof SupportsNamespaces && !(supportsNamespaces = (SupportsNamespaces)catalogPlugin).namespaceExists(namespace)) {
            String string = supportsNamespaces.name();
            throw QueryCompilationErrors$.MODULE$.noSuchNamespaceError((String[])ArrayOps$.MODULE$.$plus$colon$extension(Predef$.MODULE$.refArrayOps((Object[])namespace), (Object)string, ClassTag$.MODULE$.apply(String.class)));
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public synchronized void setCurrentNamespace(String[] namespace) {
        if (CatalogV2Util$.MODULE$.isSessionCatalog(this.currentCatalog()) && namespace.length == 1) {
            this.v1SessionCatalog().setCurrentDatabaseWithNameCheck((String)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])namespace)), (Function1<String, BoxedUnit>)(Function1 & Serializable)name -> {
                CatalogManager.$anonfun$setCurrentNamespace$1(this, namespace, name);
                return BoxedUnit.UNIT;
            });
        } else {
            this.assertNamespaceExist(namespace);
        }
        this._currentNamespace_$eq((Option<String[]>)new Some((Object)namespace));
    }

    private Option<String> _currentCatalogName() {
        return this._currentCatalogName;
    }

    private void _currentCatalogName_$eq(Option<String> x$1) {
        this._currentCatalogName = x$1;
    }

    public synchronized CatalogPlugin currentCatalog() {
        return this.catalog((String)this._currentCatalogName().getOrElse((Function0 & Serializable)() -> this.conf().getConf(SQLConf$.MODULE$.DEFAULT_CATALOG())));
    }

    public synchronized void setCurrentCatalog(String catalogName) {
        block0: {
            String string = this.currentCatalog().name();
            String string2 = catalogName;
            if (!(string == null ? string2 != null : !string.equals(string2))) break block0;
            this.catalog(catalogName);
            this._currentCatalogName_$eq((Option<String>)new Some((Object)catalogName));
            this._currentNamespace_$eq((Option<String[]>)None$.MODULE$);
            this.v1SessionCatalog().setCurrentDatabase(this.conf().defaultDatabase());
        }
    }

    public Seq<String> listCatalogs(Option<String> pattern) {
        Seq seq;
        CatalogManager catalogManager = this;
        synchronized (catalogManager) {
            seq = this.catalogs().keys().toSeq();
        }
        Seq allCatalogs = (Seq)((SeqOps)((SeqOps)seq.$colon$plus((Object)CatalogManager$.MODULE$.SESSION_CATALOG_NAME())).distinct()).sorted((Ordering)Ordering.String$.MODULE$);
        return (Seq)pattern.map((Function1 & Serializable)x$2 -> StringUtils$.MODULE$.filterPattern((Seq<String>)allCatalogs, (String)x$2)).getOrElse((Function0 & Serializable)() -> allCatalogs);
    }

    public synchronized void reset() {
        this.catalogs().clear();
        this._currentNamespace_$eq((Option<String[]>)None$.MODULE$);
        this._currentCatalogName_$eq((Option<String>)None$.MODULE$);
        this.v1SessionCatalog().setCurrentDatabase(this.conf().defaultDatabase());
    }

    public static final /* synthetic */ void $anonfun$setCurrentNamespace$1(CatalogManager $this, String[] namespace$1, String name) {
        SupportsNamespaces supportsNamespaces;
        CatalogPlugin catalogPlugin = $this.currentCatalog();
        if (catalogPlugin instanceof SupportsNamespaces && !(supportsNamespaces = (SupportsNamespaces)catalogPlugin).namespaceExists(namespace$1)) {
            throw new NoSuchDatabaseException(name);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public CatalogManager(CatalogPlugin defaultSessionCatalog, SessionCatalog v1SessionCatalog) {
        this.defaultSessionCatalog = defaultSessionCatalog;
        this.v1SessionCatalog = v1SessionCatalog;
        SQLConfHelper.$init$(this);
        Logging.$init$((Logging)this);
        this.catalogs = HashMap$.MODULE$.empty();
        this._currentNamespace = None$.MODULE$;
        this._currentCatalogName = None$.MODULE$;
    }
}

