/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.execution.datasources.FileStatusCache;
import org.apache.spark.sql.execution.datasources.SharedInMemoryCache$;
import org.apache.spark.util.SizeEstimator$;
import org.slf4j.Logger;
import org.sparkproject.guava.cache.Cache;
import org.sparkproject.guava.cache.CacheBuilder;
import org.sparkproject.guava.cache.RemovalCause;
import org.sparkproject.guava.cache.RemovalListener;
import org.sparkproject.guava.cache.RemovalNotification;
import org.sparkproject.guava.cache.Weigher;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.JavaConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

@ScalaSignature(bytes="\u0006\u000514AAC\u0006\u00051!AQ\u0005\u0001B\u0001B\u0003%a\u0005\u0003\u0005*\u0001\t\u0005\t\u0015!\u0003'\u0011\u0015Q\u0003\u0001\"\u0001,\u000b\u0011\u0001\u0004\u0001B\u0019\t\u000fe\u0002!\u0019!C\u0005u!1Q\t\u0001Q\u0001\nmBqA\u0012\u0001C\u0002\u0013%q\t\u0003\u0004g\u0001\u0001\u0006I\u0001\u0013\u0005\u0006O\u0002!\t\u0001\u001b\u0002\u0014'\"\f'/\u001a3J]6+Wn\u001c:z\u0007\u0006\u001c\u0007.\u001a\u0006\u0003\u00195\t1\u0002Z1uCN|WO]2fg*\u0011abD\u0001\nKb,7-\u001e;j_:T!\u0001E\t\u0002\u0007M\fHN\u0003\u0002\u0013'\u0005)1\u000f]1sW*\u0011A#F\u0001\u0007CB\f7\r[3\u000b\u0003Y\t1a\u001c:h\u0007\u0001\u00192\u0001A\r !\tQR$D\u0001\u001c\u0015\u0005a\u0012!B:dC2\f\u0017B\u0001\u0010\u001c\u0005\u0019\te.\u001f*fMB\u0011\u0001eI\u0007\u0002C)\u0011!%E\u0001\tS:$XM\u001d8bY&\u0011A%\t\u0002\b\u0019><w-\u001b8h\u00039i\u0017\r_*ju\u0016LeNQ=uKN\u0004\"AG\u0014\n\u0005!Z\"\u0001\u0002'p]\u001e\f\u0001bY1dQ\u0016$F\u000bT\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00071rs\u0006\u0005\u0002.\u00015\t1\u0002C\u0003&\u0007\u0001\u0007a\u0005C\u0003*\u0007\u0001\u0007aE\u0001\u0005DY&,g\u000e^%e!\t\u0011t'D\u00014\u0015\t!T'\u0001\u0003mC:<'\"\u0001\u001c\u0002\t)\fg/Y\u0005\u0003qM\u0012aa\u00142kK\u000e$\u0018aE<be:,G-\u00112pkR,e/[2uS>tW#A\u001e\u0011\u0005q\u001aU\"A\u001f\u000b\u0005yz\u0014AB1u_6L7M\u0003\u0002A\u0003\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005\t+\u0014\u0001B;uS2L!\u0001R\u001f\u0003\u001b\u0005#x.\\5d\u0005>|G.Z1o\u0003Q9\u0018M\u001d8fI\u0006\u0013w.\u001e;Fm&\u001cG/[8oA\u0005)1-Y2iKV\t\u0001\n\u0005\u0003J#N\u0003W\"\u0001&\u000b\u0005\u0019[%B\u0001'N\u0003\u0019\u0019w.\\7p]*\u0011ajT\u0001\u0007O>|w\r\\3\u000b\u0003A\u000b1aY8n\u0013\t\u0011&JA\u0003DC\u000eDW\r\u0005\u0003\u001b)ZC\u0016BA+\u001c\u0005\u0019!V\u000f\u001d7feA\u0011q\u000bB\u0007\u0002\u0001A\u0011\u0011LX\u0007\u00025*\u00111\fX\u0001\u0003MNT!!X\n\u0002\r!\fGm\\8q\u0013\ty&L\u0001\u0003QCRD\u0007c\u0001\u000ebG&\u0011!m\u0007\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u00033\u0012L!!\u001a.\u0003\u0015\u0019KG.Z*uCR,8/\u0001\u0004dC\u000eDW\rI\u0001\u0013GJ,\u0017\r^3G_JtUm^\"mS\u0016tG\u000fF\u0001j!\ti#.\u0003\u0002l\u0017\tya)\u001b7f'R\fG/^:DC\u000eDW\r")
public class SharedInMemoryCache
implements Logging {
    public final long org$apache$spark$sql$execution$datasources$SharedInMemoryCache$$maxSizeInBytes;
    private final AtomicBoolean org$apache$spark$sql$execution$datasources$SharedInMemoryCache$$warnedAboutEviction;
    private final Cache<Tuple2<Object, Path>, FileStatus[]> org$apache$spark$sql$execution$datasources$SharedInMemoryCache$$cache;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public AtomicBoolean org$apache$spark$sql$execution$datasources$SharedInMemoryCache$$warnedAboutEviction() {
        return this.org$apache$spark$sql$execution$datasources$SharedInMemoryCache$$warnedAboutEviction;
    }

    public Cache<Tuple2<Object, Path>, FileStatus[]> org$apache$spark$sql$execution$datasources$SharedInMemoryCache$$cache() {
        return this.org$apache$spark$sql$execution$datasources$SharedInMemoryCache$$cache;
    }

    public FileStatusCache createForNewClient() {
        return new FileStatusCache(this){
            private final Object clientId;
            private final /* synthetic */ SharedInMemoryCache $outer;

            private Object clientId() {
                return this.clientId;
            }

            public Option<FileStatus[]> getLeafFiles(Path path) {
                return Option$.MODULE$.apply(this.$outer.org$apache$spark$sql$execution$datasources$SharedInMemoryCache$$cache().getIfPresent((Object)new Tuple2(this.clientId(), (Object)path)));
            }

            public void putLeafFiles(Path path, FileStatus[] leafFiles) {
                this.$outer.org$apache$spark$sql$execution$datasources$SharedInMemoryCache$$cache().put((Object)new Tuple2(this.clientId(), (Object)path), (Object)leafFiles);
            }

            public void invalidateAll() {
                ((IterableOnceOps)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.$outer.org$apache$spark$sql$execution$datasources$SharedInMemoryCache$$cache().asMap()).asScala()).foreach((Function1 & Serializable)x0$1 -> {
                    $anon$3.$anonfun$invalidateAll$1(this, x0$1);
                    return BoxedUnit.UNIT;
                });
            }

            public static final /* synthetic */ void $anonfun$invalidateAll$1($anon$3 $this, Tuple2 x0$1) {
                BoxedUnit boxedUnit;
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    Tuple2 key = (Tuple2)tuple2._1();
                    if (BoxesRunTime.equals((Object)key._1(), (Object)$this.clientId())) {
                        $this.$outer.org$apache$spark$sql$execution$datasources$SharedInMemoryCache$$cache().invalidate((Object)key);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                } else {
                    throw new MatchError((Object)tuple2);
                }
                BoxedUnit boxedUnit2 = boxedUnit;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.clientId = new Object();
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$invalidateAll$1$adapted(org.apache.spark.sql.execution.datasources.SharedInMemoryCache$$anon$3 scala.Tuple2 )}, serializedLambda);
            }
        };
    }

    public SharedInMemoryCache(long maxSizeInBytes, long cacheTTL) {
        this.org$apache$spark$sql$execution$datasources$SharedInMemoryCache$$maxSizeInBytes = maxSizeInBytes;
        Logging.$init$((Logging)this);
        this.org$apache$spark$sql$execution$datasources$SharedInMemoryCache$$warnedAboutEviction = new AtomicBoolean(false);
        int weightScale = 32;
        Weigher<Tuple2<Object, Path>, FileStatus[]> weigher = new Weigher<Tuple2<Object, Path>, FileStatus[]>(this, weightScale){
            private final /* synthetic */ SharedInMemoryCache $outer;
            private final int weightScale$1;

            public int weigh(Tuple2<Object, Path> key, FileStatus[] value) {
                int n;
                long estimate = (SizeEstimator$.MODULE$.estimate(key) + SizeEstimator$.MODULE$.estimate((Object)value)) / (long)this.weightScale$1;
                if (estimate > Integer.MAX_VALUE) {
                    this.$outer.logWarning((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append("Cached table partition metadata size is too big. Approximating to ").append(new StringBuilder(1).append((long)Integer.MAX_VALUE * (long)$this.weightScale$1).append(".").toString()).toString());
                    n = Integer.MAX_VALUE;
                } else {
                    n = (int)estimate;
                }
                return n;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.weightScale$1 = weightScale$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$weigh$1(org.apache.spark.sql.execution.datasources.SharedInMemoryCache$$anon$1 )}, serializedLambda);
            }
        };
        RemovalListener<Tuple2<Object, Path>, FileStatus[]> removalListener = new RemovalListener<Tuple2<Object, Path>, FileStatus[]>(this){
            private final /* synthetic */ SharedInMemoryCache $outer;

            public void onRemoval(RemovalNotification<Tuple2<Object, Path>, FileStatus[]> removed) {
                block0: {
                    RemovalCause removalCause = removed.getCause();
                    RemovalCause removalCause2 = RemovalCause.SIZE;
                    if ((removalCause != null ? !removalCause.equals(removalCause2) : removalCause2 != null) || !this.$outer.org$apache$spark$sql$execution$datasources$SharedInMemoryCache$$warnedAboutEviction().compareAndSet(false, true)) break block0;
                    this.$outer.logWarning((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(180).append("Evicting cached table partition metadata from memory due to size constraints (spark.sql.hive.filesourcePartitionFileCacheSize = ").append($this.$outer.org$apache$spark$sql$execution$datasources$SharedInMemoryCache$$maxSizeInBytes).append(" bytes). This may impact query planning performance.").toString());
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onRemoval$1(org.apache.spark.sql.execution.datasources.SharedInMemoryCache$$anon$2 )}, serializedLambda);
            }
        };
        CacheBuilder builder = CacheBuilder.newBuilder().weigher((Weigher)weigher).removalListener((RemovalListener)removalListener).maximumWeight(maxSizeInBytes / (long)weightScale);
        if (cacheTTL > 0L) {
            builder = builder.expireAfterWrite(cacheTTL, TimeUnit.SECONDS);
        }
        this.org$apache$spark$sql$execution$datasources$SharedInMemoryCache$$cache = builder.build();
    }
}

