/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.wrappers;

import java.io.ObjectStreamException;
import java.sql.Date;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.state.FetchPlanState;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.types.SCO;

public class SqlDate
extends Date
implements SCO<Date> {
    protected transient ObjectProvider ownerOP;
    protected transient AbstractMemberMetaData ownerMmd;

    public SqlDate(ObjectProvider op, AbstractMemberMetaData mmd) {
        super(0L);
        this.ownerOP = op;
        this.ownerMmd = mmd;
    }

    @Override
    public void initialise() {
    }

    @Override
    public void initialise(Date newValue, Object oldValue) {
        this.initialise(newValue);
    }

    @Override
    public void initialise(Date d) {
        super.setTime(d.getTime());
    }

    @Override
    public Date getValue() {
        return new Date(this.getTime());
    }

    @Override
    public void unsetOwner() {
        this.ownerOP = null;
        this.ownerMmd = null;
    }

    @Override
    public Object getOwner() {
        return this.ownerOP != null ? this.ownerOP.getObject() : null;
    }

    @Override
    public String getFieldName() {
        return this.ownerMmd.getName();
    }

    public void makeDirty() {
        if (this.ownerOP != null) {
            this.ownerOP.makeDirty(this.ownerMmd.getAbsoluteFieldNumber());
            if (!this.ownerOP.getExecutionContext().getTransaction().isActive()) {
                this.ownerOP.getExecutionContext().processNontransactionalUpdate();
            }
        }
    }

    @Override
    public Date detachCopy(FetchPlanState state) {
        return new Date(this.getTime());
    }

    @Override
    public void attachCopy(Date value) {
        long oldValue = this.getTime();
        this.initialise(value);
        long newValue = value.getTime();
        if (oldValue != newValue) {
            this.makeDirty();
        }
    }

    @Override
    public Object clone() {
        Object obj = super.clone();
        ((SqlDate)obj).unsetOwner();
        return obj;
    }

    @Override
    public void setTime(long time) {
        super.setTime(time);
        this.makeDirty();
    }

    @Override
    public void setYear(int year) {
        super.setYear(year);
        this.makeDirty();
    }

    @Override
    public void setMonth(int month) {
        super.setMonth(month);
        this.makeDirty();
    }

    @Override
    public void setDate(int date) {
        super.setDate(date);
        this.makeDirty();
    }

    protected Object writeReplace() throws ObjectStreamException {
        return new Date(this.getTime());
    }
}

