/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ConfigMapNodeConfigSource;
import io.fabric8.kubernetes.api.model.ConfigMapNodeConfigSourceBuilder;
import io.fabric8.kubernetes.api.model.ConfigMapNodeConfigSourceFluent;
import io.fabric8.kubernetes.api.model.NodeConfigSource;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class NodeConfigSourceFluent<A extends NodeConfigSourceFluent<A>>
extends BaseFluent<A> {
    private ConfigMapNodeConfigSourceBuilder configMap;
    private Map<String, Object> additionalProperties;

    public NodeConfigSourceFluent() {
    }

    public NodeConfigSourceFluent(NodeConfigSource instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(NodeConfigSource instance) {
        NodeConfigSource nodeConfigSource = instance = instance != null ? instance : new NodeConfigSource();
        if (instance != null) {
            this.withConfigMap(instance.getConfigMap());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public ConfigMapNodeConfigSource buildConfigMap() {
        return this.configMap != null ? this.configMap.build() : null;
    }

    public A withConfigMap(ConfigMapNodeConfigSource configMap) {
        this._visitables.remove((Object)"configMap");
        if (configMap != null) {
            this.configMap = new ConfigMapNodeConfigSourceBuilder(configMap);
            this._visitables.get((Object)"configMap").add(this.configMap);
        } else {
            this.configMap = null;
            this._visitables.get((Object)"configMap").remove((Object)this.configMap);
        }
        return (A)((Object)this);
    }

    public boolean hasConfigMap() {
        return this.configMap != null;
    }

    public A withNewConfigMap(String kubeletConfigKey, String name, String namespace, String resourceVersion, String uid) {
        return this.withConfigMap(new ConfigMapNodeConfigSource(kubeletConfigKey, name, namespace, resourceVersion, uid));
    }

    public ConfigMapNested<A> withNewConfigMap() {
        return new ConfigMapNested(null);
    }

    public ConfigMapNested<A> withNewConfigMapLike(ConfigMapNodeConfigSource item) {
        return new ConfigMapNested(item);
    }

    public ConfigMapNested<A> editConfigMap() {
        return this.withNewConfigMapLike(Optional.ofNullable(this.buildConfigMap()).orElse(null));
    }

    public ConfigMapNested<A> editOrNewConfigMap() {
        return this.withNewConfigMapLike(Optional.ofNullable(this.buildConfigMap()).orElse(new ConfigMapNodeConfigSourceBuilder().build()));
    }

    public ConfigMapNested<A> editOrNewConfigMapLike(ConfigMapNodeConfigSource item) {
        return this.withNewConfigMapLike(Optional.ofNullable(this.buildConfigMap()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NodeConfigSourceFluent that = (NodeConfigSourceFluent)((Object)o);
        if (!Objects.equals((Object)this.configMap, (Object)that.configMap)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.configMap, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.configMap != null) {
            sb.append("configMap:");
            sb.append(String.valueOf((Object)this.configMap) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ConfigMapNested<N>
    extends ConfigMapNodeConfigSourceFluent<ConfigMapNested<N>>
    implements Nested<N> {
        ConfigMapNodeConfigSourceBuilder builder;

        ConfigMapNested(ConfigMapNodeConfigSource item) {
            this.builder = new ConfigMapNodeConfigSourceBuilder(this, item);
        }

        public N and() {
            return (N)NodeConfigSourceFluent.this.withConfigMap(this.builder.build());
        }

        public N endConfigMap() {
            return this.and();
        }
    }
}

