/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.util;

import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.Set;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.network.util.JavaUtils;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.StringContext;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005\rg\u0001\u0003\u0011\"!\u0003\r\taI\u0015\t\u000bY\u0002A\u0011\u0001\u001d\t\u000bq\u0002A\u0011A\u001f\t\u000bM\u0003A\u0011\u0001+\t\u000b\u0001\u0004A\u0011A1\t\u000b\u0019\u0004A\u0011A4\t\u000b9\u0004A\u0011A8\t\u000bi\u0004A\u0011A>\t\ri\u0004A\u0011AA\u0002\u0011%\ti\u0001AI\u0001\n\u0003\ty\u0001C\u0004\u0002&\u0001!\t!a\n\t\u000f\u0005\u0015\u0002\u0001\"\u0001\u0002*!I\u0011q\u0006\u0001\u0012\u0002\u0013\u0005\u0011q\u0002\u0005\n\u0003c\u0001\u0011\u0013!C\u0001\u0003\u001fAq!a\r\u0001\t\u0003\t)\u0004C\u0004\u0002:\u0001!\t!a\u000f\t\u000f\u0005}\u0002\u0001\"\u0001\u0002B!9\u0011Q\t\u0001\u0005\u0002\u0005\u001d\u0003bBA&\u0001\u0011\u0005\u0011Q\n\u0005\b\u0003#\u0002A\u0011AA*\u0011\u001d\t\t\u0006\u0001C\u0001\u0003?Bq!a\u001a\u0001\t\u0003\tI\u0007C\u0004\u0002t\u0001!\t!!\u001e\t\u000f\u0005m\u0004\u0001\"\u0001\u0002~!9\u00111\u0011\u0001\u0005\u0002\u0005\u0015\u0005bBAF\u0001\u0011\u0005\u0011Q\u0012\u0005\b\u0003'\u0003A\u0011AAK\u0011\u001d\t\u0019\u000b\u0001C\u0001\u0003KCq!a,\u0001\t\u0003\t\tl\u0002\u0005\u00026\u0006B\taIA\\\r\u001d\u0001\u0013\u0005#\u0001$\u0003wCq!a0\u001f\t\u0003\t\tM\u0001\bTa\u0006\u00148NR5mKV#\u0018\u000e\\:\u000b\u0005\t\u001a\u0013\u0001B;uS2T!\u0001J\u0013\u0002\u000bM\u0004\u0018M]6\u000b\u0005\u0019:\u0013AB1qC\u000eDWMC\u0001)\u0003\ry'oZ\n\u0004\u0001)\u0002\u0004CA\u0016/\u001b\u0005a#\"A\u0017\u0002\u000bM\u001c\u0017\r\\1\n\u0005=b#AB!osJ+g\r\u0005\u00022i5\t!G\u0003\u00024G\u0005A\u0011N\u001c;fe:\fG.\u0003\u00026e\t9Aj\\4hS:<\u0017A\u0002\u0013j]&$He\u0001\u0001\u0015\u0003e\u0002\"a\u000b\u001e\n\u0005mb#\u0001B+oSR\f!B]3t_24X-\u0016*J)\tqd\t\u0005\u0002@\t6\t\u0001I\u0003\u0002B\u0005\u0006\u0019a.\u001a;\u000b\u0003\r\u000bAA[1wC&\u0011Q\t\u0011\u0002\u0004+JK\u0005\"B$\u0003\u0001\u0004A\u0015\u0001\u00029bi\"\u0004\"!\u0013)\u000f\u0005)s\u0005CA&-\u001b\u0005a%BA'8\u0003\u0019a$o\\8u}%\u0011q\nL\u0001\u0007!J,G-\u001a4\n\u0005E\u0013&AB*ue&twM\u0003\u0002PY\u000511/\u001b>f\u001f\u001a$\"!\u0016-\u0011\u0005-2\u0016BA,-\u0005\u0011auN\\4\t\u000be\u001b\u0001\u0019\u0001.\u0002\u0003\u0019\u0004\"a\u00170\u000e\u0003qS!!\u0018\"\u0002\u0005%|\u0017BA0]\u0005\u00111\u0015\u000e\\3\u0002\u001bI,7-\u001e:tSZ,G*[:u)\t\u0011W\rE\u0002,GjK!\u0001\u001a\u0017\u0003\u000b\u0005\u0013(/Y=\t\u000be#\u0001\u0019\u0001.\u0002\u00131L7\u000f\u001e$jY\u0016\u001cHC\u00015n!\rI7NW\u0007\u0002U*\u0011!EQ\u0005\u0003Y*\u00141aU3u\u0011\u0015IV\u00011\u0001[\u0003%a\u0017n\u001d;QCRD7\u000f\u0006\u0002qsB\u0019\u0011n[9\u0011\u0005I<X\"A:\u000b\u0005Q,\u0018\u0001\u00024jY\u0016T!A\u001e\"\u0002\u00079Lw.\u0003\u0002yg\n!\u0001+\u0019;i\u0011\u0015If\u00011\u0001[\u0003=\u0019'/Z1uK\u0012K'/Z2u_JLHC\u0001?\u0000!\tYS0\u0003\u0002\u007fY\t9!i\\8mK\u0006t\u0007BBA\u0001\u000f\u0001\u0007!,A\u0002eSJ$RAWA\u0003\u0003\u0013Aa!a\u0002\t\u0001\u0004A\u0015\u0001\u0002:p_RD\u0001\"a\u0003\t!\u0003\u0005\r\u0001S\u0001\u000b]\u0006lW\r\u0015:fM&D\u0018!G2sK\u0006$X\rR5sK\u000e$xN]=%I\u00164\u0017-\u001e7uII*\"!!\u0005+\u0007!\u000b\u0019b\u000b\u0002\u0002\u0016A!\u0011qCA\u0011\u001b\t\tIB\u0003\u0003\u0002\u001c\u0005u\u0011!C;oG\",7m[3e\u0015\r\ty\u0002L\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\u0012\u00033\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00035\u0019'/Z1uKR+W\u000e\u001d#jeR\t!\fF\u0003[\u0003W\ti\u0003\u0003\u0005\u0002\b-\u0001\n\u00111\u0001I\u0011!\tYa\u0003I\u0001\u0002\u0004A\u0015aF2sK\u0006$X\rV3na\u0012K'\u000f\n3fM\u0006,H\u000e\u001e\u00132\u0003]\u0019'/Z1uKR+W\u000e\u001d#je\u0012\"WMZ1vYR$#'\u0001\tde\u0016\fG/\u001a)be\u0016tG\u000fR5sgR\u0019\u0011(a\u000e\t\u000bQt\u0001\u0019\u0001.\u0002\u001d\rdW-\u00198ESJ,7\r^8ssR\u0019\u0011(!\u0010\t\r\u0005\u0005q\u00021\u0001[\u0003E!W\r\\3uKJ+7-\u001e:tSZ,G.\u001f\u000b\u0004s\u0005\r\u0003\"\u0002;\u0011\u0001\u0004Q\u0016!\u00043fY\u0016$X-U;jKRd\u0017\u0010F\u0002:\u0003\u0013BQ\u0001^\tA\u0002i\u000b\u0011CZ8sG\u0016$U\r\\3uK>sW\t_5u)\rI\u0014q\n\u0005\u0006iJ\u0001\rAW\u0001\bO\u0016$h)\u001b7f)\rQ\u0016Q\u000b\u0005\b\u0003/\u001a\u0002\u0019AA-\u0003\u0015q\u0017-\\3t!\u0011Y\u00131\f%\n\u0007\u0005uCF\u0001\u0006=e\u0016\u0004X-\u0019;fIz\"RAWA1\u0003KBa!a\u0019\u0015\u0001\u0004Q\u0016A\u00029be\u0016tG\u000fC\u0004\u0002XQ\u0001\r!!\u0017\u0002\u00115|g/\u001a$jY\u0016$R!OA6\u0003_Ba!!\u001c\u0016\u0001\u0004Q\u0016aA:sG\"1\u0011\u0011O\u000bA\u0002i\u000b1\u0001Z:u\u00035iwN^3ESJ,7\r^8ssR)\u0011(a\u001e\u0002z!1\u0011Q\u000e\fA\u0002iCa!!\u001d\u0017\u0001\u0004Q\u0016!D2paf$\u0015N]3di>\u0014\u0018\u0010F\u0003:\u0003\u007f\n\t\t\u0003\u0004\u0002n]\u0001\rA\u0017\u0005\u0007\u0003\u00039\u0002\u0019\u0001.\u0002'\r|\u0007/\u001f$jY\u0016$v\u000eR5sK\u000e$xN]=\u0015\u000be\n9)!#\t\u000bQD\u0002\u0019\u0001.\t\r\u0005\u0005\u0001\u00041\u0001[\u0003!\u0019w\u000e]=GS2,G#B\u001d\u0002\u0010\u0006E\u0005BBA73\u0001\u0007!\f\u0003\u0004\u0002re\u0001\rAW\u0001\u000eG>\u0004\u00180\u0016*M)>4\u0015\u000e\\3\u0015\u000be\n9*!)\t\u000f\u0005e%\u00041\u0001\u0002\u001c\u0006\u0019QO\u001d7\u0011\u0007}\ni*C\u0002\u0002 \u0002\u00131!\u0016*M\u0011\u0015!(\u00041\u0001[\u00035\u0019wN\u001c;f]R,\u0015/^1mgR)A0a*\u0002,\"1\u0011\u0011V\u000eA\u0002i\u000bQAZ5mKFBa!!,\u001c\u0001\u0004Q\u0016!\u00024jY\u0016\u0014\u0014!\u0002;pk\u000eDGcA\u001d\u00024\")A\u000f\ba\u00015\u0006q1\u000b]1sW\u001aKG.Z+uS2\u001c\bcAA]=5\t\u0011e\u0005\u0003\u001fU\u0005u\u0006cAA]\u0001\u00051A(\u001b8jiz\"\"!a.")
public interface SparkFileUtils
extends Logging {
    public static /* synthetic */ URI resolveURI$(SparkFileUtils $this, String path) {
        return $this.resolveURI(path);
    }

    default public URI resolveURI(String path) {
        try {
            URI uri = new URI(path);
            if (uri.getScheme() != null) {
                return uri;
            }
            if (uri.getFragment() != null) {
                URI absoluteURI = new File(uri.getPath()).getAbsoluteFile().toURI();
                return new URI(absoluteURI.getScheme(), absoluteURI.getHost(), absoluteURI.getPath(), uri.getFragment());
            }
        }
        catch (URISyntaxException e) {
            // empty catch block
        }
        return new File(path).getCanonicalFile().toURI();
    }

    public static /* synthetic */ long sizeOf$(SparkFileUtils $this, File f) {
        return $this.sizeOf(f);
    }

    default public long sizeOf(File f) {
        return JavaUtils.sizeOf((File)f);
    }

    public static /* synthetic */ File[] recursiveList$(SparkFileUtils $this, File f) {
        return $this.recursiveList(f);
    }

    default public File[] recursiveList(File f) {
        Predef$.MODULE$.require(f.isDirectory());
        Buffer result = Predef$.MODULE$.wrapRefArray((Object[])f.listFiles()).toBuffer();
        Buffer dirList = (Buffer)result.filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.isDirectory()));
        while (dirList.nonEmpty()) {
            File curDir = (File)dirList.remove(0);
            File[] files = curDir.listFiles();
            result.$plus$plus$eq((IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])files));
            dirList.$plus$plus$eq((IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])files), (Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isDirectory()))));
        }
        return (File[])result.toArray(ClassTag$.MODULE$.apply(File.class));
    }

    public static /* synthetic */ Set listFiles$(SparkFileUtils $this, File f) {
        return $this.listFiles(f);
    }

    default public Set<File> listFiles(File f) {
        return JavaUtils.listFiles((File)f);
    }

    public static /* synthetic */ Set listPaths$(SparkFileUtils $this, File f) {
        return $this.listPaths(f);
    }

    default public Set<Path> listPaths(File f) {
        return JavaUtils.listPaths((File)f);
    }

    public static /* synthetic */ boolean createDirectory$(SparkFileUtils $this, File dir) {
        return $this.createDirectory(dir);
    }

    default public boolean createDirectory(File dir) {
        boolean bl;
        try {
            Files.createDirectories(dir.toPath(), new FileAttribute[0]);
            if (!dir.exists() || !dir.isDirectory()) {
                this.logError(LogEntry$.MODULE$.from((Function0<MessageWithContext>)(Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to create directory ", ""}))).log((Seq<MDC>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.PATH, dir)}))));
            }
            bl = dir.isDirectory();
        }
        catch (Exception e) {
            this.logError(LogEntry$.MODULE$.from((Function0<MessageWithContext>)(Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to create directory ", ""}))).log((Seq<MDC>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.PATH, dir)}))), (Throwable)e);
            bl = false;
        }
        return bl;
    }

    public static /* synthetic */ File createDirectory$(SparkFileUtils $this, String root, String namePrefix) {
        return $this.createDirectory(root, namePrefix);
    }

    default public File createDirectory(String root, String namePrefix) {
        return JavaUtils.createDirectory((String)root, (String)namePrefix);
    }

    public static /* synthetic */ String createDirectory$default$2$(SparkFileUtils $this) {
        return $this.createDirectory$default$2();
    }

    default public String createDirectory$default$2() {
        return "spark";
    }

    public static /* synthetic */ File createTempDir$(SparkFileUtils $this) {
        return $this.createTempDir();
    }

    default public File createTempDir() {
        return this.createTempDir(System.getProperty("java.io.tmpdir"), "spark");
    }

    public static /* synthetic */ File createTempDir$(SparkFileUtils $this, String root, String namePrefix) {
        return $this.createTempDir(root, namePrefix);
    }

    default public File createTempDir(String root, String namePrefix) {
        return this.createDirectory(root, namePrefix);
    }

    public static /* synthetic */ String createTempDir$default$1$(SparkFileUtils $this) {
        return $this.createTempDir$default$1();
    }

    default public String createTempDir$default$1() {
        return System.getProperty("java.io.tmpdir");
    }

    public static /* synthetic */ String createTempDir$default$2$(SparkFileUtils $this) {
        return $this.createTempDir$default$2();
    }

    default public String createTempDir$default$2() {
        return "spark";
    }

    public static /* synthetic */ void createParentDirs$(SparkFileUtils $this, File file) {
        $this.createParentDirs(file);
    }

    default public void createParentDirs(File file) {
        if (file == null) {
            throw new IllegalArgumentException("Input should not be null.");
        }
        File parent = file.getParentFile();
        if (parent != null) {
            Files.createDirectories(parent.toPath(), new FileAttribute[0]);
            return;
        }
    }

    public static /* synthetic */ void cleanDirectory$(SparkFileUtils $this, File dir) {
        $this.cleanDirectory(dir);
    }

    default public void cleanDirectory(File dir) {
        JavaUtils.cleanDirectory((File)dir);
    }

    public static /* synthetic */ void deleteRecursively$(SparkFileUtils $this, File file) {
        $this.deleteRecursively(file);
    }

    default public void deleteRecursively(File file) {
        JavaUtils.deleteRecursively((File)file);
    }

    public static /* synthetic */ void deleteQuietly$(SparkFileUtils $this, File file) {
        $this.deleteQuietly(file);
    }

    default public void deleteQuietly(File file) {
        JavaUtils.deleteQuietly((File)file);
    }

    public static /* synthetic */ void forceDeleteOnExit$(SparkFileUtils $this, File file) {
        $this.forceDeleteOnExit(file);
    }

    default public void forceDeleteOnExit(File file) {
        JavaUtils.forceDeleteOnExit((File)file);
    }

    public static /* synthetic */ File getFile$(SparkFileUtils $this, Seq names) {
        return $this.getFile((Seq<String>)names);
    }

    default public File getFile(Seq<String> names) {
        Predef$.MODULE$.require(names != null && names.forall((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)SparkFileUtils.$anonfun$getFile$1(x$3))));
        return ((Path)((IterableOnceOps)names.tail()).foldLeft((Object)Path.of((String)names.head(), new String[0]), (Function2 & Serializable)(path, part) -> path.resolve((String)part))).toFile();
    }

    public static /* synthetic */ File getFile$(SparkFileUtils $this, File parent, Seq names) {
        return $this.getFile(parent, (Seq<String>)names);
    }

    default public File getFile(File parent, Seq<String> names) {
        Predef$.MODULE$.require(parent != null && names != null && names.forall((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)SparkFileUtils.$anonfun$getFile$3(x$4))));
        return ((Path)names.foldLeft((Object)parent.toPath(), (Function2 & Serializable)(path, part) -> path.resolve((String)part))).toFile();
    }

    public static /* synthetic */ void moveFile$(SparkFileUtils $this, File src, File dst) {
        $this.moveFile(src, dst);
    }

    default public void moveFile(File src, File dst) {
        JavaUtils.moveFile((File)src, (File)dst);
    }

    public static /* synthetic */ void moveDirectory$(SparkFileUtils $this, File src, File dst) {
        $this.moveDirectory(src, dst);
    }

    default public void moveDirectory(File src, File dst) {
        JavaUtils.moveDirectory((File)src, (File)dst);
    }

    public static /* synthetic */ void copyDirectory$(SparkFileUtils $this, File src, File dir) {
        $this.copyDirectory(src, dir);
    }

    default public void copyDirectory(File src, File dir) {
        JavaUtils.copyDirectory((File)src, (File)dir);
    }

    public static /* synthetic */ void copyFileToDirectory$(SparkFileUtils $this, File file, File dir) {
        $this.copyFileToDirectory(file, dir);
    }

    default public void copyFileToDirectory(File file, File dir) {
        if (file == null || dir == null || !file.exists() || dir.exists() && !dir.isDirectory()) {
            throw new IllegalArgumentException("Invalid input file " + file + " or directory " + dir);
        }
        Files.createDirectories(dir.toPath(), new FileAttribute[0]);
        File newFile = new File(dir, file.getName());
        Files.copy(file.toPath(), newFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
    }

    public static /* synthetic */ void copyFile$(SparkFileUtils $this, File src, File dst) {
        $this.copyFile(src, dst);
    }

    default public void copyFile(File src, File dst) {
        if (src == null || dst == null || !src.exists() || dst.exists() && dst.isDirectory()) {
            throw new IllegalArgumentException("Invalid input file " + src + " or directory " + dst);
        }
        Files.copy(src.toPath(), dst.toPath(), StandardCopyOption.REPLACE_EXISTING);
    }

    public static /* synthetic */ void copyURLToFile$(SparkFileUtils $this, URL url, File file) {
        $this.copyURLToFile(url, file);
    }

    default public void copyURLToFile(URL url, File file) {
        JavaUtils.copyURLToFile((URL)url, (File)file);
    }

    public static /* synthetic */ boolean contentEquals$(SparkFileUtils $this, File file1, File file2) {
        return $this.contentEquals(file1, file2);
    }

    default public boolean contentEquals(File file1, File file2) {
        return JavaUtils.contentEquals((File)file1, (File)file2);
    }

    public static /* synthetic */ void touch$(SparkFileUtils $this, File file) {
        $this.touch(file);
    }

    default public void touch(File file) {
        if (file == null) {
            throw new IllegalArgumentException("Invalid input file: null");
        }
        Path path = file.toPath();
        if (Files.exists(path, new LinkOption[0])) {
            Files.setLastModifiedTime(path, FileTime.fromMillis(System.currentTimeMillis()));
            return;
        }
        Path parent = path.getParent();
        Object object = parent != null && !Files.exists(parent, new LinkOption[0]) ? Files.createDirectories(parent, new FileAttribute[0]) : BoxedUnit.UNIT;
        Files.createFile(path, new FileAttribute[0]);
    }

    public static /* synthetic */ boolean $anonfun$getFile$1(String x$3) {
        return x$3 != null;
    }

    public static /* synthetic */ boolean $anonfun$getFile$3(String x$4) {
        return x$4 != null;
    }

    public static void $init$(SparkFileUtils $this) {
    }
}

