/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.util.HexFormat;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Hex;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class Hex$
implements Serializable {
    public static final Hex$ MODULE$;
    private static final byte[] hexDigits;
    private static final byte[] unhexDigits;

    /*
     * WARNING - void declaration
     */
    static {
        void var0;
        MODULE$ = new Hex$();
        hexDigits = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};
        byte[] array = (byte[])Array$.MODULE$.fill(128, (Function0)(JFunction0.mcB.sp & Serializable)() -> -1, (ClassTag)ClassTag$.MODULE$.Byte());
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 9).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            array$1[48 + i] = (byte)i;
        });
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 5).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            array$1[65 + i] = (byte)(i + 10);
        });
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 5).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            array$1[97 + i] = (byte)(i + 10);
        });
        unhexDigits = var0;
    }

    private final byte[] hexDigits() {
        return hexDigits;
    }

    public byte[] unhexDigits() {
        return unhexDigits;
    }

    public UTF8String hex(byte[] bytes) {
        int length = bytes.length;
        if (length == 0) {
            return UTF8String.EMPTY_UTF8;
        }
        long targetLength = (long)length * 2L;
        if (targetLength > Integer.MAX_VALUE) {
            throw QueryExecutionErrors$.MODULE$.tooManyArrayElementsError(targetLength, Integer.MAX_VALUE);
        }
        byte[] value = new byte[(int)targetLength];
        for (int i = 0; i < length; ++i) {
            value[i * 2] = this.hexDigits()[(bytes[i] & 0xF0) >> 4];
            value[i * 2 + 1] = this.hexDigits()[bytes[i] & 0xF];
        }
        return UTF8String.fromBytes((byte[])value);
    }

    public UTF8String hex(long num) {
        int zeros = Long.numberOfLeadingZeros(num);
        if (zeros == 64) {
            return UTF8String.ZERO_UTF8;
        }
        int len = (64 - zeros + 3) / 4;
        long numBuf = num;
        byte[] value = new byte[len];
        for (int i = len - 1; i >= 0; --i) {
            value[i] = this.hexDigits()[(int)(numBuf & 0xFL)];
            numBuf >>>= 4;
        }
        return UTF8String.fromBytes((byte[])value);
    }

    public byte[] unhex(byte[] bytes) {
        int length = bytes.length;
        if (length == 0) {
            return Array$.MODULE$.emptyByteArray();
        }
        if ((length & 1) != 0) {
            byte[] result = new byte[length / 2 + 1];
            for (int i = result.length - 1; i > 0; --i) {
                result[i] = (byte)(HexFormat.fromHexDigit(bytes[i * 2 - 1]) << 4 | HexFormat.fromHexDigit(bytes[i * 2]));
            }
            result[0] = (byte)HexFormat.fromHexDigit(bytes[0]);
            return result;
        }
        byte[] result = new byte[length / 2];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (byte)(HexFormat.fromHexDigit(bytes[2 * i]) << 4 | HexFormat.fromHexDigit(bytes[2 * i + 1]));
        }
        return result;
    }

    public byte[] unhex(String str) {
        return this.unhex(str.getBytes());
    }

    public Hex apply(Expression child) {
        return new Hex(child);
    }

    public Option<Expression> unapply(Hex x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)x$0.child());
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Hex$.class);
    }

    private Hex$() {
    }
}

