/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.state;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.concurrent.GuardedBy;
import org.apache.spark.TaskContext;
import org.apache.spark.TaskContext$;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.execution.streaming.state.AcquiredThreadInfo;
import org.apache.spark.sql.execution.streaming.state.AcquiredThreadInfo$;
import org.apache.spark.sql.execution.streaming.state.RocksDBConf;
import org.apache.spark.sql.execution.streaming.state.RocksDBStateMachine$ACQUIRED$;
import org.apache.spark.sql.execution.streaming.state.RocksDBStateMachine$CLOSE$;
import org.apache.spark.sql.execution.streaming.state.RocksDBStateMachine$CLOSED$;
import org.apache.spark.sql.execution.streaming.state.RocksDBStateMachine$LOAD$;
import org.apache.spark.sql.execution.streaming.state.RocksDBStateMachine$MAINTENANCE$;
import org.apache.spark.sql.execution.streaming.state.RocksDBStateMachine$RELEASE$;
import org.apache.spark.sql.execution.streaming.state.RocksDBStateMachine$RELEASED$;
import org.apache.spark.sql.execution.streaming.state.StateStoreErrors$;
import org.apache.spark.sql.execution.streaming.state.StateStoreId;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\r]a\u0001B4i\u0001]D!\"!\u0003\u0001\u0005\u0003\u0005\u000b\u0011BA\u0006\u0011)\t\u0019\u0002\u0001B\u0001B\u0003%\u0011Q\u0003\u0005\b\u00037\u0001A\u0011AA\u000f\r%\t)\u0003\u0001I\u0001$S\t9cB\u0004\u0002F\u0002AI)a/\u0007\u000f\u0005U\u0006\u0001##\u00028\"9\u00111\u0004\u0004\u0005\u0002\u0005e\u0006\"CA+\r\u0005\u0005I\u0011IA,\u0011%\tIGBA\u0001\n\u0003\tY\u0007C\u0005\u0002t\u0019\t\t\u0011\"\u0001\u0002>\"I\u0011\u0011\u0011\u0004\u0002\u0002\u0013\u0005\u00131\u0011\u0005\n\u0003#3\u0011\u0011!C\u0001\u0003\u0003D\u0011\"!(\u0007\u0003\u0003%\t%a(\t\u0013\u0005\u0005f!!A\u0005B\u0005\rvaBAd\u0001!%\u00151\u000b\u0004\b\u0003W\u0001\u0001\u0012RA\u0017\u0011\u001d\tY\u0002\u0005C\u0001\u0003#B\u0011\"!\u0016\u0011\u0003\u0003%\t%a\u0016\t\u0013\u0005%\u0004#!A\u0005\u0002\u0005-\u0004\"CA:!\u0005\u0005I\u0011AA;\u0011%\t\t\tEA\u0001\n\u0003\n\u0019\tC\u0005\u0002\u0012B\t\t\u0011\"\u0001\u0002\u0014\"I\u0011Q\u0014\t\u0002\u0002\u0013\u0005\u0013q\u0014\u0005\n\u0003C\u0003\u0012\u0011!C!\u0003G;q!!3\u0001\u0011\u0013\u000bYKB\u0004\u0002&\u0002AI)a*\t\u000f\u0005m!\u0004\"\u0001\u0002*\"I\u0011Q\u000b\u000e\u0002\u0002\u0013\u0005\u0013q\u000b\u0005\n\u0003SR\u0012\u0011!C\u0001\u0003WB\u0011\"a\u001d\u001b\u0003\u0003%\t!!,\t\u0013\u0005\u0005%$!A\u0005B\u0005\r\u0005\"CAI5\u0005\u0005I\u0011AAY\u0011%\tiJGA\u0001\n\u0003\ny\nC\u0005\u0002\"j\t\t\u0011\"\u0011\u0002$\u001a9\u00111\u001a\u0001\u0002*\u00055\u0007BCAhG\t\u0005\t\u0015!\u0003\u0002R\"9\u00111D\u0012\u0005\u0002\u0005}\u0007bBAQG\u0011\u0005\u0013Q]\u0004\b\u0005S\u0001\u0001\u0012RA\u0000\r\u001d\tI\u0010\u0001EE\u0003wDq!a\u0007)\t\u0003\ti\u0010C\u0005\u0002V!\n\t\u0011\"\u0011\u0002X!I\u0011\u0011\u000e\u0015\u0002\u0002\u0013\u0005\u00111\u000e\u0005\n\u0003gB\u0013\u0011!C\u0001\u0005\u0003A\u0011\"!!)\u0003\u0003%\t%a!\t\u0013\u0005E\u0005&!A\u0005\u0002\t\u0015\u0001\"CAOQ\u0005\u0005I\u0011IAP\u000f\u001d\u0011Y\u0003\u0001EE\u0005?1qA!\u0007\u0001\u0011\u0013\u0013Y\u0002C\u0004\u0002\u001cE\"\tA!\b\t\u0013\u0005U\u0013'!A\u0005B\u0005]\u0003\"CA5c\u0005\u0005I\u0011AA6\u0011%\t\u0019(MA\u0001\n\u0003\u0011\t\u0003C\u0005\u0002\u0002F\n\t\u0011\"\u0011\u0002\u0004\"I\u0011\u0011S\u0019\u0002\u0002\u0013\u0005!Q\u0005\u0005\n\u0003;\u000b\u0014\u0011!C!\u0003?;qA!\f\u0001\u0011\u0013\u000byOB\u0004\u0002j\u0002AI)a;\t\u000f\u0005m!\b\"\u0001\u0002n\"I\u0011Q\u000b\u001e\u0002\u0002\u0013\u0005\u0013q\u000b\u0005\n\u0003SR\u0014\u0011!C\u0001\u0003WB\u0011\"a\u001d;\u0003\u0003%\t!!=\t\u0013\u0005\u0005%(!A\u0005B\u0005\r\u0005\"CAIu\u0005\u0005I\u0011AA{\u0011%\tiJOA\u0001\n\u0003\nyjB\u0004\u00030\u0001AIIa\u0004\u0007\u000f\t%\u0001\u0001##\u0003\f!9\u00111D\"\u0005\u0002\t5\u0001\"CA+\u0007\u0006\u0005I\u0011IA,\u0011%\tIgQA\u0001\n\u0003\tY\u0007C\u0005\u0002t\r\u000b\t\u0011\"\u0001\u0003\u0012!I\u0011\u0011Q\"\u0002\u0002\u0013\u0005\u00131\u0011\u0005\n\u0003#\u001b\u0015\u0011!C\u0001\u0005+A\u0011\"!(D\u0003\u0003%\t%a(\t\u0013\tE\u0002A1A\u0005\n\tM\u0002\u0002\u0003B\u001e\u0001\u0001\u0006IA!\u000e\t\u0011%\u0004\u0001\u0019!C\u0005\u0005{A\u0011Ba\u0010\u0001\u0001\u0004%IA!\u0011\t\u0011\t-\u0003\u0001)Q\u0005\u0003_A1Ba\u001a\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0003j!Y!\u0011\u000f\u0001A\u0002\u0003\u0007I\u0011\u0002B:\u0011-\u00119\b\u0001a\u0001\u0002\u0003\u0006KAa\u001b\t\u0013\tm\u0004A1A\u0005\n\tu\u0004\u0002\u0003BC\u0001\u0001\u0006IAa \t\u0013\t\u001d\u0005A1A\u0005\n\t%\u0005\u0002\u0003BL\u0001\u0001\u0006IAa#\t\u0011\te\u0005\u0001\"\u0001q\u00057C!Ba)\u0001\u0005\u0004%\t\u0001\u001bBS\u0011!\u0011I\f\u0001Q\u0001\n\t\u001d\u0006\"\u0003B^\u0001\u0001\u0007I\u0011\u0002B?\u0011%\u0011i\f\u0001a\u0001\n\u0013\u0011y\f\u0003\u0005\u0003D\u0002\u0001\u000b\u0015\u0002B@\u0011\u001d\u00119\r\u0001C\u0005\u0005{BqAa3\u0001\t\u0013\u0011i\rC\u0004\u0003V\u0002!IAa6\t\u000f\te\u0007\u0001\"\u0003\u0003\\\"9!1\u001d\u0001\u0005\u0002\t\u0015\bb\u0002Bv\u0001\u0011\u0005!Q\u001e\u0005\n\u0005k\u0004\u0011\u0013!C\u0001\u0005oDqaa\u0003\u0001\t\u0003\u0019i\u0001C\u0004\u0004\u0010\u0001!\ta!\u0005\t\u000f\rM\u0001\u0001\"\u0001\u0004\u0016\t\u0019\"k\\2lg\u0012\u00135\u000b^1uK6\u000b7\r[5oK*\u0011\u0011N[\u0001\u0006gR\fG/\u001a\u0006\u0003W2\f\u0011b\u001d;sK\u0006l\u0017N\\4\u000b\u00055t\u0017!C3yK\u000e,H/[8o\u0015\ty\u0007/A\u0002tc2T!!\u001d:\u0002\u000bM\u0004\u0018M]6\u000b\u0005M$\u0018AB1qC\u000eDWMC\u0001v\u0003\ry'oZ\u0002\u0001'\r\u0001\u0001P \t\u0003srl\u0011A\u001f\u0006\u0002w\u0006)1oY1mC&\u0011QP\u001f\u0002\u0007\u0003:L(+\u001a4\u0011\u0007}\f)!\u0004\u0002\u0002\u0002)\u0019\u00111\u00019\u0002\u0011%tG/\u001a:oC2LA!a\u0002\u0002\u0002\t9Aj\\4hS:<\u0017\u0001D:uCR,7\u000b^8sK&#\u0007\u0003BA\u0007\u0003\u001fi\u0011\u0001[\u0005\u0004\u0003#A'\u0001D*uCR,7\u000b^8sK&#\u0017a\u0003:pG.\u001cHIQ\"p]\u001a\u0004B!!\u0004\u0002\u0018%\u0019\u0011\u0011\u00045\u0003\u0017I{7m[:E\u0005\u000e{gNZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\r\u0005}\u0011\u0011EA\u0012!\r\ti\u0001\u0001\u0005\b\u0003\u0013\u0019\u0001\u0019AA\u0006\u0011\u001d\t\u0019b\u0001a\u0001\u0003+\u0011Qa\u0015+B)\u0016\u001b\"\u0001\u0002=*\t\u0011\u0001\"D\u0002\u0002\t\u0003\u000e\u000bV+\u0013*F\tNA\u0001\u0003_A\u0018\u0003g\tI\u0004E\u0002\u00022\u0011i\u0011\u0001\u0001\t\u0004s\u0006U\u0012bAA\u001cu\n9\u0001K]8ek\u000e$\b\u0003BA\u001e\u0003\u0017rA!!\u0010\u0002H9!\u0011qHA#\u001b\t\t\tEC\u0002\u0002DY\fa\u0001\u0010:p_Rt\u0014\"A>\n\u0007\u0005%#0A\u0004qC\u000e\\\u0017mZ3\n\t\u00055\u0013q\n\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0006\u0004\u0003\u0013RHCAA*!\r\t\t\u0004E\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005e\u0003\u0003BA.\u0003Kj!!!\u0018\u000b\t\u0005}\u0013\u0011M\u0001\u0005Y\u0006twM\u0003\u0002\u0002d\u0005!!.\u0019<b\u0013\u0011\t9'!\u0018\u0003\rM#(/\u001b8h\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\ti\u0007E\u0002z\u0003_J1!!\u001d{\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\t9(! \u0011\u0007e\fI(C\u0002\u0002|i\u00141!\u00118z\u0011%\ty\bFA\u0001\u0002\u0004\ti'A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003\u000b\u0003b!a\"\u0002\u000e\u0006]TBAAE\u0015\r\tYI_\u0001\u000bG>dG.Z2uS>t\u0017\u0002BAH\u0003\u0013\u0013\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u0011QSAN!\rI\u0018qS\u0005\u0004\u00033S(a\u0002\"p_2,\u0017M\u001c\u0005\n\u0003\u007f2\u0012\u0011!a\u0001\u0003o\n\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0003[\n\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u00033\u0012aa\u0011'P'\u0016#5\u0003\u0003\u000ey\u0003_\t\u0019$!\u000f\u0015\u0005\u0005-\u0006cAA\u00195Q!\u0011qOAX\u0011%\tyHHA\u0001\u0002\u0004\ti\u0007\u0006\u0003\u0002\u0016\u0006M\u0006\"CA@A\u0005\u0005\t\u0019AA<\u0005!\u0011V\tT#B'\u0016#5\u0003\u0003\u0004y\u0003_\t\u0019$!\u000f\u0015\u0005\u0005m\u0006cAA\u0019\rQ!\u0011qOA`\u0011%\tyHCA\u0001\u0002\u0004\ti\u0007\u0006\u0003\u0002\u0016\u0006\r\u0007\"CA@\u0019\u0005\u0005\t\u0019AA<\u0003!\u0011V\tT#B'\u0016#\u0015\u0001C!D#VK%+\u0012#\u0002\r\rcujU#E\u0005%y\u0005+\u0012*B)&{ej\u0005\u0002$q\u0006!a.Y7f!\u0011\t\u0019.a7\u000f\t\u0005U\u0017q\u001b\t\u0004\u0003\u007fQ\u0018bAAmu\u00061\u0001K]3eK\u001aLA!a\u001a\u0002^*\u0019\u0011\u0011\u001c>\u0015\t\u0005\u0005\u00181\u001d\t\u0004\u0003c\u0019\u0003bBAhK\u0001\u0007\u0011\u0011\u001b\u000b\u0003\u0003#LSa\t\u001e)\u0007F\u0012Qa\u0011'P'\u0016\u001brAOAq\u0003g\tI\u0004\u0006\u0002\u0002pB\u0019\u0011\u0011\u0007\u001e\u0015\t\u0005]\u00141\u001f\u0005\n\u0003\u007fr\u0014\u0011!a\u0001\u0003[\"B!!&\u0002x\"I\u0011q\u0010!\u0002\u0002\u0003\u0007\u0011q\u000f\u0002\u0005\u0019>\u000bEiE\u0004)\u0003C\f\u0019$!\u000f\u0015\u0005\u0005}\bcAA\u0019QQ!\u0011q\u000fB\u0002\u0011%\ty\bLA\u0001\u0002\u0004\ti\u0007\u0006\u0003\u0002\u0016\n\u001d\u0001\"CA@]\u0005\u0005\t\u0019AA<\u0005-i\u0015)\u0013(U\u000b:\u000bejQ#\u0014\u000f\r\u000b\t/a\r\u0002:Q\u0011!q\u0002\t\u0004\u0003c\u0019E\u0003BA<\u0005'A\u0011\"a H\u0003\u0003\u0005\r!!\u001c\u0015\t\u0005U%q\u0003\u0005\n\u0003\u007fJ\u0015\u0011!a\u0001\u0003o\u0012qAU#M\u000b\u0006\u001bViE\u00042\u0003C\f\u0019$!\u000f\u0015\u0005\t}\u0001cAA\u0019cQ!\u0011q\u000fB\u0012\u0011%\ty(NA\u0001\u0002\u0004\ti\u0007\u0006\u0003\u0002\u0016\n\u001d\u0002\"CA@o\u0005\u0005\t\u0019AA<\u0003\u0011au*\u0011#\u0002\u000fI+E*R!T\u000b\u0006)1\tT(T\u000b\u0006YQ*Q%O)\u0016s\u0015IT\"F\u0003A\u0019H/\u0019;f\u001b\u0006\u001c\u0007.\u001b8f\u0019>\u001c7.\u0006\u0002\u00036A!\u00111\fB\u001c\u0013\u0011\u0011I$!\u0018\u0003\r=\u0013'.Z2u\u0003E\u0019H/\u0019;f\u001b\u0006\u001c\u0007.\u001b8f\u0019>\u001c7\u000eI\u000b\u0003\u0003_\t\u0011b\u001d;bi\u0016|F%Z9\u0015\t\t\r#\u0011\n\t\u0004s\n\u0015\u0013b\u0001B$u\n!QK\\5u\u0011%\tyHTA\u0001\u0002\u0004\ty#\u0001\u0004ti\u0006$X\r\t\u0015\b\u001f\n=#1\rB3!\u0011\u0011\tFa\u0018\u000e\u0005\tM#\u0002\u0002B+\u0005/\n!bY8oGV\u0014(/\u001a8u\u0015\u0011\u0011IFa\u0017\u0002\u0015\u0005tgn\u001c;bi&|gN\u0003\u0002\u0003^\u0005)!.\u0019<bq&!!\u0011\rB*\u0005%9U/\u0019:eK\u0012\u0014\u00150A\u0003wC2,X-\t\u0002\u00032\u0005\u0011\u0012mY9vSJ,G\r\u00165sK\u0006$\u0017J\u001c4p+\t\u0011Y\u0007\u0005\u0003\u0002\u000e\t5\u0014b\u0001B8Q\n\u0011\u0012iY9vSJ,G\r\u00165sK\u0006$\u0017J\u001c4p\u0003Y\t7-];je\u0016$G\u000b\u001b:fC\u0012LeNZ8`I\u0015\fH\u0003\u0002B\"\u0005kB\u0011\"a R\u0003\u0003\u0005\rAa\u001b\u0002'\u0005\u001c\u0017/^5sK\u0012$\u0006N]3bI&sgm\u001c\u0011)\u000fI\u0013yEa\u0019\u0003f\u0005a\"+\u0012'F\u0003N+EiX*U\u0003R+u,T!D\u0011&sUiX*U\u00036\u0003VC\u0001B@!\rI(\u0011Q\u0005\u0004\u0005\u0007S(\u0001\u0002'p]\u001e\fQDU#M\u000b\u0006\u001bV\tR0T)\u0006#ViX'B\u0007\"Ke*R0T)\u0006k\u0005\u000bI\u0001\u0018C2dwn^3e'R\fG/\u001a+sC:\u001c\u0018\u000e^5p]N,\"Aa#\u0011\u0011\u0005M'Q\u0012BI\u0003_IAAa$\u0002^\n\u0019Q*\u00199\u0011\u000fe\u0014\u0019*a\f\u0002b&\u0019!Q\u0013>\u0003\rQ+\b\u000f\\33\u0003a\tG\u000e\\8xK\u0012\u001cF/\u0019;f)J\fgn]5uS>t7\u000fI\u0001\u0016O\u0016$\u0018iY9vSJ,G\r\u00165sK\u0006$\u0017J\u001c4p+\t\u0011i\nE\u0003z\u0005?\u0013Y'C\u0002\u0003\"j\u0014aa\u00149uS>t\u0017!E2veJ,g\u000e\u001e,bY&$7\u000b^1naV\u0011!q\u0015\t\u0005\u0005S\u0013),\u0004\u0002\u0003,*!!Q\u0016BX\u0003\u0019\tGo\\7jG*!!Q\u000bBY\u0015\u0011\u0011\u0019,!\u0019\u0002\tU$\u0018\u000e\\\u0005\u0005\u0005o\u0013YK\u0001\u0006Bi>l\u0017n\u0019'p]\u001e\f!cY;se\u0016tGOV1mS\u0012\u001cF/Y7qA\u0005qA.Y:u-\u0006d\u0017\u000eZ*uC6\u0004\u0018A\u00057bgR4\u0016\r\\5e'R\fW\u000e]0%KF$BAa\u0011\u0003B\"I\u0011qP.\u0002\u0002\u0003\u0007!qP\u0001\u0010Y\u0006\u001cHOV1mS\u0012\u001cF/Y7qA!:ALa\u0014\u0003d\t\u0015\u0014AF5oG\u0006sGmR3u'R\fW\u000e],ji\"dunY6)\u000fu\u0013yEa\u0019\u0003f\u0005A\u0012m^1ji:{G/Q2rk&\u0014X\rZ,ji\"dunY6\u0015\t\t\r#q\u001a\u0005\b\u0005#t\u0006\u0019AAq\u0003%y\u0007/\u001a:bi&|g\u000eK\u0004_\u0005\u001f\u0012\u0019G!\u001a\u0002\rQ\f7o[%E+\t\t\t.\u0001\u000ewC2LG-\u0019;f\u0003:$GK]1og&$\u0018n\u001c8Ti\u0006$X\r\u0006\u0003\u0003^\n}\u0007cB=\u0003\u0014\u0006=\u0012q\u0006\u0005\b\u0005#\u0004\u0007\u0019AAqQ\u001d\u0001'q\nB2\u0005K\n1B^3sS\u001aL8\u000b^1naR!!1\tBt\u0011\u001d\u0011I/\u0019a\u0001\u0005\u007f\nQa\u001d;b[B\fAB]3mK\u0006\u001cXm\u0015;b[B$b!!&\u0003p\nE\bb\u0002BuE\u0002\u0007!q\u0010\u0005\n\u0005g\u0014\u0007\u0013!a\u0001\u0003+\u000bq\u0001\u001e5s_^,\u00050\u0001\fsK2,\u0017m]3Ti\u0006l\u0007\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t\u0011IP\u000b\u0003\u0002\u0016\nm8F\u0001B\u007f!\u0011\u0011ypa\u0002\u000e\u0005\r\u0005!\u0002BB\u0002\u0007\u000b\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\te#0\u0003\u0003\u0004\n\r\u0005!!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006a\u0011mY9vSJ,7\u000b^1naR\u0011!qP\u0001\u0015m\u0016\u0014\u0018NZ=G_Jl\u0015-\u001b8uK:\fgnY3\u0015\u0005\t\r\u0013!B2m_N,GCAAK\u0001")
public class RocksDBStateMachine
implements Logging {
    private volatile RocksDBStateMachine$RELEASED$ RELEASED$module;
    private volatile RocksDBStateMachine$ACQUIRED$ ACQUIRED$module;
    private volatile RocksDBStateMachine$CLOSED$ CLOSED$module;
    private volatile RocksDBStateMachine$LOAD$ LOAD$module;
    private volatile RocksDBStateMachine$RELEASE$ RELEASE$module;
    private volatile RocksDBStateMachine$CLOSE$ CLOSE$module;
    private volatile RocksDBStateMachine$MAINTENANCE$ MAINTENANCE$module;
    private final StateStoreId stateStoreId;
    private final RocksDBConf rocksDBConf;
    private final Object stateMachineLock;
    @GuardedBy(value="stateMachineLock")
    private STATE state;
    @GuardedBy(value="stateMachineLock")
    private AcquiredThreadInfo acquiredThreadInfo;
    private final long RELEASED_STATE_MACHINE_STAMP;
    private final scala.collection.immutable.Map<Tuple2<STATE, OPERATION>, STATE> allowedStateTransitions;
    private final AtomicLong currentValidStamp;
    @GuardedBy(value="stateMachineLock")
    private long lastValidStamp;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body2) {
        Logging.withLogContext$((Logging)this, context, body2);
    }

    public MDC MDC(LogKey key, Object value) {
        return Logging.MDC$((Logging)this, (LogKey)key, (Object)value);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    private RocksDBStateMachine$RELEASED$ RELEASED() {
        if (this.RELEASED$module == null) {
            this.RELEASED$lzycompute$1();
        }
        return this.RELEASED$module;
    }

    private RocksDBStateMachine$ACQUIRED$ ACQUIRED() {
        if (this.ACQUIRED$module == null) {
            this.ACQUIRED$lzycompute$1();
        }
        return this.ACQUIRED$module;
    }

    private RocksDBStateMachine$CLOSED$ CLOSED() {
        if (this.CLOSED$module == null) {
            this.CLOSED$lzycompute$1();
        }
        return this.CLOSED$module;
    }

    private RocksDBStateMachine$LOAD$ LOAD() {
        if (this.LOAD$module == null) {
            this.LOAD$lzycompute$1();
        }
        return this.LOAD$module;
    }

    private RocksDBStateMachine$RELEASE$ RELEASE() {
        if (this.RELEASE$module == null) {
            this.RELEASE$lzycompute$1();
        }
        return this.RELEASE$module;
    }

    private RocksDBStateMachine$CLOSE$ CLOSE() {
        if (this.CLOSE$module == null) {
            this.CLOSE$lzycompute$1();
        }
        return this.CLOSE$module;
    }

    private RocksDBStateMachine$MAINTENANCE$ MAINTENANCE() {
        if (this.MAINTENANCE$module == null) {
            this.MAINTENANCE$lzycompute$1();
        }
        return this.MAINTENANCE$module;
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private Object stateMachineLock() {
        return this.stateMachineLock;
    }

    private STATE state() {
        return this.state;
    }

    private void state_$eq(STATE x$1) {
        this.state = x$1;
    }

    private AcquiredThreadInfo acquiredThreadInfo() {
        return this.acquiredThreadInfo;
    }

    private void acquiredThreadInfo_$eq(AcquiredThreadInfo x$1) {
        this.acquiredThreadInfo = x$1;
    }

    private long RELEASED_STATE_MACHINE_STAMP() {
        return this.RELEASED_STATE_MACHINE_STAMP;
    }

    private scala.collection.immutable.Map<Tuple2<STATE, OPERATION>, STATE> allowedStateTransitions() {
        return this.allowedStateTransitions;
    }

    public Option<AcquiredThreadInfo> getAcquiredThreadInfo() {
        Option option;
        Object object = this.stateMachineLock();
        synchronized (object) {
            option = Option$.MODULE$.apply((Object)this.acquiredThreadInfo()).map((Function1 & Serializable)x$2 -> x$2.copy(x$2.copy$default$1(), x$2.copy$default$2()));
        }
        return option;
    }

    public AtomicLong currentValidStamp() {
        return this.currentValidStamp;
    }

    private long lastValidStamp() {
        return this.lastValidStamp;
    }

    private void lastValidStamp_$eq(long x$1) {
        this.lastValidStamp = x$1;
    }

    @GuardedBy(value="stateMachineLock")
    private long incAndGetStampWithLock() {
        Predef$.MODULE$.assert(Thread.holdsLock(this.stateMachineLock()), (Function0 & Serializable)() -> "Instance lock must be held");
        this.lastValidStamp_$eq(this.lastValidStamp() + 1L);
        this.currentValidStamp().set(this.lastValidStamp());
        this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"New stamp: ", " issued for "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.STAMP, BoxesRunTime.boxToLong((long)this.currentValidStamp().get()))})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.STATE_STORE_ID, $this.stateStoreId)})))));
        return this.lastValidStamp();
    }

    @GuardedBy(value="stateMachineLock")
    private void awaitNotAcquiredWithLock(OPERATION operation) {
        Predef$.MODULE$.assert(Thread.holdsLock(this.stateMachineLock()), (Function0 & Serializable)() -> "Instance lock must be held");
        long waitStartTime = System.nanoTime();
        while (true) {
            STATE sTATE = this.state();
            RocksDBStateMachine$ACQUIRED$ rocksDBStateMachine$ACQUIRED$ = this.ACQUIRED();
            if ((sTATE != null ? !sTATE.equals(rocksDBStateMachine$ACQUIRED$) : rocksDBStateMachine$ACQUIRED$ != null) || RocksDBStateMachine.timeWaitedMs$1(waitStartTime) >= this.rocksDBConf.lockAcquireTimeoutMs()) break;
            this.stateMachineLock().wait(10L);
            if (RocksDBStateMachine.timeWaitedMs$1(waitStartTime) % 30000L != 0L) continue;
            this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Waiting to acquire lock for ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.STATE_STORE_ID, $this.stateStoreId)}))));
        }
        STATE sTATE = this.state();
        RocksDBStateMachine$ACQUIRED$ rocksDBStateMachine$ACQUIRED$ = this.ACQUIRED();
        if (!(sTATE != null ? !sTATE.equals(rocksDBStateMachine$ACQUIRED$) : rocksDBStateMachine$ACQUIRED$ != null)) {
            AcquiredThreadInfo newAcquiredThreadInfo = new AcquiredThreadInfo(AcquiredThreadInfo$.MODULE$.apply$default$1(), AcquiredThreadInfo$.MODULE$.apply$default$2());
            String stackTraceOutput = Predef$.MODULE$.wrapRefArray((Object[])((Thread)this.acquiredThreadInfo().threadRef().get().get()).getStackTrace()).mkString("\n");
            String loggingId = "StateStoreId(opId=" + this.stateStoreId.operatorId() + ",partId=" + this.stateStoreId.partitionId() + ",name=" + this.stateStoreId.storeName() + ")";
            throw QueryExecutionErrors$.MODULE$.unreleasedThreadError(loggingId, operation.toString(), newAcquiredThreadInfo.toString(), this.acquiredThreadInfo().toString(), RocksDBStateMachine.timeWaitedMs$1(waitStartTime), stackTraceOutput);
        }
    }

    private String taskID() {
        TaskContext taskContext = TaskContext$.MODULE$.get();
        if (taskContext != null) {
            return Long.toString(taskContext.taskAttemptId());
        }
        return "undefined";
    }

    @GuardedBy(value="stateMachineLock")
    private Tuple2<STATE, STATE> validateAndTransitionState(OPERATION operation) {
        Predef$.MODULE$.assert(Thread.holdsLock(this.stateMachineLock()), (Function0 & Serializable)() -> "Instance lock must be held");
        STATE oldState = this.state();
        Option option = this.allowedStateTransitions().get((Object)new Tuple2((Object)oldState, (Object)operation));
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                String string;
                OPERATION oPERATION = operation;
                if (this.LOAD().equals(oPERATION)) {
                    string = "ACQUIRED";
                } else if (this.RELEASE().equals(oPERATION)) {
                    string = "RELEASED";
                } else if (this.CLOSE().equals(oPERATION)) {
                    string = "CLOSED";
                } else if (this.MAINTENANCE().equals(oPERATION)) {
                    string = oldState.toString();
                } else {
                    throw new MatchError((Object)oPERATION);
                }
                String expectedState = string;
                throw StateStoreErrors$.MODULE$.invalidStateMachineTransition(oldState.toString(), expectedState, operation.toString(), this.stateStoreId);
            }
            throw new MatchError((Object)option);
        }
        Some some = (Some)option;
        STATE nextState = (STATE)some.value();
        STATE newState = nextState;
        this.state_$eq(newState);
        STATE sTATE = newState;
        RocksDBStateMachine$ACQUIRED$ rocksDBStateMachine$ACQUIRED$ = this.ACQUIRED();
        if (!(sTATE != null ? !sTATE.equals(rocksDBStateMachine$ACQUIRED$) : rocksDBStateMachine$ACQUIRED$ != null)) {
            this.acquiredThreadInfo_$eq(new AcquiredThreadInfo(AcquiredThreadInfo$.MODULE$.apply$default$1(), AcquiredThreadInfo$.MODULE$.apply$default$2()));
        }
        this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Transitioned state from ", " "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.STATE_STORE_STATE, oldState)})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"to ", " "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.STATE_STORE_STATE, newState)}))).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"with operation ", " "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.OPERATION, operation.toString())}))).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"for StateStoreId ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.STATE_STORE_ID, $this.stateStoreId)}))).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"by TaskID ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.TASK_ID, this.taskID())})))));
        return new Tuple2((Object)oldState, (Object)newState);
    }

    public void verifyStamp(long stamp) {
        long currentStamp = this.currentValidStamp().get();
        if (stamp != currentStamp) {
            this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid stamp=", " "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.STAMP, BoxesRunTime.boxToLong((long)stamp))})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"used by TaskID=", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.TASK_ID, this.taskID())})))));
            throw StateStoreErrors$.MODULE$.invalidStamp(stamp, currentStamp);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean releaseStamp(long stamp, boolean throwEx) {
        Object object = this.stateMachineLock();
        synchronized (object) {
            boolean bl = this.currentValidStamp().compareAndSet(stamp, this.RELEASED_STATE_MACHINE_STAMP());
            if (bl) {
                this.validateAndTransitionState(this.RELEASE());
                return true;
            }
            if (false != bl) throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
            boolean bl2 = throwEx;
            if (bl2) {
                long actualStamp = this.currentValidStamp().get();
                throw StateStoreErrors$.MODULE$.invalidStamp(stamp, actualStamp);
            }
            if (false != bl2) throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl2));
            return false;
        }
    }

    public boolean releaseStamp$default$2() {
        return true;
    }

    public long acquireStamp() {
        long l;
        Object object = this.stateMachineLock();
        synchronized (object) {
            this.awaitNotAcquiredWithLock(this.LOAD());
            this.validateAndTransitionState(this.LOAD());
            l = this.incAndGetStampWithLock();
        }
        return l;
    }

    public void verifyForMaintenance() {
        Object object = this.stateMachineLock();
        synchronized (object) {
            this.validateAndTransitionState(this.MAINTENANCE());
        }
    }

    public boolean close() {
        boolean bl;
        Object object = this.stateMachineLock();
        synchronized (object) {
            boolean bl2;
            STATE sTATE = this.state();
            RocksDBStateMachine$CLOSED$ rocksDBStateMachine$CLOSED$ = this.CLOSED();
            if (!(sTATE != null ? !sTATE.equals(rocksDBStateMachine$CLOSED$) : rocksDBStateMachine$CLOSED$ != null)) {
                bl2 = false;
            } else {
                this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Trying to close store ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.STATE_STORE_ID, $this.stateStoreId)}))));
                this.awaitNotAcquiredWithLock(this.CLOSE());
                this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Finished waiting to acquire lock,"}))).log((Seq)Nil$.MODULE$).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{" transitioning to close store ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.STATE_STORE_ID, $this.stateStoreId)})))));
                this.validateAndTransitionState(this.CLOSE());
                bl2 = true;
            }
            bl = bl2;
        }
        return bl;
    }

    private final void RELEASED$lzycompute$1() {
        RocksDBStateMachine rocksDBStateMachine = this;
        synchronized (rocksDBStateMachine) {
            if (this.RELEASED$module == null) {
                this.RELEASED$module = new RocksDBStateMachine$RELEASED$(this);
            }
        }
    }

    private final void ACQUIRED$lzycompute$1() {
        RocksDBStateMachine rocksDBStateMachine = this;
        synchronized (rocksDBStateMachine) {
            if (this.ACQUIRED$module == null) {
                this.ACQUIRED$module = new RocksDBStateMachine$ACQUIRED$(this);
            }
        }
    }

    private final void CLOSED$lzycompute$1() {
        RocksDBStateMachine rocksDBStateMachine = this;
        synchronized (rocksDBStateMachine) {
            if (this.CLOSED$module == null) {
                this.CLOSED$module = new RocksDBStateMachine$CLOSED$(this);
            }
        }
    }

    private final void LOAD$lzycompute$1() {
        RocksDBStateMachine rocksDBStateMachine = this;
        synchronized (rocksDBStateMachine) {
            if (this.LOAD$module == null) {
                this.LOAD$module = new RocksDBStateMachine$LOAD$(this);
            }
        }
    }

    private final void RELEASE$lzycompute$1() {
        RocksDBStateMachine rocksDBStateMachine = this;
        synchronized (rocksDBStateMachine) {
            if (this.RELEASE$module == null) {
                this.RELEASE$module = new RocksDBStateMachine$RELEASE$(this);
            }
        }
    }

    private final void CLOSE$lzycompute$1() {
        RocksDBStateMachine rocksDBStateMachine = this;
        synchronized (rocksDBStateMachine) {
            if (this.CLOSE$module == null) {
                this.CLOSE$module = new RocksDBStateMachine$CLOSE$(this);
            }
        }
    }

    private final void MAINTENANCE$lzycompute$1() {
        RocksDBStateMachine rocksDBStateMachine = this;
        synchronized (rocksDBStateMachine) {
            if (this.MAINTENANCE$module == null) {
                this.MAINTENANCE$module = new RocksDBStateMachine$MAINTENANCE$(this);
            }
        }
    }

    private static final long timeWaitedMs$1(long waitStartTime$1) {
        long elapsedNanos = System.nanoTime() - waitStartTime$1;
        return TimeUnit.MILLISECONDS.convert(elapsedNanos, TimeUnit.NANOSECONDS);
    }

    public RocksDBStateMachine(StateStoreId stateStoreId, RocksDBConf rocksDBConf) {
        this.stateStoreId = stateStoreId;
        this.rocksDBConf = rocksDBConf;
        Logging.$init$((Logging)this);
        this.stateMachineLock = new Object();
        this.state = this.RELEASED();
        this.RELEASED_STATE_MACHINE_STAMP = -1L;
        this.allowedStateTransitions = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)this.RELEASED(), (Object)this.LOAD())), (Object)this.ACQUIRED()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)this.ACQUIRED(), (Object)this.RELEASE())), (Object)this.RELEASED()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)this.RELEASED(), (Object)this.CLOSE())), (Object)this.CLOSED()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)this.CLOSED(), (Object)this.CLOSE())), (Object)this.CLOSED()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)this.RELEASED(), (Object)this.MAINTENANCE())), (Object)this.RELEASED()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)this.ACQUIRED(), (Object)this.MAINTENANCE())), (Object)this.ACQUIRED())}));
        this.currentValidStamp = new AtomicLong(this.RELEASED_STATE_MACHINE_STAMP());
        this.lastValidStamp = 0L;
    }

    private abstract class OPERATION {
        private final String name;
        public final /* synthetic */ RocksDBStateMachine $outer;

        public String toString() {
            return this.name;
        }

        public /* synthetic */ RocksDBStateMachine org$apache$spark$sql$execution$streaming$state$RocksDBStateMachine$OPERATION$$$outer() {
            return this.$outer;
        }

        public OPERATION(RocksDBStateMachine $outer, String name) {
            this.name = name;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }

    private interface STATE {
    }
}

