/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.spark_core.protobuf;

import org.sparkproject.spark_core.protobuf.Android;
import org.sparkproject.spark_core.protobuf.CheckReturnValue;
import org.sparkproject.spark_core.protobuf.ExtensionSchemas;
import org.sparkproject.spark_core.protobuf.GeneratedMessageInfoFactory;
import org.sparkproject.spark_core.protobuf.GeneratedMessageLite;
import org.sparkproject.spark_core.protobuf.Internal;
import org.sparkproject.spark_core.protobuf.ListFieldSchemas;
import org.sparkproject.spark_core.protobuf.MapFieldSchemas;
import org.sparkproject.spark_core.protobuf.MessageInfo;
import org.sparkproject.spark_core.protobuf.MessageInfoFactory;
import org.sparkproject.spark_core.protobuf.MessageSchema;
import org.sparkproject.spark_core.protobuf.MessageSetSchema;
import org.sparkproject.spark_core.protobuf.NewInstanceSchemas;
import org.sparkproject.spark_core.protobuf.Schema;
import org.sparkproject.spark_core.protobuf.SchemaFactory;
import org.sparkproject.spark_core.protobuf.SchemaUtil;

@CheckReturnValue
final class ManifestSchemaFactory
implements SchemaFactory {
    private final MessageInfoFactory messageInfoFactory;
    private static final MessageInfoFactory EMPTY_FACTORY = new MessageInfoFactory(){

        @Override
        public boolean isSupported(Class<?> clazz) {
            return false;
        }

        @Override
        public MessageInfo messageInfoFor(Class<?> clazz) {
            throw new IllegalStateException("This should never be called.");
        }
    };

    public ManifestSchemaFactory() {
        this(ManifestSchemaFactory.getDefaultMessageInfoFactory());
    }

    private ManifestSchemaFactory(MessageInfoFactory messageInfoFactory) {
        this.messageInfoFactory = Internal.checkNotNull(messageInfoFactory, "messageInfoFactory");
    }

    @Override
    public <T> Schema<T> createSchema(Class<T> messageType) {
        SchemaUtil.requireGeneratedMessage(messageType);
        MessageInfo messageInfo = this.messageInfoFactory.messageInfoFor(messageType);
        if (messageInfo.isMessageSetWireFormat()) {
            return ManifestSchemaFactory.useLiteRuntime(messageType) ? MessageSetSchema.newSchema(SchemaUtil.unknownFieldSetLiteSchema(), ExtensionSchemas.lite(), messageInfo.getDefaultInstance()) : MessageSetSchema.newSchema(SchemaUtil.unknownFieldSetFullSchema(), ExtensionSchemas.full(), messageInfo.getDefaultInstance());
        }
        return ManifestSchemaFactory.newSchema(messageType, messageInfo);
    }

    private static <T> Schema<T> newSchema(Class<T> messageType, MessageInfo messageInfo) {
        return ManifestSchemaFactory.useLiteRuntime(messageType) ? MessageSchema.newSchema(messageType, messageInfo, NewInstanceSchemas.lite(), ListFieldSchemas.lite(), SchemaUtil.unknownFieldSetLiteSchema(), ManifestSchemaFactory.allowExtensions(messageInfo) ? ExtensionSchemas.lite() : null, MapFieldSchemas.lite()) : MessageSchema.newSchema(messageType, messageInfo, NewInstanceSchemas.full(), ListFieldSchemas.full(), SchemaUtil.unknownFieldSetFullSchema(), ManifestSchemaFactory.allowExtensions(messageInfo) ? ExtensionSchemas.full() : null, MapFieldSchemas.full());
    }

    private static boolean allowExtensions(MessageInfo messageInfo) {
        switch (messageInfo.getSyntax()) {
            case PROTO3: {
                return false;
            }
        }
        return true;
    }

    private static MessageInfoFactory getDefaultMessageInfoFactory() {
        return new CompositeMessageInfoFactory(GeneratedMessageInfoFactory.getInstance(), ManifestSchemaFactory.getDescriptorMessageInfoFactory());
    }

    private static MessageInfoFactory getDescriptorMessageInfoFactory() {
        if (Android.assumeLiteRuntime) {
            return EMPTY_FACTORY;
        }
        try {
            Class<?> clazz = Class.forName("org.sparkproject.spark_core.protobuf.DescriptorMessageInfoFactory");
            return (MessageInfoFactory)clazz.getDeclaredMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception e) {
            return EMPTY_FACTORY;
        }
    }

    private static boolean useLiteRuntime(Class<?> messageType) {
        return Android.assumeLiteRuntime || GeneratedMessageLite.class.isAssignableFrom(messageType);
    }

    private static class CompositeMessageInfoFactory
    implements MessageInfoFactory {
        private MessageInfoFactory[] factories;

        CompositeMessageInfoFactory(MessageInfoFactory ... factories) {
            this.factories = factories;
        }

        @Override
        public boolean isSupported(Class<?> clazz) {
            for (MessageInfoFactory factory : this.factories) {
                if (!factory.isSupported(clazz)) continue;
                return true;
            }
            return false;
        }

        @Override
        public MessageInfo messageInfoFor(Class<?> clazz) {
            for (MessageInfoFactory factory : this.factories) {
                if (!factory.isSupported(clazz)) continue;
                return factory.messageInfoFor(clazz);
            }
            throw new UnsupportedOperationException("No factory is available for message type: " + clazz.getName());
        }
    }
}

