/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.lib.auth;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.syncope.common.lib.AbstractLDAPConf;
import org.apache.syncope.common.lib.auth.AuthModuleConf;
import org.apache.syncope.common.lib.auth.LDAPDependantAuthModuleConf;
import org.apache.syncope.common.lib.to.AuthModuleTO;
import org.apache.syncope.common.lib.types.X509PolicySetting;
import org.apache.syncope.common.lib.types.X509PrincipalType;
import org.apache.syncope.common.lib.types.X509RevocationCheckerType;
import org.apache.syncope.common.lib.types.X509RevocationFetcherType;
import org.apache.syncope.common.lib.types.X509SubjectDnFormat;

public class X509AuthModuleConf
implements LDAPDependantAuthModuleConf {
    private static final long serialVersionUID = 1915254775199296906L;
    private String name;
    private int order = Integer.MAX_VALUE;
    private int revocationPolicyThreshold = 172800;
    private boolean checkAll;
    private int refreshIntervalSeconds = 3600;
    private boolean throwOnFetchFailure;
    private X509PrincipalType principalType = X509PrincipalType.SUBJECT_DN;
    private String principalAlternateAttribute;
    private X509SubjectDnFormat principalTypeSubjectDnFormat = X509SubjectDnFormat.DEFAULT;
    private String principalTypeSerialNoDnSerialNumberPrefix = "SERIALNUMBER=";
    private String principalTypeSerialNoDnValueDelimiter = ", ";
    private int principalTypeSerialNoSNRadix;
    private boolean principalTypeSerialNoHexSNZeroPadding;
    private X509RevocationCheckerType revocationChecker = X509RevocationCheckerType.NONE;
    private X509RevocationFetcherType crlFetcher = X509RevocationFetcherType.RESOURCE;
    private final List<String> crlResources = new ArrayList<String>(0);
    private int cacheMaxElementsInMemory = 1000;
    private boolean cacheDiskOverflow;
    private String cacheDiskSize = "100MB";
    private boolean cacheEternal;
    private boolean mixedMode = true;
    private long cacheTimeToLiveSeconds = TimeUnit.HOURS.toSeconds(4L);
    private X509PolicySetting crlResourceUnavailablePolicy = X509PolicySetting.DENY;
    private X509PolicySetting crlResourceExpiredPolicy = X509PolicySetting.DENY;
    private X509PolicySetting crlUnavailablePolicy = X509PolicySetting.DENY;
    private X509PolicySetting crlExpiredPolicy = X509PolicySetting.DENY;
    private String regExTrustedIssuerDnPattern;
    private int maxPathLength = 1;
    private boolean maxPathLengthAllowUnspecified = false;
    private boolean checkKeyUsage = false;
    private boolean requireKeyUsage = false;
    private String regExSubjectDnPattern = ".+";
    private boolean extractCert;
    private String sslHeaderName = "ssl_client_cert";
    private LDAP ldap;

    @Override
    public AbstractLDAPConf ldapInstance() {
        return new LDAP();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public int getRevocationPolicyThreshold() {
        return this.revocationPolicyThreshold;
    }

    public void setRevocationPolicyThreshold(int revocationPolicyThreshold) {
        this.revocationPolicyThreshold = revocationPolicyThreshold;
    }

    public boolean isCheckAll() {
        return this.checkAll;
    }

    public void setCheckAll(boolean checkAll) {
        this.checkAll = checkAll;
    }

    public int getRefreshIntervalSeconds() {
        return this.refreshIntervalSeconds;
    }

    public void setRefreshIntervalSeconds(int refreshIntervalSeconds) {
        this.refreshIntervalSeconds = refreshIntervalSeconds;
    }

    public boolean isThrowOnFetchFailure() {
        return this.throwOnFetchFailure;
    }

    public void setThrowOnFetchFailure(boolean throwOnFetchFailure) {
        this.throwOnFetchFailure = throwOnFetchFailure;
    }

    public X509PrincipalType getPrincipalType() {
        return this.principalType;
    }

    public void setPrincipalType(X509PrincipalType principalType) {
        this.principalType = principalType;
    }

    public String getPrincipalAlternateAttribute() {
        return this.principalAlternateAttribute;
    }

    public void setPrincipalAlternateAttribute(String principalAlternateAttribute) {
        this.principalAlternateAttribute = principalAlternateAttribute;
    }

    public X509SubjectDnFormat getPrincipalTypeSubjectDnFormat() {
        return this.principalTypeSubjectDnFormat;
    }

    public void setPrincipalTypeSubjectDnFormat(X509SubjectDnFormat principalTypeSubjectDnFormat) {
        this.principalTypeSubjectDnFormat = principalTypeSubjectDnFormat;
    }

    public String getPrincipalTypeSerialNoDnSerialNumberPrefix() {
        return this.principalTypeSerialNoDnSerialNumberPrefix;
    }

    public void setPrincipalTypeSerialNoDnSerialNumberPrefix(String principalTypeSerialNoDnSerialNumberPrefix) {
        this.principalTypeSerialNoDnSerialNumberPrefix = principalTypeSerialNoDnSerialNumberPrefix;
    }

    public String getPrincipalTypeSerialNoDnValueDelimiter() {
        return this.principalTypeSerialNoDnValueDelimiter;
    }

    public void setPrincipalTypeSerialNoDnValueDelimiter(String principalTypeSerialNoDnValueDelimiter) {
        this.principalTypeSerialNoDnValueDelimiter = principalTypeSerialNoDnValueDelimiter;
    }

    public int getPrincipalTypeSerialNoSNRadix() {
        return this.principalTypeSerialNoSNRadix;
    }

    public void setPrincipalTypeSerialNoSNRadix(int principalTypeSerialNoSNRadix) {
        this.principalTypeSerialNoSNRadix = principalTypeSerialNoSNRadix;
    }

    public boolean isPrincipalTypeSerialNoHexSNZeroPadding() {
        return this.principalTypeSerialNoHexSNZeroPadding;
    }

    public void setPrincipalTypeSerialNoHexSNZeroPadding(boolean principalTypeSerialNoHexSNZeroPadding) {
        this.principalTypeSerialNoHexSNZeroPadding = principalTypeSerialNoHexSNZeroPadding;
    }

    public X509RevocationCheckerType getRevocationChecker() {
        return this.revocationChecker;
    }

    public void setRevocationChecker(X509RevocationCheckerType revocationChecker) {
        this.revocationChecker = revocationChecker;
    }

    public X509RevocationFetcherType getCrlFetcher() {
        return this.crlFetcher;
    }

    public void setCrlFetcher(X509RevocationFetcherType crlFetcher) {
        this.crlFetcher = crlFetcher;
    }

    public int getCacheMaxElementsInMemory() {
        return this.cacheMaxElementsInMemory;
    }

    public void setCacheMaxElementsInMemory(int cacheMaxElementsInMemory) {
        this.cacheMaxElementsInMemory = cacheMaxElementsInMemory;
    }

    public boolean isCacheDiskOverflow() {
        return this.cacheDiskOverflow;
    }

    public void setCacheDiskOverflow(boolean cacheDiskOverflow) {
        this.cacheDiskOverflow = cacheDiskOverflow;
    }

    public String getCacheDiskSize() {
        return this.cacheDiskSize;
    }

    public void setCacheDiskSize(String cacheDiskSize) {
        this.cacheDiskSize = cacheDiskSize;
    }

    public boolean isCacheEternal() {
        return this.cacheEternal;
    }

    public void setCacheEternal(boolean cacheEternal) {
        this.cacheEternal = cacheEternal;
    }

    public boolean isMixedMode() {
        return this.mixedMode;
    }

    public void setMixedMode(boolean mixedMode) {
        this.mixedMode = mixedMode;
    }

    public long getCacheTimeToLiveSeconds() {
        return this.cacheTimeToLiveSeconds;
    }

    public void setCacheTimeToLiveSeconds(long cacheTimeToLiveSeconds) {
        this.cacheTimeToLiveSeconds = cacheTimeToLiveSeconds;
    }

    public X509PolicySetting getCrlResourceUnavailablePolicy() {
        return this.crlResourceUnavailablePolicy;
    }

    public void setCrlResourceUnavailablePolicy(X509PolicySetting crlResourceUnavailablePolicy) {
        this.crlResourceUnavailablePolicy = crlResourceUnavailablePolicy;
    }

    public X509PolicySetting getCrlResourceExpiredPolicy() {
        return this.crlResourceExpiredPolicy;
    }

    public void setCrlResourceExpiredPolicy(X509PolicySetting crlResourceExpiredPolicy) {
        this.crlResourceExpiredPolicy = crlResourceExpiredPolicy;
    }

    public X509PolicySetting getCrlUnavailablePolicy() {
        return this.crlUnavailablePolicy;
    }

    public void setCrlUnavailablePolicy(X509PolicySetting crlUnavailablePolicy) {
        this.crlUnavailablePolicy = crlUnavailablePolicy;
    }

    public X509PolicySetting getCrlExpiredPolicy() {
        return this.crlExpiredPolicy;
    }

    public void setCrlExpiredPolicy(X509PolicySetting crlExpiredPolicy) {
        this.crlExpiredPolicy = crlExpiredPolicy;
    }

    public List<String> getCrlResources() {
        return this.crlResources;
    }

    public String getRegExTrustedIssuerDnPattern() {
        return this.regExTrustedIssuerDnPattern;
    }

    public void setRegExTrustedIssuerDnPattern(String regExTrustedIssuerDnPattern) {
        this.regExTrustedIssuerDnPattern = regExTrustedIssuerDnPattern;
    }

    public int getMaxPathLength() {
        return this.maxPathLength;
    }

    public void setMaxPathLength(int maxPathLength) {
        this.maxPathLength = maxPathLength;
    }

    public boolean isMaxPathLengthAllowUnspecified() {
        return this.maxPathLengthAllowUnspecified;
    }

    public void setMaxPathLengthAllowUnspecified(boolean maxPathLengthAllowUnspecified) {
        this.maxPathLengthAllowUnspecified = maxPathLengthAllowUnspecified;
    }

    public boolean isCheckKeyUsage() {
        return this.checkKeyUsage;
    }

    public void setCheckKeyUsage(boolean checkKeyUsage) {
        this.checkKeyUsage = checkKeyUsage;
    }

    public boolean isRequireKeyUsage() {
        return this.requireKeyUsage;
    }

    public void setRequireKeyUsage(boolean requireKeyUsage) {
        this.requireKeyUsage = requireKeyUsage;
    }

    public String getRegExSubjectDnPattern() {
        return this.regExSubjectDnPattern;
    }

    public void setRegExSubjectDnPattern(String regExSubjectDnPattern) {
        this.regExSubjectDnPattern = regExSubjectDnPattern;
    }

    public boolean isExtractCert() {
        return this.extractCert;
    }

    public void setExtractCert(boolean extractCert) {
        this.extractCert = extractCert;
    }

    public String getSslHeaderName() {
        return this.sslHeaderName;
    }

    public void setSslHeaderName(String sslHeaderName) {
        this.sslHeaderName = sslHeaderName;
    }

    public LDAP getLdap() {
        return this.ldap;
    }

    public void setLdap(LDAP ldap) {
        this.ldap = ldap;
    }

    @Override
    public Map<String, Object> map(AuthModuleTO authModule, AuthModuleConf.Mapper mapper) {
        return mapper.map(authModule, this);
    }

    public static class LDAP
    extends AbstractLDAPConf
    implements Serializable {
        private static final long serialVersionUID = -7274446267090678730L;
        private String certificateAttribute = "certificateRevocationList";

        public String getCertificateAttribute() {
            return this.certificateAttribute;
        }

        public void setCertificateAttribute(String certificateAttribute) {
            this.certificateAttribute = certificateAttribute;
        }
    }
}

