/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.monitor;

import java.util.Formatter;
import lombok.Generated;
import org.apereo.cas.monitor.CacheStatistics;

public class SimpleCacheStatistics
implements CacheStatistics {
    private static final double BYTES_PER_MB = 1048510.0;
    private static final int PERCENTAGE_VALUE = 100;
    private final long size;
    private final long capacity;
    private final long evictions;
    private final String name;

    public SimpleCacheStatistics(long size, long capacity, long evictions) {
        this(size, capacity, evictions, "N/A");
    }

    public long getPercentFree() {
        if (this.capacity == 0L) {
            return 0L;
        }
        return (this.capacity - this.size) * 100L / this.capacity;
    }

    public String toString(StringBuilder builder) {
        if (this.name != null) {
            builder.append(this.name).append(':');
        }
        try (Formatter formatter = new Formatter(builder);){
            formatter.format("%.2f", (double)this.size / 1048510.0);
        }
        builder.append("MB used, ");
        builder.append(this.getPercentFree()).append(" percent free, ");
        builder.append(this.evictions).append(" evictions");
        return builder.toString();
    }

    @Generated
    public long getSize() {
        return this.size;
    }

    @Generated
    public long getCapacity() {
        return this.capacity;
    }

    @Generated
    public long getEvictions() {
        return this.evictions;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public SimpleCacheStatistics(long size, long capacity, long evictions, String name) {
        this.size = size;
        this.capacity = capacity;
        this.evictions = evictions;
        this.name = name;
    }
}

