/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.data;

import java.io.Serializable;
import java.util.Optional;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.RealmTO;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.common.lib.types.ResourceOperation;
import org.apache.syncope.core.persistence.api.dao.AnyTypeDAO;
import org.apache.syncope.core.persistence.api.dao.ExternalResourceDAO;
import org.apache.syncope.core.persistence.api.dao.ImplementationDAO;
import org.apache.syncope.core.persistence.api.dao.PolicyDAO;
import org.apache.syncope.core.persistence.api.dao.RealmDAO;
import org.apache.syncope.core.persistence.api.entity.AnyTemplateRealm;
import org.apache.syncope.core.persistence.api.entity.AnyType;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.ExternalResource;
import org.apache.syncope.core.persistence.api.entity.Implementation;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.persistence.api.entity.policy.AccessPolicy;
import org.apache.syncope.core.persistence.api.entity.policy.AccountPolicy;
import org.apache.syncope.core.persistence.api.entity.policy.AttrReleasePolicy;
import org.apache.syncope.core.persistence.api.entity.policy.AuthPolicy;
import org.apache.syncope.core.persistence.api.entity.policy.PasswordPolicy;
import org.apache.syncope.core.persistence.api.entity.policy.Policy;
import org.apache.syncope.core.persistence.api.entity.policy.TicketExpirationPolicy;
import org.apache.syncope.core.provisioning.api.PropagationByResource;
import org.apache.syncope.core.provisioning.api.data.RealmDataBinder;
import org.apache.syncope.core.provisioning.java.utils.TemplateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RealmDataBinderImpl
implements RealmDataBinder {
    protected static final Logger LOG = LoggerFactory.getLogger(RealmDataBinder.class);
    protected final AnyTypeDAO anyTypeDAO;
    protected final ImplementationDAO implementationDAO;
    protected final RealmDAO realmDAO;
    protected final PolicyDAO policyDAO;
    protected final ExternalResourceDAO resourceDAO;
    protected final EntityFactory entityFactory;

    public RealmDataBinderImpl(AnyTypeDAO anyTypeDAO, ImplementationDAO implementationDAO, RealmDAO realmDAO, PolicyDAO policyDAO, ExternalResourceDAO resourceDAO, EntityFactory entityFactory) {
        this.anyTypeDAO = anyTypeDAO;
        this.implementationDAO = implementationDAO;
        this.realmDAO = realmDAO;
        this.policyDAO = policyDAO;
        this.resourceDAO = resourceDAO;
        this.entityFactory = entityFactory;
    }

    protected void setTemplates(RealmTO realmTO, Realm realm) {
        TemplateUtils.check(realmTO.getTemplates(), ClientExceptionType.InvalidRealm);
        realmTO.getTemplates().forEach((key, template) -> {
            AnyType type = this.anyTypeDAO.find(key);
            if (type == null) {
                LOG.debug("Invalid AnyType {} specified, ignoring...", key);
            } else {
                AnyTemplateRealm anyTemplate = realm.getTemplate(type).orElse(null);
                if (anyTemplate == null) {
                    anyTemplate = (AnyTemplateRealm)this.entityFactory.newEntity(AnyTemplateRealm.class);
                    anyTemplate.setAnyType(type);
                    anyTemplate.setRealm(realm);
                    realm.add(anyTemplate);
                }
                anyTemplate.set(template);
            }
        });
        realm.getTemplates().removeIf(template -> !realmTO.getTemplates().containsKey(template.getAnyType().getKey()));
    }

    public Realm create(Realm parent, RealmTO realmTO) {
        Policy policy;
        Realm realm = (Realm)this.entityFactory.newEntity(Realm.class);
        realm.setName(realmTO.getName());
        realm.setParent(parent);
        if (realmTO.getPasswordPolicy() != null) {
            policy = this.policyDAO.find(realmTO.getPasswordPolicy());
            if (policy instanceof PasswordPolicy) {
                realm.setPasswordPolicy((PasswordPolicy)policy);
            } else {
                SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidPolicy);
                sce.getElements().add("Expected " + PasswordPolicy.class.getSimpleName() + ", found " + policy.getClass().getSimpleName());
                throw sce;
            }
        }
        if (realmTO.getAccountPolicy() != null) {
            policy = this.policyDAO.find(realmTO.getAccountPolicy());
            if (policy instanceof AccountPolicy) {
                realm.setAccountPolicy((AccountPolicy)policy);
            } else {
                SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidPolicy);
                sce.getElements().add("Expected " + AccountPolicy.class.getSimpleName() + ", found " + policy.getClass().getSimpleName());
                throw sce;
            }
        }
        if (realmTO.getAuthPolicy() != null) {
            policy = this.policyDAO.find(realmTO.getAuthPolicy());
            if (policy instanceof AuthPolicy) {
                realm.setAuthPolicy((AuthPolicy)policy);
            } else {
                SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidPolicy);
                sce.getElements().add("Expected " + AuthPolicy.class.getSimpleName() + ", found " + policy.getClass().getSimpleName());
                throw sce;
            }
        }
        if (realmTO.getAccessPolicy() != null) {
            policy = this.policyDAO.find(realmTO.getAccessPolicy());
            if (policy instanceof AccessPolicy) {
                realm.setAccessPolicy((AccessPolicy)policy);
            } else {
                SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidPolicy);
                sce.getElements().add("Expected " + AccessPolicy.class.getSimpleName() + ", found " + policy.getClass().getSimpleName());
                throw sce;
            }
        }
        if (realmTO.getAttrReleasePolicy() != null) {
            policy = this.policyDAO.find(realmTO.getAttrReleasePolicy());
            if (policy instanceof AttrReleasePolicy) {
                realm.setAttrReleasePolicy((AttrReleasePolicy)policy);
            } else {
                SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidPolicy);
                sce.getElements().add("Expected " + AttrReleasePolicy.class.getSimpleName() + ", found " + policy.getClass().getSimpleName());
                throw sce;
            }
        }
        if (realmTO.getTicketExpirationPolicy() != null) {
            policy = this.policyDAO.find(realmTO.getTicketExpirationPolicy());
            if (policy instanceof TicketExpirationPolicy) {
                realm.setTicketExpirationPolicy((TicketExpirationPolicy)policy);
            } else {
                SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidPolicy);
                sce.getElements().add("Expected " + TicketExpirationPolicy.class.getSimpleName() + ", found " + policy.getClass().getSimpleName());
                throw sce;
            }
        }
        realmTO.getActions().forEach(logicActionsKey -> {
            Implementation logicAction = this.implementationDAO.find(logicActionsKey);
            if (logicAction == null) {
                LOG.debug("Invalid " + Implementation.class.getSimpleName() + " {}, ignoring...", logicActionsKey);
            } else {
                realm.add(logicAction);
            }
        });
        this.setTemplates(realmTO, realm);
        realmTO.getResources().forEach(resourceKey -> {
            ExternalResource resource = this.resourceDAO.find(resourceKey);
            if (resource == null) {
                LOG.debug("Invalid " + ExternalResource.class.getSimpleName() + " {}, ignoring...", resourceKey);
            } else {
                realm.add(resource);
            }
        });
        return realm;
    }

    public PropagationByResource<String> update(Realm realm, RealmTO realmTO) {
        Policy policy;
        realm.setName(realmTO.getName());
        realm.setParent(realmTO.getParent() == null ? null : this.realmDAO.find(realmTO.getParent()));
        if (realmTO.getAccountPolicy() == null) {
            realm.setAccountPolicy(null);
        } else {
            policy = this.policyDAO.find(realmTO.getAccountPolicy());
            if (policy instanceof AccountPolicy) {
                realm.setAccountPolicy((AccountPolicy)policy);
            } else {
                SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidPolicy);
                sce.getElements().add("Expected " + AccountPolicy.class.getSimpleName() + ", found " + policy.getClass().getSimpleName());
                throw sce;
            }
        }
        if (realmTO.getPasswordPolicy() == null) {
            realm.setPasswordPolicy(null);
        } else {
            policy = this.policyDAO.find(realmTO.getPasswordPolicy());
            if (policy instanceof PasswordPolicy) {
                realm.setPasswordPolicy((PasswordPolicy)policy);
            } else {
                SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidPolicy);
                sce.getElements().add("Expected " + PasswordPolicy.class.getSimpleName() + ", found " + policy.getClass().getSimpleName());
                throw sce;
            }
        }
        if (realmTO.getAuthPolicy() == null) {
            realm.setAuthPolicy(null);
        } else {
            policy = this.policyDAO.find(realmTO.getAuthPolicy());
            if (policy instanceof AuthPolicy) {
                realm.setAuthPolicy((AuthPolicy)policy);
            } else {
                SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidPolicy);
                sce.getElements().add("Expected " + AuthPolicy.class.getSimpleName() + ", found " + policy.getClass().getSimpleName());
                throw sce;
            }
        }
        if (realmTO.getAccessPolicy() == null) {
            realm.setAccessPolicy(null);
        } else {
            policy = this.policyDAO.find(realmTO.getAccessPolicy());
            if (policy instanceof AccessPolicy) {
                realm.setAccessPolicy((AccessPolicy)policy);
            } else {
                SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidPolicy);
                sce.getElements().add("Expected " + AccessPolicy.class.getSimpleName() + ", found " + policy.getClass().getSimpleName());
                throw sce;
            }
        }
        if (realmTO.getAttrReleasePolicy() == null) {
            realm.setAttrReleasePolicy(null);
        } else {
            policy = this.policyDAO.find(realmTO.getAttrReleasePolicy());
            if (policy instanceof AttrReleasePolicy) {
                realm.setAttrReleasePolicy((AttrReleasePolicy)policy);
            } else {
                SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidPolicy);
                sce.getElements().add("Expected " + AttrReleasePolicy.class.getSimpleName() + ", found " + policy.getClass().getSimpleName());
                throw sce;
            }
        }
        if (realmTO.getTicketExpirationPolicy() == null) {
            realm.setTicketExpirationPolicy(null);
        } else {
            policy = this.policyDAO.find(realmTO.getTicketExpirationPolicy());
            if (policy instanceof TicketExpirationPolicy) {
                realm.setTicketExpirationPolicy((TicketExpirationPolicy)policy);
            } else {
                SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidPolicy);
                sce.getElements().add("Expected " + TicketExpirationPolicy.class.getSimpleName() + ", found " + policy.getClass().getSimpleName());
                throw sce;
            }
        }
        realmTO.getActions().forEach(logicActionsKey -> {
            Implementation logicActions = this.implementationDAO.find(logicActionsKey);
            if (logicActions == null) {
                LOG.debug("Invalid " + Implementation.class.getSimpleName() + " {}, ignoring...", logicActionsKey);
            } else {
                realm.add(logicActions);
            }
        });
        realm.getActions().removeIf(implementation -> !realmTO.getActions().contains(implementation.getKey()));
        this.setTemplates(realmTO, realm);
        PropagationByResource propByRes = new PropagationByResource();
        realmTO.getResources().forEach(resourceKey -> {
            ExternalResource resource = this.resourceDAO.find(resourceKey);
            if (resource == null) {
                LOG.debug("Invalid " + ExternalResource.class.getSimpleName() + " {}, ignoring...", resourceKey);
            } else {
                realm.add(resource);
                propByRes.add(ResourceOperation.CREATE, (Serializable)((Object)resource.getKey()));
            }
        });
        realm.getResources().removeIf(resource -> {
            boolean contained = realmTO.getResources().contains(resource.getKey());
            if (!contained) {
                propByRes.add(ResourceOperation.DELETE, (Serializable)((Object)resource.getKey()));
            }
            return !contained;
        });
        return propByRes;
    }

    public RealmTO getRealmTO(Realm realm, boolean admin) {
        RealmTO realmTO = new RealmTO();
        realmTO.setKey(realm.getKey());
        realmTO.setName(realm.getName());
        Optional.ofNullable(realm.getParent()).ifPresent(parent -> realmTO.setParent(parent.getKey()));
        realmTO.setFullPath(realm.getFullPath());
        if (admin) {
            Optional.ofNullable(realm.getAccountPolicy()).ifPresent(policy -> realmTO.setAccountPolicy(policy.getKey()));
            Optional.ofNullable(realm.getPasswordPolicy()).ifPresent(policy -> realmTO.setPasswordPolicy(policy.getKey()));
            Optional.ofNullable(realm.getAuthPolicy()).ifPresent(policy -> realmTO.setAuthPolicy(policy.getKey()));
            Optional.ofNullable(realm.getAccessPolicy()).ifPresent(policy -> realmTO.setAccessPolicy(policy.getKey()));
            Optional.ofNullable(realm.getAttrReleasePolicy()).ifPresent(policy -> realmTO.setAttrReleasePolicy(policy.getKey()));
            Optional.ofNullable(realm.getTicketExpirationPolicy()).ifPresent(policy -> realmTO.setTicketExpirationPolicy(policy.getKey()));
            realm.getActions().forEach(action -> realmTO.getActions().add(action.getKey()));
            realm.getTemplates().forEach(template -> realmTO.getTemplates().put(template.getAnyType().getKey(), template.get()));
            realm.getResources().forEach(resource -> realmTO.getResources().add(resource.getKey()));
        }
        return realmTO;
    }
}

