/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.u2f.storage;

import java.io.Serializable;
import java.util.Collection;
import org.apereo.cas.adaptors.u2f.storage.U2FDeviceRegistration;
import org.apereo.cas.util.crypto.CipherExecutor;

public interface U2FDeviceRepository {
    public Collection<? extends U2FDeviceRegistration> getRegisteredDevices(String var1);

    public Collection<? extends U2FDeviceRegistration> getRegisteredDevices();

    public U2FDeviceRegistration registerDevice(U2FDeviceRegistration var1);

    public U2FDeviceRegistration verifyRegisteredDevice(U2FDeviceRegistration var1);

    public void deleteRegisteredDevice(U2FDeviceRegistration var1);

    public boolean isDeviceRegisteredFor(String var1);

    public String getDeviceRegistrationRequest(String var1, String var2);

    public String getDeviceAuthenticationRequest(String var1, String var2);

    public void requestDeviceRegistration(String var1, String var2, String var3);

    public void requestDeviceAuthentication(String var1, String var2, String var3);

    public void clean();

    public void removeAll() throws Exception;

    public CipherExecutor<Serializable, String> getCipherExecutor();

    default public U2FDeviceRegistration decode(U2FDeviceRegistration registration) {
        U2FDeviceRegistration record = registration.clone();
        String data = (String)this.getCipherExecutor().decode((Object)record.getRecord());
        record.setRecord(data);
        return record;
    }
}

