/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.utils;

import java.io.Closeable;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.jaxrs.utils.AnnotationUtils;
import org.apache.cxf.jaxrs.utils.InjectionUtils;

public final class JAXBUtils {
    private static final Logger LOG = LogUtils.getL7dLogger(JAXBUtils.class);

    private JAXBUtils() {
    }

    public static JAXBContext createJaxbContext(Set<Class<?>> classes, Class<?>[] extraClass, Map<String, Object> contextProperties) {
        if (classes == null || classes.isEmpty()) {
            return null;
        }
        org.apache.cxf.common.jaxb.JAXBUtils.scanPackages(classes, (Class[])extraClass, null);
        try {
            JAXBContext ctx = JAXBContext.newInstance((Class[])classes.toArray(new Class[0]), contextProperties);
            return ctx;
        }
        catch (JAXBException ex) {
            LOG.log(Level.SEVERE, "No JAXB context can be created", ex);
            return null;
        }
    }

    public static void closeUnmarshaller(Unmarshaller u) {
        if (u instanceof Closeable) {
            try {
                ((Closeable)u).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static Object convertWithAdapter(Object obj, Class<?> adapterClass, Annotation[] anns) {
        return JAXBUtils.useAdapter(obj, JAXBUtils.getAdapter(adapterClass, anns), false, obj);
    }

    public static Class<?> getValueTypeFromAdapter(Class<?> expectedBoundType, Class<?> defaultClass, Annotation[] anns) {
        try {
            Class<?> boundType;
            XmlJavaTypeAdapter adapter = JAXBUtils.getAdapter(expectedBoundType, anns);
            if (adapter != null && (boundType = JAXBUtils.getTypeFromAdapter(adapter, null, true)) != null && boundType.isAssignableFrom(expectedBoundType)) {
                return JAXBUtils.getTypeFromAdapter(adapter, null, false);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return defaultClass;
    }

    public static XmlJavaTypeAdapter getAdapter(Class<?> objectClass, Annotation[] anns) {
        XmlJavaTypeAdapter typeAdapter = AnnotationUtils.getAnnotation(anns, XmlJavaTypeAdapter.class);
        if (typeAdapter == null && (typeAdapter = objectClass.getAnnotation(XmlJavaTypeAdapter.class)) == null) {
            Class<?>[] interfaces = objectClass.getInterfaces();
            typeAdapter = interfaces.length > 0 ? interfaces[0].getAnnotation(XmlJavaTypeAdapter.class) : null;
        }
        return typeAdapter;
    }

    public static Class<?> getTypeFromAdapter(XmlJavaTypeAdapter adapter, Class<?> theType, boolean boundType) {
        if (adapter != null) {
            if (adapter.type() != XmlJavaTypeAdapter.DEFAULT.class) {
                theType = adapter.type();
            } else {
                Type topAdapterType = adapter.value().getGenericSuperclass();
                Class superClass = adapter.value().getSuperclass();
                while (superClass != null) {
                    Class nextSuperClass = superClass.getSuperclass();
                    if (nextSuperClass != null && !Object.class.equals(nextSuperClass)) {
                        topAdapterType = superClass.getGenericSuperclass();
                    }
                    superClass = nextSuperClass;
                }
                Type[] types = InjectionUtils.getActualTypes(topAdapterType);
                if (types != null && types.length == 2) {
                    int index = boundType ? 1 : 0;
                    theType = InjectionUtils.getActualType(types[index]);
                }
            }
        }
        return theType;
    }

    public static Object useAdapter(Object obj, XmlJavaTypeAdapter typeAdapter, boolean marshal) {
        return JAXBUtils.useAdapter(obj, typeAdapter, marshal, obj);
    }

    public static Object useAdapter(Object obj, XmlJavaTypeAdapter typeAdapter, boolean marshal, Object defaultValue) {
        if (typeAdapter != null) {
            try {
                XmlAdapter xmlAdapter = (XmlAdapter)typeAdapter.value().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                if (marshal) {
                    return xmlAdapter.marshal(obj);
                }
                return xmlAdapter.unmarshal(obj);
            }
            catch (Exception ex) {
                LOG.log(Level.INFO, "(un)marshalling failed, using defaultValue", ex);
            }
        }
        return defaultValue;
    }
}

