/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.protocol.delivery;

import com.tc.bytes.TCByteBuffer;
import com.tc.net.protocol.AbstractTCNetworkHeader;
import com.tc.net.protocol.TCProtocolException;
import com.tc.util.UUID;
import java.io.UnsupportedEncodingException;

class OOOProtocolMessageHeader
extends AbstractTCNetworkHeader {
    public static final short TYPE_HANDSHAKE = 1;
    public static final short TYPE_HANDSHAKE_REPLY_OK = 2;
    public static final short TYPE_HANDSHAKE_REPLY_FAIL = 3;
    public static final short TYPE_ACK = 4;
    public static final short TYPE_SEND = 5;
    public static final short TYPE_GOODBYE = 6;
    public static final String[] typeNames = new String[]{"N/A", "TYPE_HANDSHAKE", "TYPE_HANDSHAKE_REPLY_OK", "TYPE_HANDSHAKE_REPLY_FAIL", "TYPE_ACK", "TYPE_SEND", "TYPE_GOODBYE"};
    public static final short VERSION = 2;
    private static final int MAGIC_NUM = -1145324613;
    private static final int MAGIC_NUM_OFFSET = 0;
    private static final int MAGIC_NUM_LENGTH = 4;
    private static final int VERSION_OFFSET = 4;
    private static final int VERSION_LENGTH = 1;
    private static final int TYPE_OFFSET = 5;
    private static final int TYPE_LENGTH = 1;
    private static final int SEQUENCE_OFFSET = 6;
    private static final int SEQUENCE_LENGTH = 8;
    private static final int ACK_OFFSET = 14;
    private static final int ACK_LENGTH = 8;
    private static final int SESSION_OFFSET = 22;
    private static final int SESSION_LENGTH = UUID.SIZE;
    static final int HEADER_LENGTH;

    OOOProtocolMessageHeader(short version, short type, long ackSequence, UUID sessionId) {
        this(version, type, -1L, ackSequence, sessionId);
    }

    OOOProtocolMessageHeader(short version, short type, long sequence, long ackSequence, UUID sessionId) {
        super(HEADER_LENGTH, HEADER_LENGTH);
        this.putValues(version, type, sequence, ackSequence, sessionId);
        try {
            this.validate();
        }
        catch (TCProtocolException e) {
            throw new InternalError();
        }
    }

    OOOProtocolMessageHeader(TCByteBuffer buffer) {
        super(buffer, HEADER_LENGTH, HEADER_LENGTH);
    }

    @Override
    public int getHeaderByteLength() {
        return HEADER_LENGTH;
    }

    private void putValues(short version, short type, long sequence, long ackSequence, UUID sessionId) {
        this.data.putInt(0, -1145324613);
        this.data.putUbyte(4, version);
        this.data.putUbyte(5, type);
        this.data.putLong(6, sequence);
        this.data.putLong(14, ackSequence);
        try {
            this.data.put(22, sessionId.toString().getBytes("UTF-8"), 0, SESSION_LENGTH);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("OOO SessionID encoding error : " + e);
        }
    }

    @Override
    protected void setHeaderLength(short headerLength) {
        throw new UnsupportedOperationException("These messages are fixed length.");
    }

    @Override
    public void validate() throws TCProtocolException {
        int magic = this.getMagicNumber();
        if (magic != -1145324613) {
            throw new TCProtocolException("Bad magic number: " + magic + " != " + -1145324613);
        }
        short version = this.getVersion();
        if (this.getVersion() != 2) {
            throw new TCProtocolException("Reported version " + version + " is not equal to supported version: " + 2);
        }
        short type = this.getType();
        if (!this.isValidType(type)) {
            throw new TCProtocolException("Unknown message type: " + type);
        }
        boolean ack = this.isAck();
        boolean ackReq = this.isHandshake();
        boolean send = this.isSend();
        if (ack && (ackReq || send)) {
            throw new TCProtocolException("Invalid type, ack= " + ack + ", ackRe=" + ackReq + ", send=" + send);
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Type=" + typeNames[this.getType()]);
        buf.append(" sessId=" + this.getSession());
        buf.append(" seq=" + this.getSequence());
        return buf.toString();
    }

    private int getMagicNumber() {
        return this.data.getInt(0);
    }

    private short getVersion() {
        return this.data.getUbyte(4);
    }

    private short getType() {
        return this.data.getUbyte(5);
    }

    private boolean isValidType(short type) {
        return type == 5 || type == 1 || type == 2 || type == 3 || type == 4 || type == 6;
    }

    long getSequence() {
        return this.data.getLong(6);
    }

    long getAckSequence() {
        return this.data.getLong(14);
    }

    UUID getSession() {
        byte[] session = new byte[SESSION_LENGTH];
        this.data.get(22, session, 0, SESSION_LENGTH);
        try {
            return new UUID(new String(session, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("OOO SessionID encoding error : " + e);
        }
    }

    boolean isHandshake() {
        return this.getType() == 1;
    }

    boolean isHandshakeReplyOk() {
        return this.getType() == 2;
    }

    boolean isHandshakeReplyFail() {
        return this.getType() == 3;
    }

    boolean isAck() {
        return this.getType() == 4;
    }

    boolean isSend() {
        return this.getType() == 5;
    }

    boolean isGoodbye() {
        return this.getType() == 6;
    }

    static {
        int tmp = 22 + SESSION_LENGTH;
        HEADER_LENGTH = (tmp + 3) / 4 * 4;
    }
}

