/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.openapi;

import io.swagger.v3.jaxrs2.integration.ServletConfigContextUtils;
import io.swagger.v3.jaxrs2.integration.resources.BaseOpenApiResource;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.integration.GenericOpenApiContext;
import io.swagger.v3.oas.integration.OpenApiContextLocator;
import io.swagger.v3.oas.integration.api.OpenAPIConfiguration;
import io.swagger.v3.oas.integration.api.OpenApiContext;
import io.swagger.v3.oas.models.OpenAPI;
import jakarta.servlet.ServletConfig;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Application;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.Objects;
import org.apache.cxf.jaxrs.openapi.OpenApiCustomizer;

@Path(value="/openapi.{type:json|yaml}")
public class OpenApiCustomizedResource
extends BaseOpenApiResource {
    private final OpenApiCustomizer customizer;

    public OpenApiCustomizedResource(OpenApiCustomizer customizer) {
        this.customizer = customizer;
    }

    @GET
    @Produces(value={"application/json", "application/yaml"})
    @Operation(hidden=true)
    public Response getOpenApi(@Context Application app, @Context ServletConfig config, @Context HttpHeaders headers, @Context UriInfo uriInfo, @PathParam(value="type") String type) throws Exception {
        if (this.customizer != null) {
            OpenAPIConfiguration configuration = this.customizer.customize(this.getOpenApiConfiguration());
            this.setOpenApiConfiguration(configuration);
            OpenApiContext ctx = this.getOpenApiContext(config);
            if (ctx == null) {
                ctx = this.getOpenApiContext(null);
            }
            if (ctx instanceof GenericOpenApiContext) {
                ((GenericOpenApiContext)ctx).getOpenApiReader().setConfiguration(configuration);
                OpenAPI oas = ctx.read();
                this.customizer.customize(oas);
                if (!Objects.equals(configuration.getOpenAPI().getInfo(), oas.getInfo())) {
                    configuration.getOpenAPI().setInfo(oas.getInfo());
                }
                if (!Objects.equals(configuration.getOpenAPI().getComponents(), oas.getComponents())) {
                    configuration.getOpenAPI().setComponents(oas.getComponents());
                }
                if (!Objects.equals(configuration.getOpenAPI().getExternalDocs(), oas.getExternalDocs())) {
                    configuration.getOpenAPI().setExternalDocs(oas.getExternalDocs());
                }
                if (!Objects.equals(configuration.getOpenAPI().getPaths(), oas.getPaths())) {
                    configuration.getOpenAPI().setPaths(oas.getPaths());
                }
                if (!Objects.equals(configuration.getOpenAPI().getTags(), oas.getTags())) {
                    configuration.getOpenAPI().setTags(oas.getTags());
                }
                if (!Objects.equals(configuration.getOpenAPI().getExtensions(), oas.getExtensions())) {
                    configuration.getOpenAPI().setExtensions(oas.getExtensions());
                }
            }
        }
        return super.getOpenApi(headers, config, app, uriInfo, type);
    }

    private OpenApiContext getOpenApiContext(ServletConfig config) {
        String ctxId = ServletConfigContextUtils.getContextIdFromServletConfig((ServletConfig)config);
        return OpenApiContextLocator.getInstance().getOpenApiContext(ctxId);
    }
}

