/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import java.io.Serializable;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.syncope.client.console.SyncopeWebApplication;
import org.apache.syncope.client.console.commons.RealmPolicyProvider;
import org.apache.syncope.client.console.rest.AnyTypeClassRestClient;
import org.apache.syncope.client.console.rest.ImplementationRestClient;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionsPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxDropDownChoicePanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxGridFieldPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxPalettePanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxTextFieldPanel;
import org.apache.syncope.common.lib.Attr;
import org.apache.syncope.common.lib.to.AnyTypeClassTO;
import org.apache.syncope.common.lib.to.ImplementationTO;
import org.apache.syncope.common.lib.to.RealmTO;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.markup.repeater.RepeatingView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.util.ListModel;
import org.apache.wicket.model.util.MapModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RealmDetails
extends Panel {
    private static final long serialVersionUID = -1100228004207271270L;
    protected static final Logger LOG = LoggerFactory.getLogger(RealmDetails.class);
    protected final IModel<List<String>> anyTypeClasses = new LoadableDetachableModel<List<String>>(){
        private static final long serialVersionUID = 5275935387613157437L;

        protected List<String> load() {
            return RealmDetails.this.anyTypeClassRestClient.list().stream().map(AnyTypeClassTO::getKey).sorted().collect(Collectors.toList());
        }
    };
    protected final IModel<List<String>> logicActions = new LoadableDetachableModel<List<String>>(){
        private static final long serialVersionUID = 5275935387613157437L;

        protected List<String> load() {
            return RealmDetails.this.implementationRestClient.list("LOGIC_ACTIONS").stream().map(ImplementationTO::getKey).sorted().collect(Collectors.toList());
        }
    };
    protected final LoadableDetachableModel<List<String>> resources = new LoadableDetachableModel<List<String>>(){
        private static final long serialVersionUID = 5275935387613157437L;

        protected List<String> load() {
            return SyncopeWebApplication.get().getResourceProvider().getForRealms();
        }
    };
    @SpringBean
    protected AnyTypeClassRestClient anyTypeClassRestClient;
    @SpringBean
    protected ImplementationRestClient implementationRestClient;
    @SpringBean
    protected RealmPolicyProvider realmPolicyProvider;
    protected final WebMarkupContainer container = new WebMarkupContainer("container");
    protected final AjaxDropDownChoicePanel<String> anyTypeClass;

    public RealmDetails(String id, RealmTO realmTO) {
        this(id, realmTO, null, true);
    }

    public RealmDetails(String id, RealmTO realmTO, ActionsPanel<RealmTO> actionsPanel, boolean unwrapped) {
        super(id);
        this.container.setOutputMarkupId(true);
        this.container.setRenderBodyOnly(unwrapped);
        this.add(new Component[]{this.container});
        WebMarkupContainer generics = new WebMarkupContainer("generics");
        this.container.add(new Component[]{generics});
        AjaxTextFieldPanel name = new AjaxTextFieldPanel("name", "name", (IModel)new PropertyModel((Object)realmTO, "name"), false);
        generics.add(new Component[]{name.addRequiredLabel().setVisible(unwrapped)});
        AjaxTextFieldPanel fullPath = new AjaxTextFieldPanel("fullPath", "fullPath", (IModel)new PropertyModel((Object)realmTO, "fullPath"), false);
        fullPath.setEnabled(false);
        generics.add(new Component[]{fullPath.setVisible(unwrapped)});
        this.anyTypeClass = new AjaxDropDownChoicePanel("anyTypeClass", "anyTypeClass", (IModel)new PropertyModel((Object)realmTO, "anyTypeClass"), true);
        this.anyTypeClass.setChoices((List)this.anyTypeClasses.getObject());
        generics.add(new Component[]{this.anyTypeClass});
        Map<String, String> attrs = realmTO.getPlainAttrs().stream().sorted(Comparator.comparing(Attr::getSchema)).collect(Collectors.toMap(Attr::getSchema, attr -> attr.getValues().toString()));
        this.container.add(new Component[]{new AjaxGridFieldPanel("plainAttrs", "plainAttrs", (IModel)new MapModel(attrs), true).setOutputMarkupPlaceholderTag(true).setVisible(!unwrapped)});
        RepeatingView policies = new RepeatingView("policies");
        this.realmPolicyProvider.add(realmTO, policies);
        this.container.add(new Component[]{policies});
        if (unwrapped) {
            this.container.add(new Component[]{new AjaxPalettePanel.Builder().setAllowMoveAll(true).setAllowOrder(true).build("actions", (IModel)new PropertyModel((Object)realmTO, "actions"), (IModel)new ListModel((List)this.logicActions.getObject())).setOutputMarkupId(true)});
        } else {
            this.container.add(new Component[]{new AjaxTextFieldPanel("actions", "actions", (IModel)Model.of((Serializable)((Object)realmTO.getActions().toString())))});
        }
        if (unwrapped) {
            this.container.add(new Component[]{new AjaxPalettePanel.Builder().build("resources", (IModel)new PropertyModel((Object)realmTO, "resources"), (IModel)new ListModel((List)this.resources.getObject())).setOutputMarkupId(true).setEnabled(!"/".equals(realmTO.getName())).setVisible(!"/".equals(realmTO.getName()))});
        } else {
            this.container.add(new Component[]{new AjaxTextFieldPanel("resources", "resources", (IModel)Model.of((Serializable)((Object)realmTO.getResources().toString())))});
        }
        if (actionsPanel == null) {
            this.add(new Component[]{new Fragment("actionsPanel", "emptyFragment", (MarkupContainer)this).setRenderBodyOnly(true)});
        } else {
            Fragment fragment = new Fragment("actionsPanel", "actionsFragment", (MarkupContainer)this);
            fragment.add(new Component[]{actionsPanel});
            this.add(new Component[]{fragment.setRenderBodyOnly(true)});
        }
    }

    public RealmDetails setContentEnabled(boolean enable) {
        this.container.setEnabled(enable);
        return this;
    }

    public Optional<String> getAnyTypeClassValue() {
        return Optional.ofNullable((String)((Object)this.anyTypeClass.getModelObject()));
    }
}

