/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.atlas.impl;

import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.NoopRegistry;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.atlas.AtlasConfig;
import com.netflix.spectator.atlas.impl.IdMapper;
import com.netflix.spectator.atlas.impl.JsonUtils;
import com.netflix.spectator.atlas.impl.QueryIndex;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;

public interface EvaluatorConfig {
    public static EvaluatorConfig fromAtlasConfig(final AtlasConfig config) {
        if (config instanceof EvaluatorConfig) {
            return (EvaluatorConfig)((Object)config);
        }
        return new EvaluatorConfig(){

            @Override
            public long evaluatorStepSize() {
                return config.lwcStep().toMillis();
            }

            @Override
            public Map<String, String> commonTags() {
                return config.commonTags();
            }

            @Override
            public BiFunction<Id, Set<String>, Map<String, String>> idMapper() {
                return new IdMapper(JsonUtils.createReplacementFunction(config.validTagCharacters()));
            }
        };
    }

    public long evaluatorStepSize();

    public Map<String, String> commonTags();

    default public BiFunction<Id, Set<String>, Map<String, String>> idMapper() {
        return new IdMapper(Function.identity());
    }

    default public <T> QueryIndex.CacheSupplier<T> indexCacheSupplier() {
        return new QueryIndex.DefaultCacheSupplier((Registry)new NoopRegistry());
    }

    default public boolean parallelMeasurementPolling() {
        return false;
    }

    default public boolean delayGaugeAggregation() {
        return false;
    }
}

