/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.webauthn.api;

import org.springframework.security.web.webauthn.api.AuthenticatorAttachment;
import org.springframework.security.web.webauthn.api.ResidentKeyRequirement;
import org.springframework.security.web.webauthn.api.UserVerificationRequirement;

public final class AuthenticatorSelectionCriteria {
    private final AuthenticatorAttachment authenticatorAttachment;
    private final ResidentKeyRequirement residentKey;
    private final UserVerificationRequirement userVerification;

    private AuthenticatorSelectionCriteria(AuthenticatorAttachment authenticatorAttachment, ResidentKeyRequirement residentKey, UserVerificationRequirement userVerification) {
        this.authenticatorAttachment = authenticatorAttachment;
        this.residentKey = residentKey;
        this.userVerification = userVerification;
    }

    public AuthenticatorAttachment getAuthenticatorAttachment() {
        return this.authenticatorAttachment;
    }

    public ResidentKeyRequirement getResidentKey() {
        return this.residentKey;
    }

    public UserVerificationRequirement getUserVerification() {
        return this.userVerification;
    }

    public static AuthenticatorSelectionCriteriaBuilder builder() {
        return new AuthenticatorSelectionCriteriaBuilder();
    }

    public static final class AuthenticatorSelectionCriteriaBuilder {
        private AuthenticatorAttachment authenticatorAttachment;
        private ResidentKeyRequirement residentKey;
        private UserVerificationRequirement userVerification;

        private AuthenticatorSelectionCriteriaBuilder() {
        }

        public AuthenticatorSelectionCriteriaBuilder authenticatorAttachment(AuthenticatorAttachment authenticatorAttachment) {
            this.authenticatorAttachment = authenticatorAttachment;
            return this;
        }

        public AuthenticatorSelectionCriteriaBuilder residentKey(ResidentKeyRequirement residentKey) {
            this.residentKey = residentKey;
            return this;
        }

        public AuthenticatorSelectionCriteriaBuilder userVerification(UserVerificationRequirement userVerification) {
            this.userVerification = userVerification;
            return this;
        }

        public AuthenticatorSelectionCriteria build() {
            return new AuthenticatorSelectionCriteria(this.authenticatorAttachment, this.residentKey, this.userVerification);
        }
    }
}

