/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudwatch.model.CloudWatchResponse;
import software.amazon.awssdk.services.cloudwatch.model.ManagedRuleDescription;
import software.amazon.awssdk.services.cloudwatch.model.ManagedRuleDescriptionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListManagedInsightRulesResponse
extends CloudWatchResponse
implements ToCopyableBuilder<Builder, ListManagedInsightRulesResponse> {
    private static final SdkField<List<ManagedRuleDescription>> MANAGED_RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ManagedRules").getter(ListManagedInsightRulesResponse.getter(ListManagedInsightRulesResponse::managedRules)).setter(ListManagedInsightRulesResponse.setter(Builder::managedRules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManagedRules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ManagedRuleDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListManagedInsightRulesResponse.getter(ListManagedInsightRulesResponse::nextToken)).setter(ListManagedInsightRulesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MANAGED_RULES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListManagedInsightRulesResponse.memberNameToFieldInitializer();
    private final List<ManagedRuleDescription> managedRules;
    private final String nextToken;

    private ListManagedInsightRulesResponse(BuilderImpl builder) {
        super(builder);
        this.managedRules = builder.managedRules;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasManagedRules() {
        return this.managedRules != null && !(this.managedRules instanceof SdkAutoConstructList);
    }

    public final List<ManagedRuleDescription> managedRules() {
        return this.managedRules;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasManagedRules() ? this.managedRules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListManagedInsightRulesResponse)) {
            return false;
        }
        ListManagedInsightRulesResponse other = (ListManagedInsightRulesResponse)((Object)obj);
        return this.hasManagedRules() == other.hasManagedRules() && Objects.equals(this.managedRules(), other.managedRules()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListManagedInsightRulesResponse").add("ManagedRules", this.hasManagedRules() ? this.managedRules() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ManagedRules": {
                return Optional.ofNullable(clazz.cast(this.managedRules()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ManagedRules", MANAGED_RULES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListManagedInsightRulesResponse, T> g) {
        return obj -> g.apply((ListManagedInsightRulesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudWatchResponse.BuilderImpl
    implements Builder {
        private List<ManagedRuleDescription> managedRules = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListManagedInsightRulesResponse model) {
            super(model);
            this.managedRules(model.managedRules);
            this.nextToken(model.nextToken);
        }

        public final List<ManagedRuleDescription.Builder> getManagedRules() {
            List<ManagedRuleDescription.Builder> result = ManagedRuleDescriptionsCopier.copyToBuilder(this.managedRules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setManagedRules(Collection<ManagedRuleDescription.BuilderImpl> managedRules) {
            this.managedRules = ManagedRuleDescriptionsCopier.copyFromBuilder(managedRules);
        }

        @Override
        public final Builder managedRules(Collection<ManagedRuleDescription> managedRules) {
            this.managedRules = ManagedRuleDescriptionsCopier.copy(managedRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder managedRules(ManagedRuleDescription ... managedRules) {
            this.managedRules(Arrays.asList(managedRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder managedRules(Consumer<ManagedRuleDescription.Builder> ... managedRules) {
            this.managedRules(Stream.of(managedRules).map(c -> (ManagedRuleDescription)((ManagedRuleDescription.Builder)ManagedRuleDescription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListManagedInsightRulesResponse build() {
            return new ListManagedInsightRulesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CloudWatchResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListManagedInsightRulesResponse> {
        public Builder managedRules(Collection<ManagedRuleDescription> var1);

        public Builder managedRules(ManagedRuleDescription ... var1);

        public Builder managedRules(Consumer<ManagedRuleDescription.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

