/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.flowable.dmn.api.ExpressionExecution;
import org.flowable.dmn.api.RuleExecutionAuditContainer;
import org.flowable.dmn.model.DecisionRule;
import org.flowable.dmn.model.HitPolicy;
import org.joda.time.DateTime;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class DecisionExecutionAuditContainer {
    protected String decisionKey;
    protected String decisionName;
    protected int decisionVersion;
    protected String hitPolicy;
    protected String dmnDeploymentId;
    protected Date startTime;
    protected Date endTime;
    protected Map<String, Object> inputVariables;
    protected Map<String, String> inputVariableTypes;
    protected List<Map<String, Object>> decisionResult = new ArrayList<Map<String, Object>>();
    protected boolean multipleResults = false;
    protected Map<String, String> decisionResultTypes = new HashMap<String, String>();
    protected Map<Integer, RuleExecutionAuditContainer> ruleExecutions = new HashMap<Integer, RuleExecutionAuditContainer>();
    protected Boolean failed = Boolean.FALSE;
    protected String exceptionMessage;
    protected String validationMessage;
    protected Boolean strictMode;

    public DecisionExecutionAuditContainer() {
    }

    public DecisionExecutionAuditContainer(String decisionKey, String decisionName, int decisionVersion, Boolean strictMode, Map<String, Object> inputVariables, Date startTime) {
        this.startTime = startTime;
        this.decisionKey = decisionKey;
        this.decisionName = decisionName;
        this.decisionVersion = decisionVersion;
        this.strictMode = strictMode;
        this.inputVariableTypes = this.getVariablesTypeMap(inputVariables);
        this.inputVariables = this.createDefensiveCopyInputVariables(inputVariables);
    }

    public DecisionExecutionAuditContainer(String decisionKey, String decisionName, int decisionVersion, HitPolicy hitPolicy, Boolean strictMode, Map<String, Object> inputVariables, Date startTime) {
        this.startTime = startTime;
        this.decisionKey = decisionKey;
        this.decisionName = decisionName;
        this.decisionVersion = decisionVersion;
        this.hitPolicy = hitPolicy.getValue();
        this.strictMode = strictMode;
        this.inputVariableTypes = this.getVariablesTypeMap(inputVariables);
        this.inputVariables = this.createDefensiveCopyInputVariables(inputVariables);
    }

    protected Map<String, String> getVariablesTypeMap(Map<String, Object> variableValuesMap) {
        HashMap<String, String> variablesTypesMap = new HashMap<String, String>();
        if (variableValuesMap == null || variableValuesMap.isEmpty()) {
            return variablesTypesMap;
        }
        for (String name : variableValuesMap.keySet()) {
            Object value = variableValuesMap.get(name);
            String type = null;
            if (value != null) {
                type = DecisionExecutionAuditContainer.isDate(value) ? "date" : (DecisionExecutionAuditContainer.isNumber(value) ? "number" : (DecisionExecutionAuditContainer.isBoolean(value) ? "boolean" : "string"));
            }
            variablesTypesMap.put(name, type);
        }
        return variablesTypesMap;
    }

    public void stopAudit(Date endTime) {
        this.endTime = endTime;
    }

    public void addRuleEntry(DecisionRule rule) {
        this.ruleExecutions.put(rule.getRuleNumber(), new RuleExecutionAuditContainer(rule.getRuleNumber()));
    }

    public void markRuleEnd(int ruleNumber) {
        this.ruleExecutions.get(ruleNumber).markRuleEnd();
    }

    public void markRuleValid(int ruleNumber) {
        this.ruleExecutions.get(ruleNumber).setValid();
    }

    public void addInputEntry(int ruleNumber, String inputEntryId, Boolean executionResult) {
        this.ruleExecutions.get(ruleNumber).addConditionResult(new ExpressionExecution(inputEntryId, executionResult));
    }

    public void addInputEntry(int ruleNumber, String inputEntryId, String exceptionMessage, Boolean executionResult) {
        this.ruleExecutions.get(ruleNumber).addConditionResult(new ExpressionExecution(inputEntryId, exceptionMessage, executionResult));
    }

    public void addOutputEntry(int ruleNumber, String outputEntryId, Object executionResult) {
        this.ruleExecutions.get(ruleNumber).addConclusionResult(new ExpressionExecution(outputEntryId, executionResult));
    }

    public void addOutputEntry(int ruleNumber, String outputEntryId, String exceptionMessage, Object executionResult) {
        this.ruleExecutions.get(ruleNumber).addConclusionResult(new ExpressionExecution(outputEntryId, exceptionMessage, executionResult));
    }

    public void setDecisionResult(List<Map<String, Object>> decisionResult) {
        this.decisionResult = decisionResult;
    }

    public boolean isMultipleResults() {
        return this.multipleResults;
    }

    public void setMultipleResults(boolean multipleResults) {
        this.multipleResults = multipleResults;
    }

    public void addDecisionResultObject(Map<String, Object> decisionResultObject) {
        this.decisionResult.add(decisionResultObject);
    }

    public String getDecisionKey() {
        return this.decisionKey;
    }

    public String getDecisionName() {
        return this.decisionName;
    }

    public int getDecisionVersion() {
        return this.decisionVersion;
    }

    public String getHitPolicy() {
        return this.hitPolicy;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public Map<String, Object> getInputVariables() {
        return this.inputVariables;
    }

    public Map<Integer, RuleExecutionAuditContainer> getRuleExecutions() {
        return this.ruleExecutions;
    }

    public List<Map<String, Object>> getDecisionResult() {
        return this.decisionResult;
    }

    public String getDmnDeploymentId() {
        return this.dmnDeploymentId;
    }

    public void setDmnDeploymentId(String dmnDeploymentId) {
        this.dmnDeploymentId = dmnDeploymentId;
    }

    public Boolean isFailed() {
        return this.failed;
    }

    public void setFailed() {
        this.failed = Boolean.TRUE;
    }

    public String getExceptionMessage() {
        return this.exceptionMessage;
    }

    public void setExceptionMessage(String exceptionMessage) {
        this.exceptionMessage = exceptionMessage;
    }

    public String getValidationMessage() {
        return this.validationMessage;
    }

    public void setValidationMessage(String validationMessage) {
        this.validationMessage = validationMessage;
    }

    public Boolean isStrictMode() {
        return this.strictMode;
    }

    public void setStrictMode(Boolean strictMode) {
        this.strictMode = strictMode;
    }

    public Map<String, String> getInputVariableTypes() {
        return this.inputVariableTypes;
    }

    public void setInputVariableTypes(Map<String, String> inputVariableTypes) {
        this.inputVariableTypes = inputVariableTypes;
    }

    public Map<String, String> getDecisionResultTypes() {
        return this.decisionResultTypes;
    }

    public void addDecisionResultType(String decisionResultId, String decisionResultType) {
        this.decisionResultTypes.put(decisionResultId, decisionResultType);
    }

    protected static boolean isBoolean(Object obj) {
        return obj instanceof Boolean;
    }

    protected static boolean isDate(Object obj) {
        return obj instanceof Date || obj instanceof DateTime || obj instanceof org.joda.time.LocalDate || obj instanceof LocalDate || obj instanceof LocalDateTime || obj instanceof Instant;
    }

    protected static boolean isNumber(Object obj) {
        return obj instanceof Number;
    }

    protected Map<String, Object> createDefensiveCopyInputVariables(Map<String, Object> inputVariables) {
        HashMap<String, Object> defensiveCopyMap = new HashMap<String, Object>();
        if (inputVariables != null) {
            for (Map.Entry<String, Object> entry : inputVariables.entrySet()) {
                Object newValue = null;
                if (entry.getValue() != null) {
                    newValue = entry.getValue() instanceof Long ? Long.valueOf((Long)entry.getValue()) : (entry.getValue() instanceof Double ? Double.valueOf((Double)entry.getValue()) : (entry.getValue() instanceof Integer ? Integer.valueOf((Integer)entry.getValue()) : (entry.getValue() instanceof Date ? new Date(((Date)entry.getValue()).getTime()) : (entry.getValue() instanceof Boolean ? Boolean.valueOf((Boolean)entry.getValue()) : new String(entry.getValue().toString())))));
                }
                defensiveCopyMap.put(entry.getKey(), newValue);
            }
        }
        return defensiveCopyMap;
    }
}

