/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.protocol;

import java.util.HashSet;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.protocol.Errors;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ErrorsTest {
    @Test
    public void testUniqueErrorCodes() {
        HashSet<Short> codeSet = new HashSet<Short>();
        for (Errors error : Errors.values()) {
            codeSet.add(error.code());
        }
        Assertions.assertEquals((int)codeSet.size(), (int)Errors.values().length, (String)"Error codes must be unique");
    }

    @Test
    public void testUniqueExceptions() {
        HashSet exceptionSet = new HashSet();
        for (Errors error : Errors.values()) {
            if (error == Errors.NONE) continue;
            exceptionSet.add(error.exception().getClass());
        }
        Assertions.assertEquals((int)exceptionSet.size(), (int)(Errors.values().length - 1), (String)"Exceptions must be unique");
    }

    @Test
    public void testExceptionsAreNotGeneric() {
        for (Errors error : Errors.values()) {
            if (error == Errors.NONE) continue;
            Assertions.assertNotEquals(error.exception().getClass(), ApiException.class, (String)"Generic ApiException should not be used");
        }
    }

    @Test
    public void testNoneException() {
        Assertions.assertNull((Object)Errors.NONE.exception(), (String)"The NONE error should not have an exception");
    }

    @Test
    public void testForExceptionInheritance() {
        Errors expectedError = Errors.forException((Throwable)new TimeoutException());
        class ExtendedTimeoutException
        extends TimeoutException {
            ExtendedTimeoutException() {
            }
        }
        Errors actualError = Errors.forException((Throwable)((Object)new ExtendedTimeoutException()));
        Assertions.assertEquals((Object)expectedError, (Object)actualError, (String)"forException should match super classes");
    }

    @Test
    public void testForExceptionDefault() {
        Errors error = Errors.forException((Throwable)new ApiException());
        Assertions.assertEquals((Object)Errors.UNKNOWN_SERVER_ERROR, (Object)error, (String)"forException should default to unknown");
    }

    @Test
    public void testExceptionName() {
        String exceptionName = Errors.UNKNOWN_SERVER_ERROR.exceptionName();
        Assertions.assertEquals((Object)"org.apache.kafka.common.errors.UnknownServerException", (Object)exceptionName);
        exceptionName = Errors.NONE.exceptionName();
        Assertions.assertNull((Object)exceptionName);
        exceptionName = Errors.INVALID_TOPIC_EXCEPTION.exceptionName();
        Assertions.assertEquals((Object)"org.apache.kafka.common.errors.InvalidTopicException", (Object)exceptionName);
    }
}

