/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web.response.callback.mode;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apereo.cas.support.oauth.OAuth20ResponseModeTypes;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.web.response.callback.OAuth20ResponseModeBuilder;
import org.apereo.cas.support.oauth.web.response.callback.OAuth20ResponseModeFactory;

public class DefaultOAuth20ResponseModeFactory
implements OAuth20ResponseModeFactory {
    private final Map<String, OAuth20ResponseModeBuilder> builders = new LinkedHashMap<String, OAuth20ResponseModeBuilder>();

    @CanIgnoreReturnValue
    public OAuth20ResponseModeFactory registerBuilder(OAuth20ResponseModeBuilder builder) {
        this.builders.put(builder.getResponseMode().getType(), builder);
        return this;
    }

    public OAuth20ResponseModeBuilder getBuilder(OAuthRegisteredService registeredService, OAuth20ResponseModeTypes responseMode) {
        if (OAuth20ResponseModeFactory.isResponseModeTypeFormPost((OAuthRegisteredService)registeredService, (OAuth20ResponseModeTypes)responseMode)) {
            return this.builders.get(OAuth20ResponseModeTypes.FORM_POST.getType());
        }
        if (OAuth20ResponseModeFactory.isResponseModeTypeFragment((OAuthRegisteredService)registeredService, (OAuth20ResponseModeTypes)responseMode)) {
            return this.builders.get(OAuth20ResponseModeTypes.FRAGMENT.getType());
        }
        if (OAuth20ResponseModeFactory.isResponseModeTypeFormPostJwt((OAuthRegisteredService)registeredService, (OAuth20ResponseModeTypes)responseMode)) {
            return this.builders.get(OAuth20ResponseModeTypes.FORM_POST_JWT.getType());
        }
        if (OAuth20ResponseModeFactory.isResponseModeTypeQueryJwt((OAuthRegisteredService)registeredService, (OAuth20ResponseModeTypes)responseMode)) {
            return this.builders.get(OAuth20ResponseModeTypes.QUERY_JWT.getType());
        }
        if (OAuth20ResponseModeFactory.isResponseModeTypeFragmentJwt((OAuthRegisteredService)registeredService, (OAuth20ResponseModeTypes)responseMode)) {
            return this.builders.get(OAuth20ResponseModeTypes.FRAGMENT_JWT.getType());
        }
        return this.builders.get(OAuth20ResponseModeTypes.QUERY.getType());
    }
}

