/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core.security.jacc;

import jakarta.security.jacc.EJBMethodPermission;
import jakarta.security.jacc.EJBRoleRefPermission;
import jakarta.security.jacc.PolicyConfiguration;
import jakarta.security.jacc.PolicyContext;
import jakarta.security.jacc.PolicyContextException;
import jakarta.security.jacc.WebResourcePermission;
import jakarta.security.jacc.WebRoleRefPermission;
import jakarta.security.jacc.WebUserDataPermission;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.ProtectionDomain;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.openejb.core.security.JaccProvider;
import org.apache.openejb.core.security.PolicyJDK24;
import org.apache.openejb.core.security.jacc.BasicPolicyConfiguration;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.spi.SecurityService;

public class BasicJaccProvider
extends JaccProvider {
    private static final Set<Class> JACC_PERMISSIONS = new HashSet<Class>(){
        {
            this.add(EJBMethodPermission.class);
            this.add(EJBRoleRefPermission.class);
            this.add(WebResourcePermission.class);
            this.add(WebRoleRefPermission.class);
            this.add(WebUserDataPermission.class);
        }
    };
    private final Map<String, BasicPolicyConfiguration> configurations = new HashMap<String, BasicPolicyConfiguration>();
    private final Policy systemPolicy = PolicyJDK24.getPolicy();

    @Override
    public PolicyConfiguration getPolicyConfiguration(String contextID, boolean remove) throws PolicyContextException {
        if (contextID == null) {
            throw new IllegalArgumentException("contextID can't be null;");
        }
        BasicPolicyConfiguration configuration = this.configurations.get(contextID);
        if (configuration == null) {
            configuration = this.createPolicyConfiguration(contextID);
            this.configurations.put(contextID, configuration);
        } else {
            configuration.open(remove);
        }
        return configuration;
    }

    @Override
    public PolicyConfiguration getPolicyConfiguration(String contextID) {
        if (contextID == null) {
            throw new IllegalArgumentException("contextID can't be null;");
        }
        return this.configurations.get(contextID);
    }

    @Override
    public PolicyConfiguration getPolicyConfiguration() {
        String contextID = PolicyContext.getContextID();
        if (contextID == null) {
            return null;
        }
        return this.getPolicyConfiguration(contextID);
    }

    protected BasicPolicyConfiguration createPolicyConfiguration(String contextID) {
        return new BasicPolicyConfiguration(contextID);
    }

    @Override
    public boolean inService(String contextID) throws PolicyContextException {
        PolicyConfiguration configuration = this.getPolicyConfiguration(contextID, false);
        return configuration.inService();
    }

    @Override
    public PermissionCollection getPermissions(CodeSource codesource) {
        return this.systemPolicy == null ? null : this.systemPolicy.getPermissions(codesource);
    }

    @Override
    public void refresh() {
    }

    @Override
    public boolean implies(ProtectionDomain domain, Permission permission) {
        String contextID = PolicyContext.getContextID();
        if (contextID != null && JACC_PERMISSIONS.contains(permission.getClass())) {
            try {
                BasicPolicyConfiguration configuration = this.configurations.get(contextID);
                if (configuration == null || !configuration.inService()) {
                    return false;
                }
                return configuration.implies(domain, permission);
            }
            catch (PolicyContextException policyContextException) {
                // empty catch block
            }
        }
        return this.systemPolicy != null && this.systemPolicy.implies(domain, permission);
    }

    @Override
    public boolean hasAccessToWebResource(String resource, String ... methods) {
        SecurityService securityService = SystemInstance.get().getComponent(SecurityService.class);
        if (securityService != null) {
            return this.implies(securityService.getProtectionDomain(), (Permission)new WebResourcePermission(resource, methods));
        }
        return false;
    }

    static {
        try {
            Class.forName(PolicyContext.class.getName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

